/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.model.design.validation;

import com.kingdee.bos.ctrl.ext.pe.animate.AnimatedEditor;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.reporting.FormulaEditor;
import com.kingdee.bos.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.bos.ctrl.ext.reporting.model.ValueEditorType;
import com.kingdee.bos.ctrl.ext.reporting.model.ValueProviderType;
import com.kingdee.bos.ctrl.ext.reporting.model.design.ICellConstraint;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.bos.ctrl.ext.reporting.model.design.editor.CommonSettingPanel;
import com.kingdee.bos.ctrl.ext.reporting.model.design.validation.SelectionChange;
import com.kingdee.bos.ctrl.ext.reporting.model.design.validation.VerifyIntegratePanel;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CellEditorSettingPanel
extends KDPanel
implements SelectionChange {
    private static final long serialVersionUID = 1L;
    private CommonSettingPanel _settingPanel;
    private static Map ediorCache = new HashMap();
    private KDComboBox _valueProviderSelector;
    private ItemListener _valueProviderListener;
    private KDComboBox _valueEditorSelector;
    private ItemListener _valueEditorListener;
    private KDLabelContainer _valueEditorLabel;
    private AnimatedEditor _editableController;
    private KDLabelContainer _editableLabel;
    private KDTabbedPane _mainTab;
    private KDPanel _editorTab;
    private VerifyIntegratePanel _verifyTab;
    private KDPanel _topPanel;
    private KDContainer _editorSettingContainer;
    private ICellConstraint _currentConstraint;
    private SpreadContext _context;
    private boolean _isLoading = false;

    public CellEditorSettingPanel(SpreadContext context) {
        this._context = context;
        this.init();
        this.initListeners();
    }

    public CellEditorSettingPanel(SpreadContext context, ICellConstraint constraint) {
        this._context = context;
        this._currentConstraint = constraint;
        this.init();
        this.initListeners();
    }

    private void init() {
        this._mainTab = new KDTabbedPane();
        this._editorTab = new KDPanel();
        this._verifyTab = new VerifyIntegratePanel(this._context);
        this._mainTab.addTab("\u7f16\u8f91", (Component)this._editorTab);
        this._mainTab.addTab("\u6821\u9a8c", (Component)((Object)this._verifyTab));
        this._editorTab.setLayout((LayoutManager)new BorderLayout());
        this._topPanel = new KDPanel(){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                return new Dimension(0, 60);
            }
        };
        this._topPanel.setLayout((LayoutManager)new FlowLayout(0));
        this._valueProviderSelector = new KDComboBox((Object[])new ValueProviderType[]{ValueProviderType.PRIMARY_KEY_GENERATOR, ValueProviderType.USER_DEFINED_EDITOR});
        this._valueEditorSelector = new KDComboBox();
        this._editableController = new AnimatedEditor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(CellEditorSettingPanel.this._topPanel.getWidth() - 300, 20);
            }
        };
        this._editableController.addEditor((JComponent)new KDCheckBox());
        this._editableController.addEditor((JComponent)((Object)new FormulaEditor()));
        KDLabelContainer c = new KDLabelContainer("\u503c\u63d0\u4f9b\u65b9\u5f0f", (JComponent)this._valueProviderSelector){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                return new Dimension(200, 20);
            }
        };
        c.setBoundLabelUnderline(true);
        c.setBoundLabelLength(80);
        this._topPanel.add((Component)c);
        this._topPanel.add((Component)new KDLabel("   "){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                return new Dimension(CellEditorSettingPanel.this._topPanel.getWidth() - 220, 20);
            }
        });
        this._valueEditorLabel = new KDLabelContainer("\u751f\u6210\u5668\u7c7b\u578b", (JComponent)this._valueEditorSelector){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                return new Dimension(200, 20);
            }
        };
        this._valueEditorLabel.setBoundLabelUnderline(true);
        this._valueEditorLabel.setBoundLabelLength(80);
        this._topPanel.add((Component)this._valueEditorLabel);
        this._editableLabel = new KDLabelContainer("\u53ef\u5199\u63a7\u5236", this._editableController){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                return new Dimension(CellEditorSettingPanel.this._topPanel.getWidth() - 210, 20);
            }
        };
        this._editableLabel.setBoundLabelUnderline(true);
        this._editableLabel.setBoundLabelLength(80);
        this._topPanel.add((Component)this._editableLabel);
        this._editorSettingContainer = new KDContainer();
        this._editorSettingContainer.setContainerType(1);
        this._editorSettingContainer.setTitle("\u5c5e\u6027\u8bbe\u7f6e");
        this._editorTab.add((Component)this._topPanel, (Object)"North");
        this._editorTab.add((Component)this._editorSettingContainer);
        this.setLayout(new BorderLayout());
        this.add((Component)this._mainTab);
    }

    private void initListeners() {
        this._valueProviderListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                ValueProviderType selected = (ValueProviderType)e.getItem();
                CellEditorSettingPanel.this._valueEditorSelector.removeItemListener(CellEditorSettingPanel.this._valueEditorListener);
                CellEditorSettingPanel.this._valueEditorSelector.removeAllItems();
                if (selected == ValueProviderType.PRIMARY_KEY_GENERATOR) {
                    CellEditorSettingPanel.this._valueEditorLabel.setBoundLabelText("\u751f\u6210\u5668\u7c7b\u578b");
                    CellEditorSettingPanel.this._valueEditorSelector.addItems((Object[])new ValueEditorType[]{ValueEditorType.PKGENERATOR});
                    CellEditorSettingPanel.this._topPanel.remove((Component)CellEditorSettingPanel.this._editableLabel);
                } else if (selected == ValueProviderType.USER_DEFINED_EDITOR) {
                    CellEditorSettingPanel.this._valueEditorLabel.setBoundLabelText("\u63a7\u4ef6\u7c7b\u578b");
                    CellEditorSettingPanel.this._valueEditorSelector.addItems((Object[])new ValueEditorType[]{ValueEditorType.TEXTFIELD, ValueEditorType.COMBOBOX, ValueEditorType.F7SELECTOR, ValueEditorType.CHECKBOX, ValueEditorType.DATETIME, ValueEditorType.SPINNER});
                    CellEditorSettingPanel.this._topPanel.add((Component)CellEditorSettingPanel.this._editableLabel);
                }
                CellEditorSettingPanel.this._valueEditorListener.itemStateChanged(new ItemEvent((ItemSelectable)CellEditorSettingPanel.this._valueEditorSelector, 0, CellEditorSettingPanel.this._valueEditorSelector.getItemAt(0), 1));
                CellEditorSettingPanel.this._valueEditorSelector.addItemListener(CellEditorSettingPanel.this._valueEditorListener);
                CellEditorSettingPanel.this._topPanel.revalidate();
                CellEditorSettingPanel.this._topPanel.repaint();
            }
        };
        this._valueProviderSelector.addItemListener(this._valueProviderListener);
        this._valueEditorListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1 || CellEditorSettingPanel.this._currentConstraint == null) {
                    return;
                }
                IEditorDefine ed = CellEditorSettingPanel.this.getEditorDefine(CellEditorSettingPanel.this._currentConstraint);
                if (e.getItem() != ed.getValueEditorType()) {
                    ed = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine((ValueEditorType)e.getItem());
                }
                CellEditorSettingPanel.this.configSettingPanel(ed);
                if (CellEditorSettingPanel.this._settingPanel != null && !CellEditorSettingPanel.this._isLoading) {
                    CellEditorSettingPanel.this.load(ed);
                }
            }
        };
        this._valueEditorSelector.addItemListener(this._valueEditorListener);
    }

    @Override
    public void selectionChange(ICellConstraint lastOne, ICellConstraint newOne) {
        IEditorDefine ed;
        if (this._settingPanel != null && lastOne != null) {
            ed = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine((ValueEditorType)this._valueEditorSelector.getSelectedItem());
            lastOne.setEditorDefine(ed);
            this.saveEnableControl(ed);
            this._settingPanel.save(ed);
            this._verifyTab.updateValidate(lastOne.getVerifyDefine());
        }
        this._currentConstraint = newOne;
        this._verifyTab.updateByValidate(this._currentConstraint.getVerifyDefine());
        ed = this.getEditorDefine(this._currentConstraint);
        this.configSettingPanel(ed);
        if (this._settingPanel != null && this._currentConstraint != null) {
            this.load(ed);
            this._settingPanel.load(ed);
        }
    }

    public void load(ICellConstraint cons) {
        this._currentConstraint = cons;
        this._verifyTab.updateByValidate(this._currentConstraint.getVerifyDefine());
        this.load(this.getEditorDefine(cons));
    }

    private void loadEnableControl(IEditorDefine ed) {
        BooleanVFPair formula = ed.getEnableFormula();
        if (formula == null) {
            formula = new BooleanVFPair(true, null);
        }
        JComponent currentEditor = this._editableController.getCurrentSlide();
        if (formula.hasFormula()) {
            if (!(currentEditor instanceof FormulaEditor)) {
                this._editableController.switchEditor();
                currentEditor = this._editableController.getCurrentSlide();
            }
            ((FormulaEditor)((Object)currentEditor)).setValue(formula.getFormula());
        } else {
            if (!(currentEditor instanceof KDCheckBox)) {
                this._editableController.switchEditor();
                currentEditor = this._editableController.getCurrentSlide();
            }
            ((KDCheckBox)currentEditor).setSelected(formula.getPrimitiveValue());
        }
    }

    public void save() {
        if (this._valueEditorSelector.getSelectedItem() == null || this._currentConstraint == null) {
            return;
        }
        IEditorDefine ed = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine((ValueEditorType)this._valueEditorSelector.getSelectedItem());
        this._currentConstraint.setEditorDefine(ed);
        this.saveEnableControl(ed);
        if (this._settingPanel != null) {
            this._settingPanel.save(ed);
        }
        this._verifyTab.updateValidate(this._currentConstraint.getVerifyDefine());
    }

    private void saveEnableControl(IEditorDefine ed) {
        JComponent currentEditor = this._editableController.getCurrentSlide();
        BooleanVFPair formula = new BooleanVFPair(true, null);
        if (currentEditor instanceof KDCheckBox) {
            formula.setFormula(null);
            formula.setValue(new Boolean(((KDCheckBox)currentEditor).isSelected()));
        } else if (currentEditor instanceof FormulaEditor) {
            Object value = ((FormulaEditor)((Object)currentEditor)).getValue();
            if (value != null) {
                formula.setFormula(String.valueOf(value));
                formula.setValue(Boolean.TRUE);
            } else {
                formula.setFormula(null);
                formula.setValue(Boolean.FALSE);
            }
        }
        ed.setEnableFormula(formula);
    }

    private void load(IEditorDefine constraint) {
        this._isLoading = true;
        this.loadEnableControl(constraint);
        this._valueProviderSelector.removeItemListener(this._valueProviderListener);
        this._valueProviderSelector.removeAllItems();
        this._valueEditorSelector.removeItemListener(this._valueEditorListener);
        this._valueEditorSelector.removeAllItems();
        this._valueProviderSelector.addItems((Object[])new ValueProviderType[]{ValueProviderType.PRIMARY_KEY_GENERATOR, ValueProviderType.USER_DEFINED_EDITOR});
        ValueEditorType current = constraint.getValueEditorType();
        if (current == ValueEditorType.TEXTFIELD || current == ValueEditorType.COMBOBOX || current == ValueEditorType.F7SELECTOR || current == ValueEditorType.CHECKBOX || current == ValueEditorType.DATETIME || current == ValueEditorType.SPINNER) {
            this._valueEditorSelector.addItems((Object[])new ValueEditorType[]{ValueEditorType.TEXTFIELD, ValueEditorType.COMBOBOX, ValueEditorType.F7SELECTOR, ValueEditorType.CHECKBOX, ValueEditorType.DATETIME, ValueEditorType.SPINNER});
            this._valueEditorSelector.setSelectedItem((Object)current);
            this._valueProviderSelector.setSelectedItem((Object)ValueProviderType.USER_DEFINED_EDITOR);
            this._topPanel.add((Component)this._editableLabel);
        } else {
            this._valueEditorSelector.addItems((Object[])new ValueEditorType[]{ValueEditorType.PKGENERATOR});
            this._valueEditorSelector.setSelectedItem((Object)ValueEditorType.PKGENERATOR);
            this._valueProviderSelector.setSelectedItem((Object)ValueProviderType.PRIMARY_KEY_GENERATOR);
            this._topPanel.remove((Component)this._editableLabel);
        }
        this._topPanel.revalidate();
        this._topPanel.repaint();
        this._valueProviderSelector.addItemListener(this._valueProviderListener);
        this._valueEditorSelector.addItemListener(this._valueEditorListener);
        this._isLoading = false;
    }

    private IEditorDefine getEditorDefine(ICellConstraint cons) {
        IEditorDefine ed = cons.getEditorDefine();
        if (ed == null || ed.getValueEditorType() == ValueEditorType.NULLEDITOR) {
            ed = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine(ValueEditorType.TEXTFIELD);
        }
        return ed;
    }

    private void configSettingPanel(IEditorDefine ed) {
        JPanel c;
        if (this._settingPanel != null) {
            c = this._editorSettingContainer.getContentPane();
            c.removeAll();
        }
        this._settingPanel = (CommonSettingPanel)((Object)ediorCache.get(ed.getClass()));
        if (this._settingPanel == null) {
            this._settingPanel = ed.createConfigurator();
            ediorCache.put(ed.getClass(), this._settingPanel);
        }
        if (this._settingPanel != null) {
            c = this._editorSettingContainer.getContentPane();
            c.removeAll();
            c.setLayout(new BorderLayout());
            c.add((Component)((Object)this._settingPanel));
            c.invalidate();
            c.repaint();
        }
    }

    public VerifyIntegratePanel getVerifyIntegratePanel() {
        return this._verifyTab;
    }

    public KDTabbedPane getMainTab() {
        return this._mainTab;
    }

    public void disablePKValueProvider() {
        if (this._valueProviderSelector.getItemCount() == 2) {
            this._valueProviderSelector.removeItemListener(this._valueProviderListener);
            this._valueProviderSelector.setSelectedIndex(1);
            this._valueProviderSelector.removeItem((Object)ValueProviderType.PRIMARY_KEY_GENERATOR);
            this._valueProviderSelector.addItemListener(this._valueProviderListener);
        }
    }
}

