/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.editor.SortEnum;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class DefaultSingleSeriesBean
extends AbstractFusionBean {
    private static final String LABEL = "label";
    private static final String DATA = "data";
    private SortEnum sortType = SortEnum.NORMAL;
    private String[] labels = null;
    private BooleanVFPair chartSum = new BooleanVFPair(false, null);
    private BooleanVFPair drawIn2D = new BooleanVFPair(true, null);

    public DefaultSingleSeriesBean() {
        this.isHyperLinkEnabled = false;
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        super.fillChartNodes(dataNode);
        boolean isSeriesByCol = dataNode.isSerialByCol();
        this.labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        if (data == null || this.labels == null) {
            return;
        }
        if (this.isNeedSort(dataNode)) {
            HashMap map = this.sortProcess(this.labels, data[0]);
            this.labels = (String[])map.get(LABEL);
            data[0] = (double[])map.get(DATA);
        }
        Sheet sheet = dataNode.getSheet();
        ArrayList list = null;
        String dataFormula = dataNode.getDataFormula();
        if (!StringUtil.isEmptyString((String)dataFormula)) {
            list = SheetBaseMath.getListBlockNodes(sheet, dataFormula, sheet.getBook().getDeps().isA1Style());
        }
        CellBlockNode[] cbn = list == null ? null : list.toArray(new CellBlockNode[0]);
        CellBlockNode cb = cbn == null ? null : cbn[0];
        int row = CtrlUtil.Array.getLength((Object[])data);
        int col = 0;
        for (int i = 0; i < row; ++i) {
            col = col < data[i].length ? data[i].length : col;
        }
        double[] values = new double[row * col];
        int index = 0;
        for (int i = 0; i < row; ++i) {
            int len = data[i].length;
            for (int j = 0; j < len; ++j) {
                values[index] = data[i][j];
                ++index;
            }
        }
        int len = Math.min(this.labels.length, values.length);
        this.nodes = new NodeFunc[len];
        if (cb != null) {
            col = cb.getCol();
            row = cb.getRow();
        }
        for (int i = 0; i < len; ++i) {
            Set s = new Set();
            this.nodes[i] = s;
            if (cb != null) {
                String cellRef = isSeriesByCol ? cb.getSheet().getCell(row + i, col, true).getName(false, false) : cb.getSheet().getCell(row, i + col, true).getName(false, false);
                this.nodes[i].setCellRef(cellRef);
            }
            this._hyperlinkCreator.attachHyperLink(sheet, this.labels[i], null, s, (String)dataNode.getFormula(FusionChartDataNode.HYPERLINKDEFINE));
            s.label = this.labels[i];
            s.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[i])) : String.valueOf(values[i]);
            s.link = this.buildLinkProp(s.label, null, String.valueOf(values[i]));
        }
    }

    protected HashMap sortProcess(String[] label, double[] data) {
        switch (this.sortType) {
            case ASC: {
                double mix;
                boolean isAsc;
                if (this.isPieType()) {
                    isAsc = false;
                    mix = -1.7976931348623157E308;
                } else {
                    isAsc = true;
                    mix = Double.MAX_VALUE;
                }
                return this.sort(label, data, mix, isAsc);
            }
            case DESC: {
                double mix;
                boolean isAsc;
                if (this.isPieType()) {
                    isAsc = true;
                    mix = Double.MAX_VALUE;
                } else {
                    isAsc = false;
                    mix = -1.7976931348623157E308;
                }
                return this.sort(label, data, mix, isAsc);
            }
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put(LABEL, label);
        map.put(DATA, data);
        return map;
    }

    protected boolean isNeedSort(FusionChartDataNode dataNode) {
        String[] chartCaptions = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.CHART_CAPTION));
        if (chartCaptions != null && chartCaptions.length >= 42) {
            this.sortType = SortEnum.getSortEnum(chartCaptions[41]);
        }
        return SortEnum.NORMAL != this.sortType;
    }

    public String[] getLables() {
        return this.labels;
    }

    protected boolean isPieType() {
        return false;
    }

    private HashMap sort(String[] label, double[] data, double mix, boolean isAsc) {
        int tempJ = -1;
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        double[] newData = new double[data.length];
        String[] newLabel = new String[label.length];
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            double miax = mix;
            for (int j = 0; j < len; ++j) {
                int result = Double.compare(miax, data[j]);
                if (!(isAsc ? result > 0 : result < 0)) continue;
                tempJ = j;
                miax = data[j];
            }
            newData[i] = miax;
            if (tempJ < 0) continue;
            data[tempJ] = mix;
            newLabel[i] = label[tempJ];
        }
        map.put(LABEL, newLabel);
        map.put(DATA, newData);
        return map;
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        String[] ret = super.buildChartCaptions(dataNode);
        this.chart.is2D = ret != null && ret.length > 36 ? (this.getChart_is2D().getBooleanValue() != false ? "0" : "1") : "1";
        return ret;
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        return cell;
    }

    @Override
    public BooleanVFPair getChartSum() {
        return this.chartSum;
    }

    @Override
    public void setChartSum(BooleanVFPair chartSum) {
        this.chartSum = chartSum;
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        int s = this.nodes.length;
        for (int i = 0; i < s; ++i) {
            if (this.nodes[i].getCellRef() == null) continue;
            ((Set)this.nodes[i]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.nodes[i].getCellRef() + "]" + hyperLinks[0].substring(index2)));
        }
    }

    public BooleanVFPair getDrawIn2D() {
        return this.drawIn2D;
    }

    public void setDrawIn2D(BooleanVFPair drawIn2D) {
        this.drawIn2D = drawIn2D;
    }

    public SortEnum getSortType() {
        return this.sortType;
    }

    public void setSortType(SortEnum sortType) {
        this.sortType = sortType;
    }

    protected String getDemoXML(String chartTypeName, List colors, HashMap numberFormats) {
        String[] demoLabels = DefaultSingleSeriesBean.getDemoLabels();
        int len = demoLabels.length;
        StringBuilder sb = new StringBuilder(DefaultSingleSeriesBean.generateCommonDemoChartTtile(chartTypeName, numberFormats));
        int size = colors.size();
        for (int i = 0; i < size; ++i) {
            String nextColor = (String)colors.get(i);
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            sb.append("<set value='");
            sb.append(Math.random() * 10000.0);
            sb.append("' label='");
            if (i < len) {
                sb.append(demoLabels[i]);
            } else {
                sb.append(demoLabels[len - 1]);
            }
            sb.append("' color='");
            sb.append(color);
            sb.append("' alpha='");
            sb.append(alpha);
            if (i == size - 1) {
                sb.append("' isSliced='1' />");
                continue;
            }
            sb.append("' />");
        }
        sb.append("<styles><definition><style type='font' name='CaptionFont' size='15' color='666666' /><style type='font' name='SubCaptionFont' bold='0' /></definition><application><apply toObject='caption' styles='CaptionFont' /><apply toObject='SubCaption' styles='SubCaptionFont' /></application></styles>");
        sb.append("</chart>");
        return sb.toString();
    }
}

