/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.FloatVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class DefaultXYSeriesBean
extends AbstractFusionBean {
    private String labelSetting = "";
    protected int step = 2;
    private BooleanVFPair showCategrotiesVerticalLine = new BooleanVFPair(false, null);
    private FloatVFPair zAxisScaling = new FloatVFPair(Float.valueOf(1.0f), null);

    public DefaultXYSeriesBean() {
        this.isHyperLinkEnabled = false;
        this.chart_chartBottomMargin = "12";
        this.chart_chartTopMargin = "12";
        this.chart_canvasBorderAlpha = new BooleanVFPair(true, null);
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    public int getSetp() {
        return this.step;
    }

    public String[] parseString(Variant[][] arr) {
        ArrayList<String> list = new ArrayList<String>();
        if (arr != null) {
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                int size1 = arr[0].length;
                for (int j = 0; j < size1; ++j) {
                    if (arr[i][j] == null) continue;
                    list.add(arr[i][j].toString());
                }
            }
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        list.clear();
        if (ret.length == 0) {
            ret = new String[]{""};
        }
        return ret;
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int datasetSize = this.datasets.length;
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        for (int i = 0; i < datasetSize; ++i) {
            int nodesSize = this.datasets[i].nodes.length;
            for (int j = 0; j < nodesSize; ++j) {
                if (this.datasets[i].nodes[j].getCellRef() == null) continue;
                ((Set)this.datasets[i].nodes[j]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.datasets[i].nodes[j].getCellRef() + "]" + hyperLinks[0].substring(index2)));
            }
        }
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        int series = this.datasets.length;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "G" + j;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "S" + i;
                    }
                }
                break;
            }
        }
        return ret;
    }

    public String getLabelSetting() {
        return this.labelSetting;
    }

    public void setLabelSetting(String labelSetting) {
        this.labelSetting = labelSetting;
    }

    protected Variant[][] enlageValues(Variant[][] values, int group, int series, boolean containZ, boolean isSeriesByCol) {
        int j;
        int len2;
        int i;
        Variant[][] ret = null;
        ret = isSeriesByCol ? new Variant[series][group * (containZ ? 3 : 2)] : new Variant[group][series * (containZ ? 3 : 2)];
        int len1 = Math.min(values.length, ret.length);
        for (i = 0; i < len1; ++i) {
            len2 = Math.min(values[i].length, ret[i].length);
            for (j = 0; j < len2; ++j) {
                ret[i][j] = values[i][j];
            }
        }
        len1 = ret.length;
        for (i = 0; i < len1; ++i) {
            len2 = ret[i].length;
            for (j = 0; j < len2; ++j) {
                if (ret[i][j] != null) continue;
                ret[i][j] = new Variant(0);
            }
        }
        return ret;
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        if ("dataset".equals(dataNode.getDataFrom())) {
            this.fillChartNodesByDataset(dataNode);
        } else {
            this.XYChartFill(dataNode);
        }
    }

    protected void fillChartNodesByDataset(FusionChartDataNode dataNode) throws SyntaxErrorException {
        Object[] dataValues = (Object[])dataNode.getData();
        String[] seriesNames = (String[])dataNode.getSeriesKeys();
        String[] groupNames = dataNode.getGroupKeys();
        boolean[] showSeriesGroup = this.showSeriesGroup(dataNode);
        boolean hasZ = this.step == 3;
        ArrayList<Categories.Category> listCategory = new ArrayList<Categories.Category>();
        int lenData = dataValues.length;
        Categories.Category temp = null;
        this.categories = new Categories();
        this.datasets = new Dataset[lenData];
        for (int i = 0; i < lenData; ++i) {
            double[][] data = (double[][])dataValues[i];
            int lenData1 = data.length;
            for (int j = 0; j < lenData1; ++j) {
                temp = new Categories.Category();
                temp.label = String.valueOf((int)data[j][0]);
                temp.x = String.valueOf(data[j][0]);
                listCategory.add(temp);
            }
            this.datasets[i] = new Dataset();
            this.datasets[i].seriesName = seriesNames[i];
            this.datasets[i].nodes = new NodeFunc[lenData1];
            for (int k = 0; k < lenData1; ++k) {
                Set set = new Set();
                this.datasets[i].nodes[k] = set;
                set.x = String.valueOf(data[k][0]);
                set.y = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(data[k][1])) : String.valueOf(data[k][1]);
                if (hasZ) {
                    set.z = String.valueOf(data[k][2]);
                }
                this.setDisplayValue(set, seriesNames, groupNames, showSeriesGroup, i, k);
                set.link = this.buildLinkProp(null, this.datasets[i].seriesName, null);
            }
        }
        this.categories.categories = new Categories.Category[listCategory.size()];
        listCategory.toArray(this.categories.categories);
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        String[] ret = super.buildChartCaptions(dataNode);
        String show = ret == null ? "0" : (ret.length >= 30 ? ret[29] : "0");
        for (int i = this.categories.categories.length - 1; i >= 0; --i) {
            this.categories.categories[i].showVerticalLine = show;
        }
        if (ret != null && ret.length >= 47) {
            this.setZAxisScaling(new FloatVFPair(Float.valueOf(ret[47]), null));
        }
        return ret;
    }

    private void XYChartFill(FusionChartDataNode dataNode) throws SyntaxErrorException {
        Variant[][] variantArray;
        boolean isSeriesByCol = dataNode.isSerialByCol();
        boolean isFillNullWithZero = dataNode.isFillNullWithZero();
        this.categories = new Categories();
        Object obj = dataNode.getData(FusionChartDataNode.XY_Group);
        Variant[][] group = obj == null ? (Variant[][])null : (Variant[][])((Object[])obj)[0];
        String[] groupName = this.parseString(group);
        obj = dataNode.getData(FusionChartDataNode.XY_Series);
        if (obj == null) {
            Variant[][] variantArray2 = new Variant[1][];
            variantArray = variantArray2;
            variantArray2[0] = new Variant[]{Variant.nullVariant};
        } else {
            variantArray = (Variant[][])((Object[])obj)[0];
        }
        Variant[][] series = variantArray;
        String[] seriesName = this.parseString(series);
        int seriesLength = seriesName.length;
        int setLength = 0;
        Variant[][] values = (Variant[][])((Object[])dataNode.getData(FusionChartDataNode.XY_X))[0];
        this.datasets = new Dataset[seriesLength];
        boolean[] showSeriesGroup = this.showSeriesGroup(dataNode);
        ArrayList<Categories.Category> list = new ArrayList<Categories.Category>();
        setLength = values.length;
        int size = setLength;
        for (int i = 0; i < size; ++i) {
            if (!isSeriesByCol) {
                setLength = values[i].length;
            }
            Categories.Category temp = new Categories.Category(String.valueOf(values[i][0].intValue()));
            temp.x = String.valueOf(values[i][0].doubleValue());
            if (list.contains(temp)) continue;
            list.add(temp);
        }
        this.categories.categories = new Categories.Category[list.size()];
        list.toArray(this.categories.categories);
        String formula = (String)dataNode.getFormula(FusionChartDataNode.XY_X);
        Sheet sheet = dataNode.getSheet();
        CellBlockNode[] cb = SheetBaseMath.getArrayBlockNodes(sheet, formula, sheet.getBook().getDeps().isA1Style());
        int cbLength = cb.length;
        boolean hasZ = this.step == 3;
        boolean error = false;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double z = 0.0;
        for (int i = 0; i < seriesLength; ++i) {
            this.datasets[i] = new Dataset();
            this.datasets[i].seriesName = seriesName[i];
            this.datasets[i].showValues = "1";
            this.datasets[i].nodes = new NodeFunc[setLength];
            for (int j = 0; j < setLength; ++j) {
                Set set = new Set();
                this.datasets[i].nodes[j] = set;
                if (isSeriesByCol) {
                    set.x = values[j][i * this.step].equals(Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : String.valueOf(values[j][i * this.step].doubleValue());
                    set.y = values[j][i * this.step + 1].equals(Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[j][i * this.step + 1].doubleValue())) : String.valueOf(values[j][i * this.step + 1].doubleValue()));
                } else {
                    set.x = values[i * this.step][j].equals(Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : String.valueOf(values[i * this.step][j].doubleValue());
                    set.y = values[i * this.step + 1][j].equals(Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[i * this.step + 1][j].doubleValue())) : String.valueOf(values[i * this.step + 1][j].doubleValue()));
                }
                if (hasZ) {
                    try {
                        set.z = !error ? String.valueOf(isSeriesByCol ? values[j][i * this.step + 2].toString() : values[i * this.step + 2][j].toString()) : "1";
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        error = true;
                    }
                    z = (isSeriesByCol ? values[j][i * this.step + 2].doubleValue() : values[i * this.step + 2][j].doubleValue()) * 2.0;
                    minX = Math.min(minX, (isSeriesByCol ? values[j][i * this.step].doubleValue() : values[i * this.step][j].doubleValue()) - z);
                    maxX = Math.max(maxX, (isSeriesByCol ? values[j][i * this.step].doubleValue() : values[i * this.step][j].doubleValue()) + z);
                    minY = Math.min(minY, (isSeriesByCol ? values[j][i * this.step + 1].doubleValue() : values[i * this.step + 1][j].doubleValue()) - z);
                    maxY = Math.max(maxY, (isSeriesByCol ? values[j][i * this.step + 1].doubleValue() : values[i * this.step + 1][j].doubleValue()) + z);
                }
                this.setDisplayValue(set, seriesName, groupName, showSeriesGroup, i, j);
                if (this.isHyperLinkEnabled && this.hyperLinks != null && this.hyperLinks.length > 0) {
                    String cellRef = cbLength > 1 ? (isSeriesByCol ? cb[i].getSheet().getCell(cb[i].getRow() + j, cb[i].getCol(), true).getName(false, false) : cb[j].getSheet().getCell(cb[j].getRow(), cb[j].getCol() + j, true).getName(false, false)) : (isSeriesByCol ? cb[0].getSheet().getCell(cb[0].getRow() + j, cb[0].getCol() + i, true).getName(false, false) : cb[0].getSheet().getCell(cb[0].getRow() + i, cb[0].getCol() + j, true).getName(false, false));
                    this.datasets[i].nodes[j].setCellRef(cellRef);
                }
                set.link = this.buildLinkProp(null, this.datasets[i].seriesName, null);
            }
        }
        if (hasZ) {
            this.chart.yAxisMaxValue = String.valueOf(maxY);
            this.chart.yAxisMinValue = String.valueOf(minY);
            this.chart.xAxisMaxValue = String.valueOf(maxX);
            this.chart.xAxisMinValue = String.valueOf(minX);
        }
    }

    private boolean[] showSeriesGroup(FusionChartDataNode dataNode) {
        boolean[] isShow = new boolean[2];
        isShow[1] = false;
        isShow[0] = false;
        Object[] obj = (Object[])dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        if (obj != null) {
            int len = Array.getLength(obj);
            String[] chartCaptions = new String[len];
            for (int i = 0; i < len; ++i) {
                Variant[][] val = (Variant[][])Array.get(obj, i);
                if (val == null) continue;
                chartCaptions[i] = val[0][0].toString();
            }
            if (chartCaptions.length >= 16) {
                isShow = new boolean[2];
                if (chartCaptions[15].indexOf("\u7cfb\u5217\u540d") != -1) {
                    isShow[0] = true;
                }
                if (chartCaptions[15].indexOf("\u7ec4\u522b\u540d") != -1) {
                    isShow[1] = true;
                }
            }
        }
        return isShow;
    }

    private void setDisplayValue(Set set, String[] seriesNames, String[] groupNames, boolean[] showSeriesGroup, int i, int j) {
        String str1 = this.getValueFromArray(seriesNames, i);
        String str2 = this.getValueFromArray(groupNames, j);
        boolean empty = StringUtil.isEmptyString((String)str2);
        set.displayValue = showSeriesGroup[0] ? str1 + (showSeriesGroup[1] && !empty ? ":" + str2 : "") : (showSeriesGroup[1] ? (empty ? " " : str2) : " ");
    }

    private String getValueFromArray(String[] arr, int i) {
        if (arr == null || i >= arr.length) {
            return "";
        }
        return arr[i];
    }

    public BooleanVFPair getShowCategrotiesVerticalLine() {
        return this.showCategrotiesVerticalLine;
    }

    public void setShowCategrotiesVerticalLine(BooleanVFPair showCategrotiesVerticalLine) {
        this.showCategrotiesVerticalLine = showCategrotiesVerticalLine;
    }

    public FloatVFPair getZAxisScaling() {
        return this.zAxisScaling;
    }

    public void setZAxisScaling(FloatVFPair zAxisScaling) {
        this.zAxisScaling = zAxisScaling;
    }

    @Override
    protected String getDemoXML(List colors, HashMap numberFormats) {
        StringBuilder sb = new StringBuilder(DefaultXYSeriesBean.generateCommonDemoChartTtile("Scatter", numberFormats));
        sb.append("<categories>");
        StringBuilder sb2 = new StringBuilder();
        int i = 1;
        for (String nextColor : colors) {
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            sb.append("<category label='");
            sb.append((i++ - 1) * 20);
            sb.append("' x='");
            sb.append((i - 2) * 20);
            if (i > 2) {
                sb.append("' showVerticalLine='1");
            }
            sb.append("' />");
            sb2.append("<dataset showValues='1' color='");
            sb2.append(color);
            sb2.append("' alpha='");
            sb2.append(alpha);
            sb2.append("' >");
            int len = colors.size();
            for (int j = 0; j < 1; ++j) {
                sb2.append("<set x='");
                sb2.append(Math.random() * (double)len * 20.0);
                sb2.append("' y='");
                sb2.append(Math.random() * 10.0);
                sb2.append("' z='");
                sb2.append(Math.random() * (double)len * 20.0);
                sb2.append("' />");
            }
            sb2.append("</dataset>");
        }
        sb.append("</categories>");
        sb.append(sb2.toString());
        sb.append("</chart>");
        return sb.toString();
    }
}

