/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.gantt;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class GanttUtil {
    public static Date getFirstDayInSeason(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        int season = GanttUtil.getSeasons(GanttUtil.getGroup(date, date, 2))[0];
        switch (season) {
            case 1: {
                cal.set(2, 0);
                break;
            }
            case 2: {
                cal.set(2, 3);
                break;
            }
            case 3: {
                cal.set(2, 6);
                break;
            }
            case 4: {
                cal.set(2, 9);
                break;
            }
        }
        return cal.getTime();
    }

    public static Date getLastDayInSeason(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        int season = GanttUtil.getSeasons(GanttUtil.getGroup(date, date, 2))[0];
        switch (season) {
            case 1: {
                cal.set(2, 2);
                break;
            }
            case 2: {
                cal.set(2, 5);
                break;
            }
            case 3: {
                cal.set(2, 8);
                break;
            }
            case 4: {
                cal.set(2, 11);
                break;
            }
        }
        cal.set(5, GanttUtil.getLastDayOfMonth(cal.get(1), cal.get(2) + 1));
        return cal.getTime();
    }

    public static int getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.get(5);
    }

    public static boolean isLeapYear(int year) {
        if (year % 100 == 0) {
            if (year % 400 == 0) {
                if (year % 3200 == 0) {
                    return year % 172800 == 0;
                }
                return true;
            }
            return false;
        }
        return year % 4 == 0;
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(1);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static int[] getGroup(Date start, Date end, int tag) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        int startTime = cal.get(tag);
        cal.setTime(end);
        int endTime = cal.get(tag);
        int temp1 = Math.min(startTime, endTime);
        int temp2 = Math.max(startTime, endTime);
        return new int[]{temp1, temp2};
    }

    public static int[] getSeasons(int[] months) {
        int[] result = new int[]{0, 0};
        result[0] = months[0] <= 2 ? 1 : (months[0] <= 5 ? 2 : (months[0] <= 8 ? 3 : 4));
        result[1] = months[1] <= 2 ? 1 : (months[1] <= 5 ? 2 : (months[1] <= 8 ? 3 : 4));
        return result;
    }
}

