/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.bizmodel.AbstractParamBizModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen.DataTypeUI;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen.ParamsUI;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.configpen.TreeIO;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreeNodesDropedEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodesPreDroppedListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

class PenUI
extends KDPanel {
    private KDSplitPane _sppLeftRight;
    private KDTreeView _treeView;
    private KDTree _tree;
    private KDPanel _panDetail;
    private InfoPane _panFolder;
    private KDTextField _txtText;
    private KDTextField _txtData;
    private KDTextField _txtFuncName;
    private KDCheckBox _chkFuncName;
    private DataTypeUI _dtReturnType;
    private ParamsUI _paramsUi;
    private KDTextArea _txaExample;
    private KDWorkButton _btnExample;
    private KDWorkButton _btnParamInstead;

    public PenUI() {
        this.init();
        this.installListener();
        this.syncFuncNameState();
        this.syncExampleState();
    }

    private void init() {
        this._sppLeftRight = new KDSplitPane(1);
        this._sppLeftRight.setDividerLocation(200);
        this._tree = new KDTree((ITreeNode)new DefaultKingdeeTreeNode(), false);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        TreeDragHandler tdh = new TreeDragHandler();
        this._tree.addTreeNodesPreDroppedListener((TreeNodesPreDroppedListener)tdh);
        this._tree.setDragNodeEnabled(true);
        this._treeView = new KDTreeView(this._tree);
        this._treeView.setShowButton(false);
        this._treeView.getControlPane().add((Component)new KDWorkButton((Action)new AddFuncAction()));
        this._treeView.getControlPane().add((Component)new KDWorkButton((Action)new AddFolderAction()));
        this._treeView.getControlPane().add((Component)new KDWorkButton((Action)new DelAction()));
        this._paramsUi = new ParamsUI();
        TableLayout2 ly = new TableLayout2(3, 1);
        ly.setFixedHeight(0, 110);
        ly.setFixedHeight(1, 300);
        ly.setRatableHeight(2, 100);
        ly.setRowsSpacing(TableLayout2.ALL, 6);
        this._panDetail = new KDPanel((LayoutManager)ly);
        this._panDetail.add((Component)this.createFuncBasePane(), (Object)TableLayout2.param((int)0, (int)0));
        this._panDetail.add((Component)((Object)this._paramsUi), (Object)TableLayout2.param((int)1, (int)0));
        this._panDetail.add((Component)this.createExamplePane(), (Object)TableLayout2.param((int)2, (int)0));
        this._panFolder = new InfoPane();
        this.updateInfoPane("");
        this._sppLeftRight.setLeftComponent((Component)this._treeView);
        this._sppLeftRight.setRightComponent((Component)((Object)this._panFolder));
        this.setLayout(new BorderLayout());
        this.add((Component)this._sppLeftRight, "Center");
    }

    private KDPanel createFuncBasePane() {
        this._txtText = new KDTextField();
        this._txtData = new KDTextField();
        this._txtFuncName = new KDTextField();
        this._chkFuncName = new KDCheckBox("\u51fd\u6570\u540d\u79f0\u540c\u8282\u70b9\u6587\u5b57");
        KDLabelContainer lbcText = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtText, (String)"\u8282\u70b9\u6587\u5b57", (int)80);
        KDLabelContainer lbcData = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtData, (String)"\u5411\u5bfc\u8f93\u5165", (int)80);
        KDLabelContainer lbcFuncName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtFuncName, (String)"\u51fd\u6570\u540d\u79f0", (int)80);
        this._dtReturnType = new DataTypeUI("\u8fd4\u56de\u503c\u6570\u636e\u7c7b\u578b");
        TableLayout2 ly = new TableLayout2(3, 2);
        ly.setRatableWidth(0, 50);
        ly.setRatableWidth(1, 50);
        ly.setColSpacing(0, 30);
        ly.setFixedHeight(0, 20);
        ly.setFixedHeight(1, 20);
        ly.setRatableHeight(2, 100);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)lbcText, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)lbcData, (Object)TableLayout2.param((int)1, (int)0));
        pan.add((Component)lbcFuncName, (Object)TableLayout2.param((int)0, (int)1));
        pan.add((Component)this._chkFuncName, (Object)TableLayout2.param((int)1, (int)1));
        pan.add((Component)((Object)this._dtReturnType), (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)1));
        return pan;
    }

    private KDPanel createExamplePane() {
        KDLabel labExample = new KDLabel("\u51fd\u6570\u8bf4\u660e\uff1a");
        this._btnExample = new KDWorkButton();
        this._btnParamInstead = new KDWorkButton("\u6dfb\u52a0\u53c2\u6570\u8bf4\u660e\u66ff\u6362\u6807\u8bc6");
        this._txaExample = new KDTextArea();
        this._txaExample.setBorder(null);
        KDScrollPane scpExample = new KDScrollPane((Component)this._txaExample);
        scpExample.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        TableLayout2 ly = new TableLayout2(2, 3);
        ly.setRatableWidth(0, 100);
        ly.setFixedWidth(1, 140);
        ly.setFixedWidth(2, 140);
        ly.setColsSpacing(TableLayout2.ALL, 3);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 100);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)labExample, (Object)TableLayout2.param((int)0, (int)0));
        pan.add((Component)this._btnParamInstead, (Object)TableLayout2.param((int)0, (int)1));
        pan.add((Component)this._btnExample, (Object)TableLayout2.param((int)0, (int)2));
        pan.add((Component)scpExample, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        return pan;
    }

    private void installListener() {
        this._chkFuncName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PenUI.this.syncFuncNameState();
            }
        });
        this._btnExample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PenUI.this.changeExampleState();
            }
        });
        this._btnParamInstead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PenUI.this._txaExample.replaceSelection("[@params]");
            }
        });
        this._tree.addTreeSelectionListener((TreeSelectionListener)new TreeSelectionHandler());
        this._txtText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PenUI.this.syncTreeNode(PenUI.this._txtText.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PenUI.this.syncTreeNode(PenUI.this._txtText.getText());
            }
        });
    }

    private void syncTreeNode(String text) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        node.setText(StringUtil.isEmptyString((String)text) ? "* \u6211\u662f\u8c01 *" : text);
        ((DefaultTreeModel)this._tree.getModel()).nodeChanged((TreeNode)node);
    }

    private void syncFuncNameState() {
        this._txtFuncName.setEnabled(!this._chkFuncName.isSelected());
    }

    private void setExampleState(boolean isEditing) {
        this._txaExample.setEnabled(isEditing);
        this.syncExampleState();
    }

    private void changeExampleState() {
        if (this._txaExample.isEnabled()) {
            this._txaExample.setEnabled(false);
            String oriText = this._txaExample.getText();
            this._txaExample.setUserObject((Object)oriText);
            this.acceptParamEditing();
            String paramsText = this._paramsUi.getTextForExample();
            this._txaExample.setText(oriText.replaceFirst("\\[@params\\]", paramsText));
        } else {
            this._txaExample.setEnabled(true);
            this._txaExample.setText((String)this._txaExample.getUserObject());
        }
        this.syncExampleState();
    }

    private void syncExampleState() {
        if (this._txaExample.isEnabled()) {
            this._btnParamInstead.setEnabled(true);
            this._btnExample.setText("\u70b9\u51fb\u5207\u6362\u5230\u9884\u89c8\u72b6\u6001");
        } else {
            this._btnParamInstead.setEnabled(false);
            this._btnExample.setText("\u70b9\u51fb\u5207\u6362\u5230\u7f16\u8f91\u72b6\u6001");
        }
    }

    public void reBuildTree(DefaultKingdeeTreeNode root) {
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        model.setAsksAllowsChildren(true);
        this._tree.setModel((TreeModel)model);
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode firstLevelNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this._tree.expandPath(new TreePath(firstLevelNode.getPath()));
        }
    }

    public DefaultKingdeeTreeNode getTreeRoot() {
        TreePath path = this._tree.getSelectionPath();
        this.acceptNodeContent(path);
        return (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
    }

    private void acceptNodeContent(TreePath path) {
        DefaultKingdeeTreeNode node;
        Element xml;
        if (path != null && this._panDetail.isShowing() && "Node".equals((xml = (Element)(node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()).getName())) {
            this.acceptParamEditing();
            node.setUserObject((Object)this.acceptEditing());
        }
    }

    private void updateInfoPane(String text) {
        if (this._sppLeftRight.getRightComponent() != this._panFolder) {
            this._sppLeftRight.setRightComponent((Component)((Object)this._panFolder));
        }
        this._panFolder.setInfo(text);
    }

    private void updateInfoPane(Element xml) {
        if (this._sppLeftRight.getRightComponent() != this._panFolder) {
            this._sppLeftRight.setRightComponent((Component)((Object)this._panFolder));
        }
        this._panFolder.setInfo(xml);
    }

    private void prepareCtrlValue(Element xml) {
        this._txtText.setText(xml.getAttributeValue("text"));
        this._txtData.setText(xml.getAttributeValue("data"));
        String funcName = xml.getAttributeValue("funcName");
        this._txtFuncName.setText(funcName);
        this._chkFuncName.setSelected(StringUtil.isEmptyString((String)funcName));
        this.syncFuncNameState();
        Element xmlExample = xml.getChild("example");
        this._txaExample.setText(xmlExample == null ? null : xmlExample.getTextTrim());
        this._txaExample.setUserObject(null);
        this.setExampleState(true);
        Element xmlReturn = xml.getChild("return");
        if (xmlReturn == null) {
            this._dtReturnType.setModel(0);
        } else {
            String t = xmlReturn.getAttributeValue("type");
            this._dtReturnType.setModel(AbstractParamBizModel.decodeDataType(t));
        }
        Element xmlParams = xml.getChild("params");
        this._paramsUi.prepareCtrlValue(xmlParams);
    }

    private void acceptParamEditing() {
        this._paramsUi.acceptParamEditing();
    }

    private Element acceptEditing() {
        String strExample;
        Element xmlParams;
        String strReturnType;
        Element xml = new Element("Node");
        xml.setAttribute("text", this._txtText.getText());
        xml.setAttribute("data", this._txtData.getText());
        String funcName = this._txtFuncName.getText();
        if (!this._chkFuncName.isSelected() && !StringUtil.isEmptyString((String)funcName)) {
            xml.setAttribute("funcName", funcName);
        }
        if ((strReturnType = AbstractParamBizModel.encodeDataType(this._dtReturnType.getModel())) != null) {
            Element xmlReturn = new Element("return");
            xmlReturn.setAttribute("type", strReturnType);
            xml.addContent((Content)xmlReturn);
        }
        if (this._paramsUi.acceptEditing(xmlParams = new Element("params"))) {
            xml.addContent((Content)xmlParams);
        }
        String string = strExample = this._txaExample.isEnabled() ? this._txaExample.getText() : (String)this._txaExample.getUserObject();
        if (!StringUtil.isEmptyString((String)strExample)) {
            Element xmlExample = new Element("example");
            xmlExample.addContent((Content)new CDATA(strExample));
            xml.addContent((Content)xmlExample);
        }
        return xml;
    }

    private class DelAction
    extends AbstractAction {
        private DelAction() {
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Delete.gif"));
            this.putValue("ShortDescription", "\u5220\u9664\u8282\u70b9");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = PenUI.this._tree.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Element xml = (Element)node.getUserObject();
            if ("Group".equals(xml.getName())) {
                return;
            }
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
            int idx = parentNode.getIndex((TreeNode)node);
            PenUI.this._tree.removeNodeFromParent((MutableTreeNode)node);
            DefaultKingdeeTreeNode newSelection = idx < parentNode.getChildCount() ? (DefaultKingdeeTreeNode)parentNode.getChildAt(idx) : (idx == 0 ? parentNode : (DefaultKingdeeTreeNode)parentNode.getChildAt(--idx));
            PenUI.this._tree.setSelectionNode(newSelection);
        }
    }

    private class AddFolderAction
    extends AbstractAction {
        private AddFolderAction() {
            this.putValue("Name", "\u5939");
            this.putValue("ShortDescription", "\u65b0\u589e\u6587\u4ef6\u5939");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = PenUI.this._tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Element newXml = new Element("Nodes");
            newXml.setAttribute("text", "\u65b0\u5206\u7c7b");
            DefaultKingdeeTreeNode newNode = TreeIO.createNodes(newXml);
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Element xml = (Element)node.getUserObject();
            if ("Node".equals(xml.getName())) {
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                int idx = parentNode.getIndex((TreeNode)node);
                PenUI.this._tree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, idx);
            } else {
                PenUI.this._tree.addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)node);
            }
            PenUI.this._tree.setSelectionNode(newNode);
        }
    }

    private class AddFuncAction
    extends AbstractAction {
        private AddFuncAction() {
            this.putValue("Name", "\u51fd");
            this.putValue("ShortDescription", "\u65b0\u589e\u51fd\u6570");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = PenUI.this._tree.getSelectionPath();
            if (path == null) {
                return;
            }
            Element newXml = new Element("Node");
            newXml.setAttribute("text", "\u65b0\u51fd\u6570");
            DefaultKingdeeTreeNode newNode = TreeIO.createNode(newXml);
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Element xml = (Element)node.getUserObject();
            if ("Node".equals(xml.getName())) {
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
                int idx = parentNode.getIndex((TreeNode)node);
                PenUI.this._tree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, idx);
            } else {
                PenUI.this._tree.addNodeInto((MutableTreeNode)newNode, (MutableTreeNode)node);
            }
            PenUI.this._tree.setSelectionNode(newNode);
        }
    }

    private class TreeDragHandler
    implements TreeNodesPreDroppedListener {
        private TreeDragHandler() {
        }

        public void preDropped(TreeNodesDropedEvent evt) {
            if (evt.getNodesCount() > 0) {
                DefaultKingdeeTreeNode toParent = evt.getToParent(0);
                Element xml = (Element)toParent.getUserObject();
                if ("Group".equals(xml.getName())) {
                    return;
                }
                evt.veto();
                this.myDrop(evt);
            }
        }

        private void myDrop(TreeNodesDropedEvent evt) {
            DefaultKingdeeTreeNode toParent = evt.getToParent(0);
            DefaultKingdeeTreeNode realParent = (DefaultKingdeeTreeNode)toParent.getParent();
            int insertIdx = realParent.getIndex((TreeNode)toParent);
            for (int i = evt.getNodesCount() - 1; i >= 0; --i) {
                DefaultKingdeeTreeNode node = evt.getDragNode(0);
                PenUI.this._tree.removeNodeFromParent((MutableTreeNode)node);
                PenUI.this._tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)realParent, insertIdx);
                PenUI.this._tree.addSelectionPath(new TreePath(node.getPath()));
            }
        }
    }

    private class InfoPane
    extends KDPanel {
        private KDLabel _labKey = new KDLabel();
        private KDLabel _labValue = new KDLabel();
        private KDWorkButton _btnEdit = new KDWorkButton("\u4fee\u6539");
        private KDTextField _txtValue;
        private Element _xml;

        public InfoPane() {
            this._btnEdit.setPreferredSize(new Dimension(40, 20));
            this._txtValue = new KDTextField();
            this._txtValue.setPreferredSize(new Dimension(200, 20));
            FlowLayout ly = new FlowLayout(0);
            this.setLayout(ly);
            this.add((Component)this._labKey);
            this.add((Component)this._labValue);
            this.add((Component)this._txtValue);
            this.add((Component)this._btnEdit);
            this._btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InfoPane.this._txtValue.isShowing()) {
                        String result = InfoPane.this._txtValue.getText();
                        InfoPane.this._labValue.setText(result);
                        InfoPane.this._xml.setAttribute("text", result);
                        PenUI.this.syncTreeNode(result);
                        InfoPane.this.updateState(false);
                    } else {
                        InfoPane.this._txtValue.setText(InfoPane.this._labValue.getText());
                        InfoPane.this.updateState(true);
                    }
                }
            });
        }

        private void updateMode(boolean isCanEdit) {
            this._btnEdit.setVisible(isCanEdit);
            this._txtValue.setVisible(isCanEdit);
        }

        private void updateState(boolean isEditing) {
            this._txtValue.setVisible(isEditing);
            this._btnEdit.setText(isEditing ? "\u63a5\u53d7" : "\u4fee\u6539");
        }

        private void setInfo(String key, String value) {
            this._labKey.setText(key);
            this._labValue.setText(value);
        }

        public void setInfo(String text) {
            this.setInfo(text, null);
            this.updateMode(false);
        }

        public void setInfo(Element xml) {
            this._xml = xml;
            this.setInfo(xml.getName() + "\uff1a", xml.getAttributeValue("text"));
            this.updateMode(true);
            this.updateState(false);
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath oldPath = e.getOldLeadSelectionPath();
            PenUI.this.acceptNodeContent(oldPath);
            if (PenUI.this._tree.getSelectionCount() > 1) {
                PenUI.this.updateInfoPane("\u591a\u9009\u8282\u70b9\u4e0d\u53ef\u7f16\u8f91");
            } else {
                TreePath newPath = e.getNewLeadSelectionPath();
                if (newPath == null) {
                    PenUI.this.updateInfoPane("\u65e0\u9009\u4e2d\u8282\u70b9");
                } else {
                    DefaultKingdeeTreeNode newNode = (DefaultKingdeeTreeNode)newPath.getLastPathComponent();
                    Element xml = (Element)newNode.getUserObject();
                    if ("Node".equals(xml.getName())) {
                        if (PenUI.this._sppLeftRight.getRightComponent() != PenUI.this._panDetail) {
                            PenUI.this._sppLeftRight.setRightComponent((Component)PenUI.this._panDetail);
                        }
                        PenUI.this.prepareCtrlValue(xml);
                    } else {
                        PenUI.this.updateInfoPane(xml);
                    }
                }
            }
        }
    }
}

