/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.navigator;

import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.navigator.Navigator;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class Breadcrumb {
    private KDPanel _panAll;
    private Navigator.IEditorDependency _listener;

    public Breadcrumb(Navigator.IEditorDependency listener) {
        this.init();
        this._listener = listener;
    }

    private void init() {
        MyFlowLayout ly = new MyFlowLayout();
        ly.setAlignment(0);
        this._panAll = new KDPanel((LayoutManager)ly);
        this._panAll.setBackground(Color.WHITE);
    }

    public void preUpdate() {
        this._panAll.removeAll();
    }

    public void insertFunc(String funcName, int caretGotoBefore, int caretGotoAfter) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5b9a\u4f4d\u5230");
        sb.append(' ');
        sb.append(funcName);
        sb.append(' ');
        HyperlinkLabel labFunc = new HyperlinkLabel(caretGotoAfter);
        labFunc.setText(funcName);
        labFunc.setToolTipText(sb.toString());
        sb.append("\u4e4b\u524d");
        HyperlinkLabel labArrow = new HyperlinkLabel(caretGotoBefore);
        labArrow.setText("\u2192");
        labArrow.setToolTipText(sb.toString());
        this._panAll.add((Component)((Object)labFunc), 0);
        this._panAll.add((Component)((Object)labArrow), 0);
    }

    public void postUpdate() {
        this._panAll.revalidate();
        this._panAll.repaint();
    }

    public JComponent getCtrl() {
        return this._panAll;
    }

    private static class MyFlowLayout
    extends FlowLayout {
        private MyFlowLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container c) {
            Object object = c.getTreeLock();
            synchronized (object) {
                return new Dimension(0, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container c) {
            Object object = c.getTreeLock();
            synchronized (object) {
                int width = c.getParent().getWidth();
                c.setSize(width, c.getHeight());
                super.layoutContainer(c);
                int childCount = c.getComponentCount();
                int newHeight = 28;
                if (childCount > 0) {
                    Component lastChild = c.getComponent(childCount - 1);
                    newHeight = lastChild.getY() + lastChild.getHeight() + 4;
                }
                return new Dimension(width, newHeight);
            }
        }
    }

    private class HyperlinkLabel
    extends KDLabel
    implements MouseListener {
        private int pos;

        public HyperlinkLabel(int caretGoto) {
            this.pos = caretGoto;
            this.setUnderlineColor(Color.BLUE);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Breadcrumb.this._listener.caretGoto(this.pos);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setForeground(Color.BLUE);
            this.setUnderline(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setForeground(Color.BLACK);
            this.setUnderline(false);
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

