/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.ChartBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.GroupTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.GroupTableChartBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.ListTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.ListTableChartBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.SegmentGroupTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.SegmentGroupTableChartBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.SegmentListTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl.SegmentListTableChartBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class DesignRegister {
    private static final Map<String, Class<? extends DesignBuilder>> BUILDERS = new HashMap<String, Class<? extends DesignBuilder>>();

    private DesignRegister() {
    }

    private static String genKey(ReportType reportType, TableType tableType) {
        return reportType.name() + "\t" + (null == tableType ? "" : tableType.name());
    }

    public static final void registe(ReportType reportType, TableType tableType, Class<? extends DesignBuilder> cls) {
        BUILDERS.put(DesignRegister.genKey(reportType, tableType), cls);
    }

    public static final Class<? extends DesignBuilder> mathClass(ReportType reportType, TableType tableType) {
        return BUILDERS.get(DesignRegister.genKey(reportType, tableType));
    }

    public static DesignBuilder getBuilder(KDExt ext, MobileReportWizardModel model, int startRow) {
        Class<? extends DesignBuilder> cls = DesignRegister.mathClass(model.getReportType(), model.getTableModel().getTableType());
        DesignBuilder builder = null;
        try {
            Constructor<? extends DesignBuilder> constructor = cls.getConstructor(KDExt.class, MobileReportWizardModel.class, Integer.TYPE);
            builder = constructor.newInstance(ext, model, startRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder;
    }

    static {
        DesignRegister.registe(ReportType.TABLE, TableType.GROUP, GroupTableBuilder.class);
        DesignRegister.registe(ReportType.TABLE, TableType.LIST, ListTableBuilder.class);
        DesignRegister.registe(ReportType.TABLE, TableType.SEGMENTGROUP, SegmentGroupTableBuilder.class);
        DesignRegister.registe(ReportType.TABLE, TableType.SEGMENTLIST, SegmentListTableBuilder.class);
        DesignRegister.registe(ReportType.CHARTTABLE, TableType.GROUP, GroupTableChartBuilder.class);
        DesignRegister.registe(ReportType.CHARTTABLE, TableType.LIST, ListTableChartBuilder.class);
        DesignRegister.registe(ReportType.CHARTTABLE, TableType.SEGMENTGROUP, SegmentGroupTableChartBuilder.class);
        DesignRegister.registe(ReportType.CHARTTABLE, TableType.SEGMENTLIST, SegmentListTableChartBuilder.class);
        DesignRegister.registe(ReportType.CHART, null, ChartBuilder.class);
    }
}

