/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.impl;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilderDesc;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ChartModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.style.TableStyleDesign;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;

public class ChartBuilder
implements DesignBuilder,
DesignBuilderDesc {
    private KDExt ext;
    private MobileReportWizardModel model;
    private int width;

    public ChartBuilder(KDExt ext, MobileReportWizardModel model, int width) {
        this.ext = ext;
        this.model = model;
        this.width = width;
    }

    public void buildChart(KDExt ext, MobileReportWizardModel model, int width) {
        ChartModel chartModel = model.getChartModel();
        SpreadContext sc = MiscUtil.getActiveSpreadContext(ext);
        Sheet sheet = sc.getBook().getActiveSheet();
        EmbedhLayer layer = sheet.getEmbedments(true);
        for (int i = 0; i < chartModel.getFusionGraphicsModelList().size(); ++i) {
            FusionGraphicsModel m = chartModel.getFusionGraphicsModelList().get(i);
            DataLabelUtil.changeFlashChartType2DataSortLabel(sc, m.getChartType(), m.getFramworkType()).composeProperties(m.getBean(), m.getDataNode());
            m.setDataFrom("dataset");
            FlashChartModel flashChartModel = new FlashChartModel();
            flashChartModel.setDataNode(m.getDataNode());
            flashChartModel.setChartType(m.getChartType());
            flashChartModel.setBean(m.getBean());
            flashChartModel.setDataFrom(m.getDataFrom());
            EChart ec = new EChart(sheet, flashChartModel);
            ec.setAnchorMode(2);
            ec.setBounds(0, 240 * i, width, 235);
            layer.addEmbed(ec);
        }
    }

    @Override
    public void build() {
        this.buildChart(this.ext, this.model, this.width);
    }

    @Override
    public TableStyleDesign[] getDesigns() {
        return null;
    }

    @Override
    public ReportType getReportType() {
        return ReportType.CHART;
    }

    @Override
    public TableType getTableType() {
        return null;
    }
}

