/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.propelling.kpi;

import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.kpi.KPIDefine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ExtKPIModel {
    private ArrayList<KPIDefine> defines;

    public ExtKPIModel() {
    }

    public ExtKPIModel(ArrayList<KPIDefine> defines) {
        this.defines = defines;
    }

    public ExtKPIModel fromXml(String xmlContent) {
        Element root;
        this.defines = new ArrayList();
        try {
            root = new SAXBuilder().build((InputStream)new ByteArrayInputStream(xmlContent.getBytes("UTF-8"))).getRootElement();
        }
        catch (Throwable e) {
            return this;
        }
        List children = root.getChildren();
        for (Object obj : children) {
            if (!(obj instanceof Element)) continue;
            Element param = (Element)obj;
            this.defines.add(new KPIDefine(param.getAttributeValue("name"), param.getAttributeValue("value"), param.getAttributeValue("format")));
        }
        return this;
    }

    public String toXml() {
        Element root = new Element("root");
        if (this.defines != null) {
            for (KPIDefine define : this.defines) {
                Element element = new Element("define");
                element.setAttribute("name", define.kpiName());
                element.setAttribute("value", define.kpiValue());
                String numberFormat = define.numberFormat();
                if (numberFormat != null) {
                    element.setAttribute("format", numberFormat);
                }
                root.addContent((Content)element);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        XMLOutputter xmlOutput = new XMLOutputter();
        try {
            xmlOutput.output(root, (OutputStream)out);
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (Throwable e) {
            return "";
        }
    }

    public KPIDefine[] defines() {
        return this.defines.toArray(new KPIDefine[0]);
    }
}

