/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.util;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.util.IntegratedEnvCheck;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.ext.util.manage.calculation.ui.ClientControlManager;
import com.kingdee.bos.ctrl.ext.util.statistics.SheetStatPrinter;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MemoryInspector;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.bos.ctrl.swing.SimpleStatusBarRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public class ExtConsole
extends KDFrame
implements ComponentListener {
    private static final String REPORT_LOG_STR = "\u62a5\u8868\u8ba1\u7b97\u65e5\u5fd7";
    private KDWorkButton clear;
    private KDWorkButton copy;
    private KDWorkButton close;
    private KDWorkButton showPanelReport;
    private KDWorkButton showConsoleReport;
    private KDWorkButton showSheetReport;
    private KDWorkButton resetMetrics;
    private KDWorkButton mem;
    private KDWorkButton gc;
    private KDWorkButton logLevel;
    private KDWorkButton showCalcThreads;
    private KDScrollPane scrollpane;
    private KDEditorPane logRecorder;
    private KDCheckBoxMenuItem fatalLog;
    private KDCheckBoxMenuItem errorLog;
    private KDCheckBoxMenuItem warnLog;
    private KDCheckBoxMenuItem infoLog;
    private KDCheckBoxMenuItem debugLog;
    private int _logLevel = 4;
    private transient Element element;
    private SimpleDateFormat format;
    private HTMLDocument document;
    private KDStatusBar statusBar;
    private final transient MetricRegistry metricRegistry = new MetricRegistry();
    private transient ConsoleReporter panleReporter;
    private transient ConsoleReporter consoleReporter;
    private static final int REPORTER_TYPE_CONSOLE = 1;
    private static final int REPORTER_TYPE_PANLE = 0;
    private static final String FUNCTION_METER_NAME = "functionCalls";
    private static final String FUNCTION_COUNTER_NAME = "functionNums";
    private static final String FUNCTION_CALC_TIMER = "functionCalcTimer";
    private static final long REPORT_PERIOD = 30L;
    private static final String STATISTICS_SHEET_NAME = "formula statistics";
    private KDExt ext;
    private int before;
    private boolean flag = false;
    private int after;
    private Rectangle viewRect;
    private int width;
    private int height;

    public ExtConsole() {
        this(null);
    }

    public ExtConsole(KDExt ext) {
        this.ext = ext;
        this.initConsole();
        this.initComps();
        this.initListeners();
    }

    public void log(int logLevel, String logTxt) {
        if (logLevel > this._logLevel) {
            return;
        }
        if (StringUtil.isEmptyString((String)logTxt)) {
            logTxt = "";
        } else {
            logTxt = logTxt.replaceAll("<", "&lt;");
            logTxt = logTxt.replaceAll(">", "&gt;");
            logTxt = logTxt.replaceAll("\r\n", "<br>");
        }
        try {
            this.viewRect = this.scrollpane.getViewport().getViewRect();
            this.before = this.scrollpane.getViewport().getView().getHeight();
            if (this.before < this.viewRect.y + this.viewRect.height + 20 && this.viewRect.height < this.before) {
                this.flag = true;
            }
            this.document.insertBeforeEnd(this.element, "<p align='left'><b>" + this.getLogPrefix(logLevel) + "</b>" + logTxt + "</p>");
            this.document.insertBeforeEnd(this.element, "<br>");
            this.after = this.scrollpane.getViewport().getView().getHeight();
            if (this.flag) {
                this.scrollpane.getViewport().scrollRectToVisible(new Rectangle(this.viewRect.x, this.after - this.viewRect.height, this.viewRect.width, this.viewRect.height));
                this.flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExt(KDExt ext) {
        this.ext = ext;
    }

    public void markFunctionCalls() {
        Meter meter = this.metricRegistry.meter(FUNCTION_METER_NAME);
        meter.mark();
    }

    public void incressFunctionNums() {
        this.incressCounter(FUNCTION_COUNTER_NAME);
    }

    public Timer getFunctionTimer() {
        return this.getTimer(FUNCTION_CALC_TIMER);
    }

    public Timer getTimer(String name) {
        return this.metricRegistry.timer(name);
    }

    public void decressFunctionNums() {
        this.decressCounter(FUNCTION_COUNTER_NAME);
    }

    public void incressCounter(String counterName) {
        Counter counter = this.metricRegistry.counter(counterName);
        counter.inc();
    }

    public void decressCounter(String counterName) {
        Counter counter = this.metricRegistry.counter(counterName);
        counter.dec();
    }

    private void startMetricReport(int type) {
        if (type == 1 && null == this.consoleReporter) {
            this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            this.consoleReporter.start(30L, TimeUnit.SECONDS);
        } else if (type == 0 && null == this.panleReporter) {
            this.panleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(new PrintStream(new PrintStream(new ConsoleOutputStream()))).build();
            this.panleReporter.start(30L, TimeUnit.SECONDS);
        }
    }

    private void closeMetricReport(int type) {
        if (type == 1 && null != this.consoleReporter) {
            this.consoleReporter.stop();
            this.consoleReporter = null;
        } else if (type == 0 && null != this.panleReporter) {
            this.panleReporter.stop();
            this.panleReporter = null;
        }
    }

    public void log(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String html = writer.toString().trim();
        html = html.replaceAll("<", "&lt;");
        html = html.replaceAll(">", "&gt;");
        html = html.replaceAll("\\n", "<br>");
        try {
            this.viewRect = this.scrollpane.getViewport().getViewRect();
            this.before = this.scrollpane.getViewport().getView().getHeight();
            if (this.before < this.viewRect.y + this.viewRect.height + 20 && this.viewRect.height < this.before) {
                this.flag = true;
            }
            this.document.insertBeforeEnd(this.element, "<p align='left' ><b>" + this.getErrorPrefix().trim() + "</b>" + html + "</p>");
            this.document.insertBeforeEnd(this.element, "<br>");
            this.after = this.scrollpane.getViewport().getView().getHeight();
            if (this.flag) {
                this.scrollpane.getViewport().scrollRectToVisible(new Rectangle(this.viewRect.x, this.after - this.viewRect.height, this.viewRect.width, this.viewRect.height));
                this.flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getLogPrefix(int logLevel) {
        String date = this.format.format(new Date());
        switch (logLevel) {
            case 0: {
                return "[\u81f4\u547d  " + date + "]\uff1a ";
            }
            case 1: {
                return "[\u9519\u8bef  " + date + "]\uff1a ";
            }
            case 2: {
                return "[\u8b66\u544a  " + date + "]\uff1a ";
            }
            case 3: {
                return "[\u4fe1\u606f  " + date + "]\uff1a ";
            }
            case 4: {
                return "[\u8c03\u8bd5  " + date + "]\uff1a ";
            }
        }
        throw new IllegalArgumentException();
    }

    private String getErrorPrefix() {
        return "[\u7a0b\u5e8f\u5f02\u5e38  " + this.format.format(new Date()) + "]:";
    }

    private void initConsole() {
        this.setTitle("\u91d1\u8776\u6269\u5c55\u62a5\u8868\u540e\u53f0");
        this.setSize(750, 525);
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.fatalLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(0));
        this.errorLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(1));
        this.warnLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(2));
        this.infoLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(3));
        this.debugLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(4));
        this.debugLog.setSelected(true);
        this.format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    private void initComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        this.initDefaultStatusBar();
        this.scrollpane = new KDScrollPane();
        this.logRecorder = new KDEditorPane("text/html", this.getIntroduce());
        this.document = (HTMLDocument)this.logRecorder.getDocument();
        this.element = this.document.getElement("ins");
        this.logRecorder.setEditable(false);
        this.clear = new KDWorkButton();
        this.copy = new KDWorkButton();
        this.close = new KDWorkButton();
        this.showPanelReport = new KDWorkButton();
        this.showConsoleReport = new KDWorkButton();
        this.showSheetReport = new KDWorkButton();
        this.resetMetrics = new KDWorkButton();
        this.mem = new KDWorkButton();
        this.gc = new KDWorkButton();
        this.logLevel = new KDWorkButton();
        this.logLevel.addAssistMenuItem((JMenuItem)this.fatalLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.errorLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.warnLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.infoLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.debugLog);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setViewportView((Component)this.logRecorder);
        c.add((Component)this.scrollpane);
        this.scrollpane.setBounds(160, 18, 570, 435);
        this.clear.setText("\u6e05\u9664\u65e5\u5fd7");
        c.add((Component)this.clear);
        this.clear.setBounds(30, 20, 100, 25);
        this.copy.setText("\u590d\u5236\u65e5\u5fd7");
        c.add((Component)this.copy);
        this.copy.setBounds(30, 60, 100, 25);
        this.gc.setText("\u5783\u573e\u6536\u96c6");
        c.add((Component)this.gc);
        this.gc.setBounds(30, 100, 100, 25);
        this.mem.setText("\u5185\u5b58\u8017\u7528");
        c.add((Component)this.mem);
        this.mem.setBounds(30, 140, 100, 25);
        this.logLevel.setText("\u65e5\u5fd7\u7ea7\u522b");
        c.add((Component)this.logLevel);
        this.logLevel.setBounds(30, 180, 100, 25);
        this.showPanelReport.setText("\u663e\u793a\u6267\u884c\u62a5\u544a");
        c.add((Component)this.showPanelReport);
        this.showPanelReport.setBounds(30, 220, 100, 25);
        this.showConsoleReport.setText("\u663e\u793a\u540e\u53f0\u62a5\u544a");
        c.add((Component)this.showConsoleReport);
        this.showConsoleReport.setBounds(30, 260, 100, 25);
        this.showSheetReport.setText("\u5de5\u4f5c\u7c3f\u62a5\u544a");
        c.add((Component)this.showSheetReport);
        this.showSheetReport.setBounds(30, 300, 100, 25);
        this.resetMetrics.setText("\u91cd\u7f6e\u6267\u884c\u62a5\u544a");
        c.add((Component)this.resetMetrics);
        this.resetMetrics.setBounds(30, 340, 100, 25);
        this.close.setText("\u5173\u95ed");
        c.add((Component)this.close);
        this.close.setBounds(30, 425, 100, 25);
        this.addComponentListener(this);
        this.showCalcThreads = new KDWorkButton((Action)new AbstractAction(REPORT_LOG_STR){
            WindowListener l;
            {
                this.l = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ExtConsole.this.showCalcThreads.setText(ExtConsole.REPORT_LOG_STR);
                        ClientControlManager.restoreUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                        ExtConsole.this.removeWindowListener(this);
                        ExtConsole.this.closeMetricReport(1);
                        ExtConsole.this.closeMetricReport(0);
                    }
                };
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(ExtConsole.REPORT_LOG_STR)) {
                    ExtConsole.this.showCalcThreads.setText("\u8fd4   \u56de");
                    ClientControlManager.replaceUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                    ExtConsole.this.addWindowListener(this.l);
                } else {
                    ExtConsole.this.showCalcThreads.setText(ExtConsole.REPORT_LOG_STR);
                    ClientControlManager.restoreUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                    ExtConsole.this.removeWindowListener(this.l);
                }
            }
        });
        this.showCalcThreads.setBounds(30, 220, 100, 25);
        if (IntegratedEnvCheck.checkIsIntegratedEAS()) {
            c.add((Component)this.showCalcThreads);
        }
    }

    private KDStatusBar initDefaultStatusBar() {
        this.statusBar = new KDStatusBar();
        this.statusBar.addPart(this.createStatusPartMemory(this.statusBar));
        this.setStatusBar(this.statusBar);
        return this.statusBar;
    }

    private SimpleStatusBarPart createStatusPartMemory(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(500, 30));
        part.setHgrap(0);
        String str = "\u5185\u5b58\u72b6\u6001";
        SimpleStatusBarRenderer render1 = new SimpleStatusBarRenderer((JComponent)new MemoryInspector(0L, 1000000), str);
        render1.getComponent(statusBar).setToolTipText(str);
        part.addRenderer((ISimpleStatusBarRenderer)render1, (Object)"memory");
        return part;
    }

    private String getIntroduce() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        if (IntegratedEnvCheck.checkIsIntegratedEAS()) {
            sb.append("<p align='center' color='red'><b><font size=5>\u91d1\u8776\u6269\u5c55\u62a5\u8868\u540e\u53f0<font></b></p>");
        } else {
            sb.append("<p align='center' color='red'><b><font size=5>\u91d1\u8776KBI\u667a\u80fd\u5206\u6790\u540e\u53f0<font></b></p>");
        }
        sb.append("<p>");
        sb.append("<b>Java\u63d0\u4f9b\u5546\uff1a</b>" + System.getProperty("java.vm.vendor") + "<br>");
        sb.append("<b>Java\u8fd0\u884c\u65f6\u7248\u672c\uff1a</b>" + System.getProperty("java.version") + "<br>");
        sb.append("<b>\u64cd\u4f5c\u7cfb\u7edf\uff1a</b>" + System.getProperty("os.name") + "<br>");
        sb.append("<b>\u4e8c\u8fdb\u5236\u8bfb\u53d6\u5668\u7248\u672c\uff1a</b>" + BookToKds.getVersion() + "<br>");
        sb.append("<b>\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55\uff1a</b>" + System.getProperty("java.io.tmpdir") + "<br>");
        sb.append("</p>");
        sb.append("<p id='ins'>&nbsp;</p>");
        sb.append("</body></html>");
        return sb.toString();
    }

    public void show() {
        this.logRecorder = new KDEditorPane("text/html", this.getIntroduce());
        super.show();
    }

    public String getDoctments() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            return "Class:" + this.getClass().toString() + "\r\n Method: getDoctments \r\n" + e.getMessage();
        }
    }

    private void initListeners() {
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConsole.this.clearRecorder();
            }
        });
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(ExtConsole.this.getDoctments()), null);
            }
        });
        this.gc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConsole.this.dispose();
            }
        });
        this.showPanelReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == ExtConsole.this.panleReporter) {
                    ExtConsole.this.startMetricReport(0);
                    ExtConsole.this.showPanelReport.setText("\u5173\u95ed\u6267\u884c\u62a5\u544a");
                } else {
                    ExtConsole.this.closeMetricReport(0);
                    ExtConsole.this.showPanelReport.setText("\u663e\u793a\u6267\u884c\u62a5\u544a");
                }
            }
        });
        this.showConsoleReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == ExtConsole.this.consoleReporter) {
                    ExtConsole.this.startMetricReport(1);
                    ExtConsole.this.showConsoleReport.setText("\u5173\u95ed\u540e\u53f0\u62a5\u544a");
                } else {
                    ExtConsole.this.closeMetricReport(1);
                    ExtConsole.this.showConsoleReport.setText("\u663e\u793a\u540e\u53f0\u62a5\u544a");
                }
            }
        });
        this.showSheetReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null != ExtConsole.this.ext) {
                    SpreadContext cxt = MiscUtil.getActiveSpreadContext(ExtConsole.this.ext);
                    Book book = cxt.getBook();
                    Sheet sheet = book.getSheet(ExtConsole.STATISTICS_SHEET_NAME);
                    if (null == sheet) {
                        sheet = new Sheet(book, ExtConsole.STATISTICS_SHEET_NAME);
                        book.addSheet(sheet);
                    }
                    SheetStatPrinter print = new SheetStatPrinter(sheet, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.SECONDS.toSeconds(1L));
                    print.print(ExtConsole.this.metricRegistry);
                }
            }
        });
        this.resetMetrics.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConsole extConsole = ExtConsole.this;
                synchronized (extConsole) {
                    SortedSet names = ExtConsole.this.metricRegistry.getNames();
                    for (String name : names) {
                        ExtConsole.this.metricRegistry.remove(name);
                    }
                }
            }
        });
        this.mem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int kb = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
                try {
                    ExtConsole.this.document.insertAfterEnd(ExtConsole.this.element, "<div><b>\u5f53\u524d\u7cfb\u7edf\u603b\u5185\u5b58\u8017\u7528 " + kb + " KB</b></div>");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void clearRecorder() {
        this.logRecorder.setText(this.getIntroduce());
        try {
            this.document.setOuterHTML(this.element.getParentElement(), this.getIntroduce());
            this.element = this.document.getElement("ins");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        ExtConsole console = (ExtConsole)((Object)e.getComponent());
        Dimension consoleDim = console.getSize();
        if (this.width != consoleDim.width || this.height != consoleDim.height) {
            this.width = consoleDim.width - 750 + 570;
            this.height = consoleDim.height - 525 + 435;
            if (this.showCalcThreads.getText().equals("\u8fd4   \u56de")) {
                ClientControlManager.queueUI.setSize(new Dimension(this.width + 30, this.height));
                ClientControlManager.queueUI.revalidate();
                ClientControlManager.queueUI.repaint();
            } else {
                console.scrollpane.setSize(new Dimension(this.width, this.height));
                console.scrollpane.revalidate();
                console.scrollpane.repaint();
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private int bufferSize = 8192;
        private byte[] buf = new byte[this.bufferSize];
        private int count = 0;

        private ConsoleOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count == this.bufferSize) {
                try {
                    ExtConsole.this.document.insertAfterEnd(ExtConsole.this.element, "<b> " + new String(this.buf) + "</b>");
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.count = 0;
            }
            this.buf[this.count] = (byte)b;
            ++this.count;
        }

        @Override
        public void flush() throws IOException {
            try {
                ExtConsole.this.document.insertAfterEnd(ExtConsole.this.element, "<div> " + new String(this.buf, 0, this.count) + "</div>");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.count = 0;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.buf = null;
        }
    }

    private class LogLevelAction
    extends AbstractAction {
        private int _level;

        private LogLevelAction(int level) {
            this._level = level;
            switch (level) {
                case 0: {
                    this.putValue("Name", "\u81f4\u547d\u7ea7");
                    break;
                }
                case 1: {
                    this.putValue("Name", "\u9519\u8bef\u7ea7");
                    break;
                }
                case 2: {
                    this.putValue("Name", "\u8b66\u544a\u7ea7");
                    break;
                }
                case 3: {
                    this.putValue("Name", "\u4fe1\u606f\u7ea7");
                    break;
                }
                case 4: {
                    this.putValue("Name", "\u8c03\u8bd5\u7ea7");
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtConsole.this._logLevel = this._level;
            this.exclisiveSelection(ExtConsole.this.fatalLog);
            this.exclisiveSelection(ExtConsole.this.errorLog);
            this.exclisiveSelection(ExtConsole.this.warnLog);
            this.exclisiveSelection(ExtConsole.this.infoLog);
            this.exclisiveSelection(ExtConsole.this.debugLog);
        }

        private void exclisiveSelection(KDCheckBoxMenuItem menu) {
            if (((LogLevelAction)menu.getAction())._level != this._level) {
                menu.setSelected(false);
            }
        }
    }
}

