/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.util;

import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class VariantUtil
extends BookToKds {
    public static String variant2PlainString(Variant var) {
        String ret = "";
        byte dataType = VariantUtil.parseVariantType(var);
        int vt = var.getVt();
        if (dataType == 8) {
            long lValue;
            Object value = var.getValue();
            try {
                lValue = var.toCalendar().getTimeInMillis();
            }
            catch (SyntaxErrorException e) {
                lValue = vt == 12 ? ((Date)value).getTime() : ((Calendar)value).getTimeInMillis();
            }
            ret = String.valueOf(lValue);
        } else if (dataType == 2) {
            ret = ((Boolean)var.getValue()).toString();
        } else {
            Object v = var.getValue();
            if (v instanceof BigDecimal) {
                try {
                    ret = String.valueOf(BigDecimal.class.getMethod("toPlainString", null).invoke(v, null));
                }
                catch (Throwable th) {
                    ret = v.toString();
                }
            } else {
                ret = var.toString();
            }
        }
        return ret;
    }

    public static byte parseVariantType(Variant var) {
        byte dataType = 1;
        int vt = var.getVt();
        switch (vt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                dataType = 4;
                break;
            }
            case 8: {
                dataType = 2;
                break;
            }
            case 12: 
            case 13: {
                dataType = 8;
                break;
            }
            case 0: 
            case 16: 
            case 8192: 
            case 16384: {
                dataType = 0;
                break;
            }
        }
        return dataType;
    }

    public static Variant parsePlainString2Variant(String value, byte type) {
        Variant var;
        if (1 == type) {
            String valueString = value;
            var = new Variant(valueString, 11);
        } else if (4 == type) {
            String valueString = value;
            try {
                var = new Variant(new BigDecimal(valueString), 10);
            }
            catch (NumberFormatException ex) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(ex);
                }
                System.out.println("---------Fatal Error ocurred during loading kds file---------------");
                ex.printStackTrace();
                var = new Variant(valueString, 11);
            }
        } else if (8 == type) {
            long lTime;
            String valueString = value;
            try {
                lTime = Long.parseLong(valueString);
            }
            catch (NumberFormatException e) {
                lTime = 0L;
            }
            Calendar cal = Variant.getGMTCalender();
            cal.setTimeInMillis(lTime);
            var = new Variant(cal, 13);
        } else {
            var = 2 == type ? new Variant(Boolean.valueOf(value), 8) : Variant.nullVariant;
        }
        return var;
    }
}

