/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.digitalstyle;

import com.kingdee.bos.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.LanguageCondition;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Node;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Symbols;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import java.util.Calendar;

class DateTimeFormat
extends SimpleFormat {
    private boolean _am_pm;
    private LanguageCondition _lc;

    DateTimeFormat() {
    }

    void setLanguageCondition(LanguageCondition lc) {
        this._lc = lc;
    }

    void setAM_PM(boolean b) {
        this._am_pm = b;
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        Calendar calendar = null;
        try {
            if (parse || var.isNumber() || var.isDate()) {
                calendar = var.toCalendar();
            }
        }
        catch (SyntaxErrorException e) {
            calendar = null;
        }
        if (calendar == null) {
            return FormatResult.NullResult;
        }
        StringBuffer sb = new StringBuffer();
        int repeatIndex = -1;
        int size = this._nodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this._nodes.get(i);
            sb.append(this.getNodeText(node, calendar));
            if (node.getType() != 24) continue;
            repeatIndex = sb.length() - 1;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    private String getNodeText(Node node, Calendar cal) {
        switch (node.getType()) {
            case 4: {
                String str = String.valueOf(cal.get(1));
                if (this._lc != null) {
                    str = this._lc.translate3(str);
                }
                return str;
            }
            case 5: {
                String str = String.valueOf(cal.get(1)).substring(2);
                if (this._lc != null) {
                    str = this._lc.translate2(str);
                }
                return str;
            }
            case 6: {
                String str = String.valueOf(cal.get(2) + 1);
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 7: {
                String str = this.getFullString(String.valueOf(cal.get(2) + 1));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 8: {
                return Symbols.getMonth(cal.get(2) + 1).substring(0, 3);
            }
            case 9: {
                return Symbols.getMonth(cal.get(2) + 1);
            }
            case 10: {
                return Symbols.getMonth(cal.get(2) + 1).substring(0, 1);
            }
            case 11: {
                String str = "";
                str = cal.get(1) < 1900 ? "0" : String.valueOf(cal.get(5));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 12: {
                String str = "";
                str = cal.get(1) < 1900 ? "0" : String.valueOf(cal.get(5));
                str = this.getFullString(str);
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 13: {
                return Symbols.getDay(cal.get(7)).substring(2);
            }
            case 14: {
                return Symbols.getDay(cal.get(7));
            }
            case 15: {
                String str = String.valueOf(this._am_pm ? cal.get(10) : cal.get(11));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 16: {
                String str = this.getFullString(String.valueOf(this._am_pm ? cal.get(10) : cal.get(11)));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 17: {
                String str = String.valueOf(cal.get(12));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 18: {
                String str = this.getFullString(String.valueOf(cal.get(12)));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 19: {
                String str = String.valueOf(cal.get(13));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 20: {
                String str = this.getFullString(String.valueOf(cal.get(13)));
                if (this._lc != null) {
                    str = this._lc.translate(str);
                }
                return str;
            }
            case 27: {
                return cal.get(11) >= 12 ? "PM" : "AM";
            }
        }
        return node.getText();
    }

    private String getFullString(String str) {
        if (str.length() == 1) {
            str = '0' + str;
        }
        return str;
    }
}

