/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.RowHeaderUI;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.ViewSplitInfo;
import java.awt.Dimension;
import java.awt.Point;

final class RowHeader
extends SpreadView {
    private static final long serialVersionUID = 7692965114589118216L;

    public RowHeader(KDSpread spread) {
        this._spread = spread;
        this.updateUI();
    }

    @Override
    public void setLocation(int x, int y) {
        y = -y;
        Point point = new Point(x, y);
        int row = SheetBaseMath.rowAtPoint(this.getSpread().getBook().getActiveSheet(), point);
        if (row < 0) {
            row = 0;
        }
        y = SheetBaseMath.getRowY(this.getSpread().getBook().getActiveSheet(), row);
        this.setRowCol(row);
        x = -x;
        y = -y;
        super.setLocation(x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(RowHeaderUI.createUI(this));
    }

    @Override
    public void scrollCellVisible(int row, int col) {
        if (this.getAutoscrolls()) {
            int newR;
            SpreadView view = RowHeader.scrollerDispatchRow(this, row);
            if (view != this) {
                view.scrollCellVisible(row, col);
            }
            if ((newR = this.calcFirstRowByVisibleRow(row)) != this.getFirstRow()) {
                this.getSpread().setViewRow(this, newR);
            }
        }
    }

    @Override
    public int getViewType() {
        return 2;
    }

    protected void setRowCol(int row) {
        int vIndex = KDSpread.getComponentIndex(this, "VViewIndex");
        ViewSplitInfo vs = this.getSpread().getBook().getActiveSheet().getSheetOption().getViewSplitInfo();
        int fix = this.getSpread().getFixVerticalCount();
        if (vIndex == fix) {
            vs.setFirstRow(row);
        } else if (vIndex > fix) {
            vs.setFirstRow2(row);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }
}

