/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetFactory;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParamPos;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParams;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import java.util.EmptyStackException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExtDataSetManager {
    public static final int Flag_ContainedValue = 1;
    public static final int Flag_CompleteReport = 2;
    private Logger log = Logger.getLogger((String)ExtDataSetManager.class.getName());
    private Book _book;
    private SortedObjectArray _array;
    private ExtDataSetFactory extDataSetFactory = new ExtDataSetFactory();
    private ExecutionContext _ctx;
    private int _flags;

    public ExtDataSetFactory getExtDataSetFactory() {
        return this.extDataSetFactory;
    }

    public ExtDataSetManager(Book book) {
        this._book = book;
        this._array = new SortedObjectArray();
        this._ctx = new ExecutionContext(this._book);
    }

    public int size() {
        return this._array.size();
    }

    public ExtDataSet getAt(int index) {
        return (ExtDataSet)this._array.get(index);
    }

    public ExtDynamicDataSet addDynamicDataSet(ExtDynamicDataSet key) {
        ExtDynamicDataSet dds = (ExtDynamicDataSet)this._array.insert(key);
        return dds == null ? key : dds;
    }

    public void clear() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            this.getAt(i).clear();
        }
    }

    public void resetCurrent() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            ExtDataSet ds = this.getAt(i);
            ds.resetCurrent();
        }
    }

    int getFlags() {
        return this._flags;
    }

    void setFlags(int flags) {
        this._flags = flags;
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public ExtDynamicDataSet[] getDatasetsBySourceName(String name) {
        name = name.toUpperCase();
        ObjectArray oa = new ObjectArray();
        for (int i = this._array.size() - 1; i > -1; --i) {
            ExtDataSet ds = this.getAt(i);
            if (ds.getName().toUpperCase().indexOf(name, 0) <= -1) continue;
            oa.append(ds);
        }
        Object[] adds = new ExtDynamicDataSet[oa.size()];
        oa.toArray(adds, 0);
        return adds;
    }

    public void resumeCurrent() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            ExtDataSet ds = this.getAt(i);
            ds.resumeCurrent();
        }
    }

    public boolean isContainedValue() {
        return this.touchFlag(1);
    }

    public boolean isCompleteReport() {
        return this.touchFlag(2);
    }

    public ExecutionContext getExecutionContext() {
        return this._ctx;
    }

    public String checkAlias(String alias, boolean isDataset, boolean isColumn) {
        String errorMsg = null;
        alias = alias.toUpperCase();
        if ((isDataset || isColumn) && this._array.search(alias) >= 0) {
            errorMsg = "\u4e0e\u5df2\u6709\u6570\u636e\u96c6\u540d\u51b2\u7a81";
        } else if (isDataset) {
            for (int i = this._array.size() - 1; i >= 0; --i) {
                SortedObjectArray cols;
                ExtDataSet ds = (ExtDataSet)this._array.get(i);
                if (ds instanceof ExtDynamicDataSet || (cols = ds.getColumns()).search(alias) < 0) continue;
                errorMsg = "\u4e0e\u5df2\u6709\u5217\u540d\u51b2\u7a81";
                break;
            }
        } else if (isDataset || isColumn) {
            if (!MiscUtil.isNamedObjectInsertable4Book(this._book, alias)) {
                errorMsg = "\u5df2\u6709\u540c\u540d\u547d\u540d\u5bf9\u8c61 \u6216\u8005 \u547d\u540d\u975e\u6cd5";
            } else {
                this._book.getNamedObject(alias).setVisible(false);
            }
        }
        return errorMsg;
    }

    public String addDataSet(ExtDataSet ds) {
        String dst;
        String errorMsg;
        block4: {
            errorMsg = null;
            dst = null;
            Book book = ds.getBook();
            String alias = ds.getAlias();
            errorMsg = this.checkAlias(alias, true, false);
            if (errorMsg != null) {
                dst = alias;
            } else {
                book.getNamedObject(alias).setValue(new Variant(alias.toUpperCase(), 11));
                SortedObjectArray cols = ds.getColumns();
                for (int i = cols.size() - 1; i >= 0; --i) {
                    alias = ((ExtColumn)cols.get(i)).getAlias();
                    errorMsg = this.checkAlias(alias, false, true);
                    if (errorMsg != null) {
                        dst = alias;
                        break block4;
                    }
                    book.getNamedObject(alias).setValue(new Variant(alias.toUpperCase(), 11));
                }
                this._array.insert(ds);
            }
        }
        return errorMsg == null ? null : dst + errorMsg;
    }

    public String checkDataset(ExtDataSet ds) {
        String errorMsg = null;
        String dst = null;
        Book book = ds.getBook();
        String alias = ds.getAlias();
        errorMsg = this.checkAlias(alias, true, false);
        if (errorMsg != null) {
            dst = alias;
            return errorMsg == null ? null : dst + errorMsg;
        }
        book.getNamedObject(alias).setValue(new Variant(alias.toUpperCase(), 11));
        SortedObjectArray cols = ds.getColumns();
        for (int i = cols.size() - 1; i >= 0; --i) {
            alias = ((ExtColumn)cols.get(i)).getAlias();
            errorMsg = this.checkAlias(alias, false, true);
            if (errorMsg != null) {
                dst = alias;
                return errorMsg == null ? null : dst + errorMsg;
            }
            book.getNamedObject(alias).setValue(new Variant(alias.toUpperCase(), 11));
        }
        return null;
    }

    public void removeDataSet(ExtDataSet ds) {
        this._array.remove(ds);
    }

    public void removeAll() {
        this._array.clear();
    }

    public void updateExpr() {
        try {
            for (int i = this._array.size() - 1; i >= 0; --i) {
                ExtDataSet ds = (ExtDataSet)this._array.get(i);
                if (ds instanceof ExtDynamicDataSet) continue;
                this.replaceDS_ExprNode(ds);
            }
            ObjectStack stack = new ObjectStack();
            for (int i = this._array.size() - 1; i >= 0; --i) {
                ExtDataSet ds = (ExtDataSet)this._array.get(i);
                if (ds instanceof ExtDynamicDataSet) continue;
                this.replaceField_ExprNode(stack, ds);
            }
        }
        catch (EmptyStackException e) {
            e.printStackTrace();
        }
    }

    public void updateDataSet(ExtDataSet ds) {
        long t1 = System.currentTimeMillis();
        boolean bDynamic = false;
        if (ds instanceof ExtDynamicDataSet) {
            bDynamic = true;
            ds.updateDataSet();
        } else {
            if ((ds = (ExtDataSet)this._array.remove(ds)) == null) {
                return;
            }
            SortedObjectArray cols = ds.getColumns();
            Object[] oldCols = cols.toArray();
            cols.clear();
            if (this.getExtDataSetFactory().updateDataSet(ds, this.getExecutionContext())) {
                if (!ds.isDynamicFields()) {
                    ds.matchColumnAlias(oldCols);
                }
                this.addDataSet(ds);
                ds.setCurrentGroup(ds.getDefaultGroup());
            }
        }
        this.log.info((Object)("\u6570\u636e\u96c6\u540d\u79f0 [ " + ds.getName() + " ]"));
        long t2 = System.currentTimeMillis();
        this.log.info((Object)((bDynamic ? "\u52a8\u6001" : "") + "\u6570\u636e\u96c6 [" + ds.getDefine() + "] \u586b\u6570\u8017\u65f6\uff1a" + (t2 - t1) + " ms"));
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(3, (bDynamic ? "\u52a8\u6001" : "") + "\u6570\u636e\u96c6 [" + ds.getDefine() + "] \u586b\u6570\u8017\u65f6\uff1a" + (t2 - t1) + " ms");
        }
    }

    private void replaceDS_ExprNode(ExtDataSet ds) {
        NamedObjectNode no = this._book.getNamedObject(ds.getAlias());
        if (no != null) {
            Object refs = no.getRefs();
            if (refs instanceof ICalculable) {
                this.replaceDS_ExprNode((ICalculable)refs, no, ds);
            } else if (refs instanceof SortedObjectArray) {
                SortedObjectArray sa = (SortedObjectArray)refs;
                for (int i = sa.size() - 1; i >= 0; --i) {
                    this.replaceDS_ExprNode((ICalculable)sa.get(i), no, ds);
                }
            }
        }
    }

    private void replaceField_ExprNode(ObjectStack stack, ExtDataSet ds) {
        NamedObjectNode no = this._book.getNamedObject(ds.getAlias());
        if (no != null && MiscUtil.isExtUsed(no)) {
            Object refs = no.getRefs();
            if (refs instanceof ICalculable) {
                this.replaceField_ExprNode(stack, (ICalculable)refs, ds);
            } else if (refs instanceof SortedObjectArray) {
                SortedObjectArray sa = (SortedObjectArray)refs;
                for (int i = sa.size() - 1; i >= 0; --i) {
                    this.replaceField_ExprNode(stack, (ICalculable)sa.get(i), ds);
                }
            }
        }
    }

    public Expr replaceDSNode(ICalculable owner, Expr expr, ExtDataSet dsSrc) {
        Dependents buffer = owner.getSheet().getDeps();
        ObjectStack stack = new ObjectStack();
        if (dsSrc != null) {
            stack.push(dsSrc);
        }
        for (int i = this._array.size() - 1; i >= 0; --i) {
            NamedObjectNode no;
            ExtDataSet ds = (ExtDataSet)this._array.get(i);
            if (ds instanceof ExtDynamicDataSet || (no = this._book.getNamedObject(ds.getAlias())) == null || !MiscUtil.isExtUsed(no) || !this.isReferTo(owner, no)) continue;
            Expr e = this.replaceDS(buffer, owner, expr, no, ds);
            if (e != null) {
                expr = e;
            }
            if ((e = this.replaceField(buffer, stack, owner, expr, ds)) == null) continue;
            expr = e;
        }
        return expr;
    }

    private boolean isReferTo(ICalculable owner, NamedObjectNode no) {
        Object refs = no.getRefs();
        if (refs instanceof ICalculable) {
            return refs == owner;
        }
        if (refs instanceof SortedObjectArray) {
            SortedObjectArray sa = (SortedObjectArray)refs;
            for (int i = sa.size() - 1; i >= 0; --i) {
                if (sa.get(i) != owner) continue;
                return true;
            }
        }
        return false;
    }

    private void replaceField_ExprNode(ObjectStack stack, ICalculable owner, ExtDataSet ds) {
        SortedExtPropFormulasArray sa;
        ExtProps ep;
        Dependents buffer = owner.getSheet().getDeps();
        Expr expr = this.replaceField(buffer, stack, owner, null, ds);
        if (expr != null) {
            owner.setExpr(expr);
        }
        stack.clear();
        if (owner instanceof Cell && (ep = ((Cell)owner).getExtProps(false)) != null && (sa = ep.getFormulas(false)) != null) {
            for (int i = sa.size() - 1; i >= 0; --i) {
                ICalculableProps node = (ICalculableProps)sa.get(i);
                node.buildFieldExpr(buffer, stack, owner, ds);
            }
        }
    }

    private void replaceDS_ExprNode(ICalculable owner, NamedObjectNode no, ExtDataSet ds) {
        SortedExtPropFormulasArray sa;
        ExtProps ep;
        Dependents buffer = owner.getSheet().getDeps();
        Expr expr = this.replaceDS(buffer, owner, null, no, ds);
        if (expr != null) {
            owner.setExpr(expr);
        }
        if (owner instanceof ChartDataNode) {
            ChartDataNode cn = (ChartDataNode)owner;
            Expr[] exprs = cn.getExprs();
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = this.replaceDS(buffer, owner, exprs[i], no, ds);
            }
            cn.setExprs(exprs);
        } else if (owner instanceof Cell && (ep = ((Cell)owner).getExtProps(false)) != null && (sa = ep.getFormulas(false)) != null) {
            for (int i = sa.size() - 1; i >= 0; --i) {
                ICalculableProps node = (ICalculableProps)sa.get(i);
                node.buildDSExpr(buffer, owner, no, ds);
            }
        }
    }

    private void releaseNamedObject(ICalculable owner, NamedObjectNode no) {
        Object refs = no.getRefs();
        boolean remove = true;
        if (refs != null) {
            remove = false;
            if (refs instanceof ICalculable) {
                if (refs == owner) {
                    no.setRefs(null);
                    remove = true;
                }
            } else {
                SortedObjectArray array = (SortedObjectArray)refs;
                array.remove(owner);
                if (array.isEmpty()) {
                    remove = true;
                }
            }
        }
        if (remove) {
            no.getBook().getNames().remove(no);
        }
    }

    public Expr replaceDS(IExprBuffer buffer, ICalculable owner, Expr expr, NamedObjectNode no, ExtDataSet ds) {
        ExprParams params;
        if (expr == null) {
            expr = owner.getExpr();
        }
        if (expr == null || (params = expr.getExprParams()) == null) {
            return null;
        }
        Object[] src = params.getNodes();
        Object[] dst = null;
        for (int i = 0; i < src.length; ++i) {
            Expr newExpr;
            IExprNode param = src[i];
            if (param == no) {
                if (dst == null) {
                    dst = new IExprNode[src.length];
                    KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                }
                dst[i] = ds;
                continue;
            }
            if (!(param instanceof Expr) || (newExpr = this.replaceDS(buffer, owner, (Expr)param, no, ds)) == null) continue;
            if (dst == null) {
                dst = new IExprNode[src.length];
                KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
            }
            dst[i] = newExpr;
        }
        return this.getDstExpr(buffer, expr, (IExprNode[])dst);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expr getDstExpr(IExprBuffer buffer, Expr expr, IExprNode[] dst) {
        int nodeState = expr.getExprNodeState() & 0xFF7FFFFF;
        if (dst != null) {
            boolean hasNamedObject = false;
            block5: for (int i = 0; i < dst.length; ++i) {
                IExprNode node = dst[i];
                switch (node.getExprType()) {
                    case 8: {
                        if (((NamedObjectNode)node).isUndefined()) {
                            nodeState |= 0x800000;
                        }
                        hasNamedObject = true;
                        break;
                    }
                    case 131072: {
                        Expr subExpr = (Expr)node;
                        if (subExpr.hasNamedObject()) {
                            hasNamedObject = true;
                        }
                        if (!subExpr.hasExtField()) break;
                        nodeState |= 0x100000;
                        break;
                    }
                    case 0x100000: {
                        nodeState |= 0x100000;
                        if (hasNamedObject) break block5;
                    }
                }
            }
            if (!hasNamedObject) {
                nodeState &= 0xFFFFFFF7;
            }
        }
        if (dst == null) return null;
        Expr expr2 = Expr.getExpr(buffer, expr, dst, nodeState);
        return expr2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Expr replaceField(IExprBuffer buffer, ObjectStack stack, ICalculable owner, Expr expr, ExtDataSet ds) {
        ExprParams ep;
        if (expr == null) {
            expr = owner.getExpr();
        }
        if (expr == null || (ep = expr.getExprParams()) == null) {
            return null;
        }
        int oldCap = stack.size();
        IExprNode[] nodes = expr.getExprOps().getNodes();
        Object[] src = ep.getNodes();
        Object[] dst = null;
        SortedObjectArray cols = ds.getColumns();
        int i = 0;
        while (i < nodes.length) {
            IExprNode node = nodes[i];
            block0 : switch (node.getExprType()) {
                case 262144: {
                    int pos = ((ExprParamPos)node).getPos();
                    IExprNode param = src[pos];
                    switch (param.getExprType()) {
                        case 8: {
                            if (stack.isEmpty() || stack.getTop() != ds) break;
                            NamedObjectNode no = (NamedObjectNode)param;
                            int p = cols.search(no.getUpperCaseName());
                            if (p >= 0) {
                                if (dst == null) {
                                    dst = new IExprNode[src.length];
                                    KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                                }
                                dst[pos] = (ExtColumn)cols.get(p);
                                this.releaseNamedObject(owner, no);
                                break block0;
                            }
                            if (!MiscUtil.isExtUsed(no)) break block0;
                            while (stack.size() != oldCap) {
                                stack.pop();
                            }
                            break block0;
                        }
                        case 524288: {
                            stack.push(param);
                            break block0;
                        }
                        case 131072: {
                            Expr e = this.replaceField(buffer, stack, owner, (Expr)param, ds);
                            if (e == null) break;
                            if (dst == null) {
                                dst = new IExprNode[src.length];
                                KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                            }
                            dst[pos] = e;
                        }
                    }
                    break;
                }
                case 256: {
                    if (!((ExprMethod)node).isExtDataSetMethod() || stack.isEmpty()) break;
                    stack.pop();
                    break;
                }
            }
            ++i;
        }
        return this.getDstExpr(buffer, expr, (IExprNode[])dst);
    }

    public ExtDataSet getDataSetByAlias(String dsAlias) {
        if (StringUtil.isEmptyString((String)dsAlias)) {
            return null;
        }
        int len = this._array == null ? -1 : this._array.size();
        for (int i = 0; i < len; ++i) {
            ExtDataSet ds = (ExtDataSet)this._array.get(i);
            String alias = ds.getAlias();
            if (StringUtil.isEmptyString((String)alias) || !dsAlias.toUpperCase(Locale.ENGLISH).equals(alias.toUpperCase(Locale.ENGLISH))) continue;
            return ds;
        }
        return null;
    }

    public static String getDataSetIdByDefine(String define) {
        if (StringUtil.isEmptyString((String)define)) {
            return null;
        }
        String[] arr = define.split("\\\\");
        return arr[arr.length - 1];
    }

    public ExtDataSet getDataSetByName(String dsName) {
        if (StringUtil.isEmptyString((String)dsName)) {
            return null;
        }
        int len = this._array == null ? -1 : this._array.size();
        for (int i = 0; i < len; ++i) {
            ExtDataSet ds = (ExtDataSet)this._array.get(i);
            String name = ds.getName();
            if (StringUtil.isEmptyString((String)name) || !name.equalsIgnoreCase(dsName)) continue;
            return ds;
        }
        return null;
    }
}

