/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import org.apache.log4j.Logger;

public class ExtDataSetTextFactory
implements IExtDataSetFactory {
    private static Logger logs = LogUtil.getPackageLogger(ExtDataSetTextFactory.class);
    private static String nameMark = "colname=";
    static String typeMark = "coltype=";

    @Override
    public ExtDataSet getDataSet(Book book, String name, String diskFile) {
        if (StringUtil.isEmptyString((String)diskFile)) {
            return null;
        }
        ExtDataSet ds = new ExtDataSet(book, name, diskFile, ExtDataSetType.TXT);
        return this.updateDataSet(ds, book.getDataSetManager().getExecutionContext()) ? ds : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDataSet(ExtDataSet ds, ExecutionContext execCtx) {
        BufferedReader lr = null;
        try {
            int i;
            String str;
            IParameter param = execCtx.getDataSetParameter("url");
            String diskFile = param != null ? param.getValue().getVariant().toString() : ExtDataSetType.TXT.trimPrefix(ds.getDefine());
            lr = new LineNumberReader(new FileReader(diskFile));
            String[] names = null;
            DataConvert.IDataConvert[] convert = null;
            int lines = 0;
            while ((str = ((LineNumberReader)lr).readLine()) != null) {
                if (lines == 0 && str.indexOf(nameMark) == 0) {
                    ++lines;
                    str = str.substring(nameMark.length());
                    names = str.split("\t");
                    continue;
                }
                if (str.indexOf(typeMark) != 0) continue;
                String[] types = (str = str.substring(typeMark.length())).split("\t");
                if (types.length != names.length) {
                    boolean bl = false;
                    return bl;
                }
                for (i = 0; i < types.length; ++i) {
                    ds.addColumn(new ExtColumn(ds, names[i], i, Integer.parseInt(types[i])));
                }
                if (ds.getColumnCount() != names.length) {
                    i = 0;
                    return i != 0;
                }
                convert = DataConvert.getConvertArray(ds);
                break;
            }
            ObjectArray al = new ObjectArray();
            while ((str = ((LineNumberReader)lr).readLine()) != null) {
                names = str.split("\t");
                Variant[] rowData = new Variant[convert.length];
                int size = Math.min(names.length, rowData.length);
                for (i = 0; i < size; ++i) {
                    rowData[i] = convert[i].convertString(names[i]);
                }
                while (i < rowData.length) {
                    rowData[i] = Variant.nullVariant;
                    ++i;
                }
                al.append(rowData);
            }
            al.trimToSize();
            ds.setData(al);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != lr) {
                try {
                    lr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportDataSet(ExtDataSet ds, File diskFile) {
        int i;
        StringBuffer sb = new StringBuffer();
        SortedObjectArray array = ds.getColumns();
        if (array == null || array.size() == 0) {
            return false;
        }
        sb.append(nameMark);
        for (i = 0; i < array.size(); ++i) {
            sb.append(((ExtColumn)array.get(i)).getName()).append("\t");
        }
        sb.append("\n");
        sb.append(typeMark);
        for (i = 0; i < array.size(); ++i) {
            sb.append(((ExtColumn)array.get(i)).getDataType()).append("\t");
        }
        sb.append("\n");
        Variant[][] data = ds.getData();
        int rows = data.length;
        if (rows <= 0) {
            return false;
        }
        int cols = data[0].length;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(data[r][c]).append("\t");
            }
            sb.append("\n");
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(diskFile);
            outStream.write(sb.toString().trim().getBytes());
        }
        catch (Exception e) {
            logs.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                logs.error((Object)e);
            }
        }
        return true;
    }
}

