/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.data;

import com.kingdee.bos.ctrl.kds.expans.model.data.AbstractIntStragety;
import com.kingdee.bos.ctrl.kds.expans.model.data.RepaymentBillInfo;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import java.math.BigDecimal;
import java.util.Date;

class RepayIntStragety
extends AbstractIntStragety {
    RepayIntStragety() {
    }

    @Override
    protected int getIntCalType() {
        return 2;
    }

    @Override
    protected Date getBeginDate(Date condBeginDate) {
        if (this._isPrediction) {
            return condBeginDate;
        }
        Date startDate = this._loan.getStartDate();
        Date lastIntDate = this._loan.getLastIntDate();
        if (lastIntDate == null) {
            return startDate;
        }
        return DateHelper.getAfterDay(lastIntDate);
    }

    @Override
    protected Date getEndDate(Date condEndDate) {
        return DateHelper.getBeforeDay(this._repayInfo.getRepayDate());
    }

    @Override
    protected boolean isNotSubWithRepay(RepaymentBillInfo repayInfo) {
        return !this.isAllRepay() ? true : this.isRepayWithInt(repayInfo);
    }

    @Override
    protected BigDecimal getSubIntPrinciple(Date subBeginDate) {
        boolean isAllRepay = this.isAllRepay();
        if (!isAllRepay) {
            return this._repayInfo.getRepayAmt();
        }
        BigDecimal loanBalance = this._loan.getLoanBalance();
        BigDecimal intFreeAmt = this._loan.getIntFreeAmt();
        BigDecimal repayTotalAmt = this.getTotalRepayAmtWithoutInt(subBeginDate);
        return loanBalance.add(repayTotalAmt).add(intFreeAmt.negate());
    }

    private boolean isAllRepay() {
        return this._loan.getLoanBalance().compareTo(this._repayInfo.getRepayAmt()) == 0;
    }

    @Override
    protected boolean isCalPunishInt(Date subEndDate) {
        return this._repayInfo.isCalPunishInt();
    }
}

