/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.frame;

import com.kingdee.bos.ctrl.kds.frame.LayoutCell;
import com.kingdee.bos.ctrl.kds.frame.MultiViewPaneUI;
import com.kingdee.bos.ctrl.kds.frame.MvpLayoutInfoManager;
import com.kingdee.bos.ctrl.kds.frame.MvpLayoutManager;
import com.kingdee.bos.ctrl.kds.frame.MvpScrollBarManager;
import com.kingdee.bos.ctrl.kds.frame.MvpViewController;
import com.kingdee.bos.ctrl.kds.frame.MvpViewManager;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

public class MultiViewPane
extends JComponent {
    public static final int INVALID_INDEX = -1;
    public static final String INDEX = "ViewIndex";
    public static final String V_INDEX = "VViewIndex";
    public static final String H_INDEX = "HViewIndex";
    protected MvpLayoutInfoManager _layoutInfoM;
    protected MvpViewManager _viewM;
    protected MvpScrollBarManager _scrollBarM;
    protected MvpViewController _mvc;
    protected int _hCount = 3;
    protected int _vCount = 3;
    protected int _fixHCount = 2;
    protected int _fixVCount = 2;

    public static int getComponentIndex(JComponent view, String key) {
        Integer index;
        if (view != null && (index = (Integer)view.getClientProperty(key)) != null) {
            return index;
        }
        return -1;
    }

    public static void setComponentIndex(JComponent view, int index, String key) {
        if (view != null) {
            view.putClientProperty(key, new Integer(index));
        }
    }

    public MultiViewPane() {
        this(null);
    }

    public MultiViewPane(MvpViewController mvc) {
        this(mvc, 3, 3);
    }

    public MultiViewPane(MvpViewController mvc, int vCount, int hCount) {
        this.setVerticalCount(vCount);
        this.setHorizonCount(hCount);
        this.setLayout(new MvpLayoutManager());
        this._layoutInfoM = new MvpLayoutInfoManager(this);
        this._viewM = new MvpViewManager(this);
        this._scrollBarM = new MvpScrollBarManager(this);
    }

    @Override
    public void updateUI() {
        this.setUI(MultiViewPaneUI.createUI(this));
    }

    public MvpViewManager getViewManager() {
        return this._viewM;
    }

    public int getVerticalCount() {
        return this._vCount;
    }

    public int getHorizonCount() {
        return this._hCount;
    }

    public int getFixVerticalCount() {
        return this._fixVCount;
    }

    public int getFixHorizonCount() {
        return this._fixHCount;
    }

    public JComponent getView(int vIndex, int hIndex) {
        return this.getViewManager().getView(vIndex, hIndex);
    }

    public boolean split(int orientation) {
        if (this.getViewController() == null) {
            return false;
        }
        return this.getViewController().split(orientation);
    }

    public boolean mergeSplit(int orientation) {
        if (this.getViewController() == null) {
            return false;
        }
        return this.getViewController().mergeSplit(orientation);
    }

    public boolean isSplited(int orientation, int index) {
        if (this.getViewController() != null) {
            return this.getViewController().isSplited(orientation);
        }
        return false;
    }

    public boolean freeze() {
        if (this._mvc == null) {
            return false;
        }
        if (!this._mvc.isFreezed()) {
            return this._mvc.freeze();
        }
        return false;
    }

    public boolean unFreeze() {
        if (this._mvc == null) {
            return false;
        }
        if (this._mvc.isFreezed()) {
            return this._mvc.unFreeze();
        }
        return false;
    }

    public boolean isFreezed(int orientation) {
        if (this._mvc == null) {
            return true;
        }
        return this._mvc.isFreezed(orientation);
    }

    public boolean isFreezed() {
        if (this._mvc == null) {
            return true;
        }
        return this._mvc.isFreezed();
    }

    protected void loadComps() {
        this.reset();
        this.setVerticalCount(3);
        this.setHorizonCount(3);
        MvpViewManager vm = this.getViewManager();
        MvpScrollBarManager spm = this.getScrollBarManager();
        MvpLayoutInfoManager lim = this.getLayoutInfoManager();
        LayoutCell lc = new LayoutCell();
        lim.addHorizon(0, lc);
        lc = new LayoutCell();
        lim.addHorizon(1, lc);
        lc = new LayoutCell();
        lim.addHorizon(2, lc);
        lc = new LayoutCell();
        lim.addVertical(0, lc);
        lc = new LayoutCell();
        lim.addVertical(1, lc);
        lc = new LayoutCell();
        lim.addVertical(2, lc);
        vm.addView(0, 0, this._mvc.getSplitView(0, 0));
        vm.addView(0, 1, this._mvc.getSplitView(0, 1));
        vm.addView(0, 2, this._mvc.getSplitView(0, 2));
        vm.addView(1, 0, this._mvc.getSplitView(1, 0));
        vm.addView(1, 1, this._mvc.getSplitView(1, 1));
        vm.addView(1, 2, this._mvc.getSplitView(1, 2));
        vm.addView(2, 0, this._mvc.getSplitView(2, 0));
        vm.addView(2, 1, this._mvc.getSplitView(2, 1));
        vm.addView(2, 2, this._mvc.getSplitView(2, 2));
        spm.addHScrollPanel(2, this._mvc.getHScrollPanel(this._mvc.getExtComponent(0, 2, false)));
        spm.addVScrollPanel(2, this._mvc.getVScrollPanel(this._mvc.getExtComponent(1, 2, false)));
    }

    protected void reset() {
        this._scrollBarM.reset();
        this._layoutInfoM.reset();
        this._viewM.reset();
        this._mvc.reset();
    }

    public MvpViewController getViewController() {
        return this._mvc;
    }

    public MvpLayoutInfoManager getLayoutInfoManager() {
        return this._layoutInfoM;
    }

    public MvpScrollBarManager getScrollBarManager() {
        return this._scrollBarM;
    }

    protected void setViewController(MvpViewController viewController) {
        this._mvc = viewController;
    }

    protected void setViewPosition(int orientation, int index, int newValue) {
        if (orientation == 0) {
            JScrollBar hsb = this.getScrollBarManager().getHScrollBar(index);
            if (hsb != null && hsb.getMinimum() > newValue) {
                return;
            }
            int vCount = this.getVerticalCount();
            if (vCount > 0) {
                JViewport vp = this.getViewManager().getViewport(0, index);
                if (vp != null) {
                    Point p = vp.getViewPosition();
                    if (p.x != newValue) {
                        p.x = newValue;
                    }
                    vp.setViewPosition(p);
                    newValue = vp.getViewPosition().x;
                }
                for (int i = 1; i < vCount; ++i) {
                    vp = this.getViewManager().getViewport(i, index);
                    if (vp == null) continue;
                    Point p = vp.getViewPosition();
                    if (p.x != newValue) {
                        p.x = newValue;
                    }
                    vp.setViewPosition(p);
                }
            }
            if (hsb != null && hsb.getValue() != newValue) {
                hsb.setValue(newValue);
            }
        } else {
            JScrollBar vsb = this.getScrollBarManager().getVScrollBar(index);
            if (vsb != null && vsb.getMinimum() > newValue) {
                vsb.setValue(vsb.getMinimum());
                return;
            }
            int hCount = this.getHorizonCount();
            if (hCount > 0) {
                JViewport vp = this.getViewManager().getViewport(index, 0);
                if (vp != null) {
                    Point p = vp.getViewPosition();
                    if (p.y != newValue) {
                        p.y = newValue;
                    }
                    vp.setViewPosition(p);
                    newValue = vp.getViewPosition().y;
                }
                for (int i = 1; i < hCount; ++i) {
                    vp = this.getViewManager().getViewport(index, i);
                    if (vp == null) continue;
                    Point p = vp.getViewPosition();
                    if (p.y != newValue) {
                        p.y = newValue;
                    }
                    vp.setViewPosition(p);
                }
            }
            if (vsb != null && newValue != vsb.getValue()) {
                vsb.setValue(newValue);
            }
        }
    }

    protected void setHorizonCount(int count) {
        this._hCount = count;
    }

    protected void setVerticalCount(int count) {
        this._vCount = count;
    }

    protected int getMaxHoriCount() {
        return 4;
    }

    protected int getMaxVertCount() {
        return 4;
    }

    boolean isSplited(int orientation) {
        return this.isSplited(orientation, -1);
    }

    boolean splitByPosition(int orientation, int pos) {
        if (this.getViewController() == null) {
            return false;
        }
        return this.getViewController().mvp_SplitByPosition(orientation, pos);
    }

    boolean setSplitPosition(int orientation, int pos) {
        if (this.getViewController() == null) {
            return false;
        }
        this.getViewController().mvp_SetSplitPosition(orientation, pos);
        return true;
    }
}

