/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.action;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.digitalstyle.Formats;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.event.ActionEvent;

class NF_DecimalDec_Action
extends SpreadAction {
    public NF_DecimalDec_Action(SpreadContext context) {
        super(context);
    }

    @Override
    protected void doAction(ActionEvent e) {
        Book book = this._context.getBook();
        Sheet sheet = book.getActiveSheet();
        sheet.getBook().getUndoManager().startGroup();
        Selection sel = sheet.getSheetOption().getSelection();
        SortedCellBlockArray sca = sel.toSortedBlocks();
        boolean bBreak = true;
        boolean bComplete = true;
        int size = sca.size();
        for (int i = 0; i < size; ++i) {
            CellBlock cb = sca.getBlock(i);
            Sheet.ICellsIterator iter = sheet.getCellsIterator(cb, true, true);
            while (iter.hasNext()) {
                int c;
                Cell cell = iter.next();
                int r = cell.getRow();
                Style style = sheet.getCellStyle(r, c = cell.getCol());
                String of = style.getNumberFormat();
                if (StringUtil.isEmptyString((String)of)) {
                    int scale = 0;
                    Variant var = cell.getValue();
                    if (var != null && var.isNumber()) {
                        try {
                            scale = var.toBigDecimal().scale();
                        }
                        catch (SyntaxErrorException e1) {
                            scale = 0;
                        }
                    }
                    StyleAttributes sa = Styles.getEmptySA();
                    if (scale <= 0) {
                        sa.setNumberFormat("0;-0");
                    } else {
                        String nf = Formats.updateDecimalDigit(book.getFormat("0.0;-0.0"), scale - 1);
                        sa.setNumberFormat(Formats.updateDecimalDigit(book.getFormat(nf), -1));
                    }
                    this._context.getRangeManager().getRange(r, c).setStyle(sa, Styles.getEmptySA());
                    continue;
                }
                String nf = Formats.updateDecimalDigit(book.getFormat(of), -1);
                if (of.equals(nf)) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setNumberFormat(nf);
                this._context.getRangeManager().getRange(r, c).setStyle(sa, Styles.getEmptySA());
            }
        }
        if (bComplete) {
            sheet.getBook().getUndoManager().endGroup();
        } else {
            sheet.getBook().getUndoManager().cancelGroup();
        }
    }
}

