/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizzardMultiRowColIns
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel _lbRows;
    private KDFormattedTextField _tfRows;
    private KDButton _okBtn;
    private KDButton _cancelBtn;
    private int lastInsertedRowCount;
    private int insType = 0;

    public WizzardMultiRowColIns(Frame parent, SpreadContext context, int type) {
        super(parent, true);
        this.insType = type;
        this._context = context;
        this.setSize(180, 100);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    public WizzardMultiRowColIns(Dialog parent, SpreadContext context, int type) {
        super(parent, true);
        this.insType = type;
        this._context = context;
        this.setSize(180, 100);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        String lable = this.insType == 0 ? MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS_LABEL") : MultiLanguageKeys.getLocalText("KEY_MULTI_COL_INS_LABEL");
        this._lbRows = new KDLabel(lable);
        this._tfRows = new KDFormattedTextField(0);
        this._tfRows.setGroupingUsed(false);
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        Container c = this.getContentPane();
        c.setLayout(null);
        this._lbRows.setBounds(10, 10, 60, 20);
        this._tfRows.setBounds(90, 10, 70, 20);
        this._okBtn.setBounds(10, 40, 30, 20);
        this._cancelBtn.setBounds(90, 40, 30, 20);
        c.add((Component)this._lbRows);
        c.add((Component)this._tfRows);
        c.add((Component)this._okBtn);
        c.add((Component)this._cancelBtn);
    }

    private void initListeners() {
        this._okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int num = 0;
                try {
                    num = Integer.parseInt(WizzardMultiRowColIns.this._tfRows.getText());
                }
                catch (Exception ex) {
                    return;
                }
                if (num < 1 || num > 1000) {
                    KDOptionPane.showMessageDialog(null, (Object)MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS_ERROR_OVERLENGTH_CONTENT"), (String)MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS_ERROR_OVERLENGTH_TITLE"), (int)0);
                    WizzardMultiRowColIns.this.lastInsertedRowCount = 0;
                    return;
                }
                Selection sel = WizzardMultiRowColIns.this._context.getBook().getActiveSheet().getSheetOption().getSelection();
                Selection.SelectIterator si = sel.getSelectIterator();
                while (si.hasNext()) {
                    CellBlock cb = si.next();
                    if (WizzardMultiRowColIns.this.insType == 0) {
                        if (cb.isCol()) {
                            KDOptionPane.showMessageDialog(null, (Object)MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS_ERROR_CONTENT"), (String)MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS_ERROR_TITLE"), (int)0);
                            return;
                        }
                        cb.setRow2(cb.getRow() + num - 1);
                        if (!WizzardMultiRowColIns.this._context.getRangeManager().getCompoundRangeInBook(sel.toRowSpans(), true).insert()) continue;
                        WizzardMultiRowColIns.this._context.getStateManager().addState(WizzardMultiRowColIns.this._context.getStateManager().createInsertState(true));
                        continue;
                    }
                    if (cb.isRow()) {
                        KDOptionPane.showMessageDialog(null, (Object)MultiLanguageKeys.getLocalText("KEY_MULTI_COL_INS_ERROR_CONTENT"), (String)MultiLanguageKeys.getLocalText("KEY_MULTI_COL_INS_ERROR_TITLE"), (int)0);
                        return;
                    }
                    cb.setCol2(cb.getCol() + num - 1);
                    if (!WizzardMultiRowColIns.this._context.getRangeManager().getCompoundRangeInBook(sel.toColumnSpans(), false).insert()) continue;
                    WizzardMultiRowColIns.this._context.getStateManager().addState(WizzardMultiRowColIns.this._context.getStateManager().createInsertState(true));
                }
                WizzardMultiRowColIns.this.lastInsertedRowCount = num;
                WizzardMultiRowColIns.this.closeDialog();
            }
        });
        this._cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardMultiRowColIns.this.closeDialog();
            }
        });
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public int getLastInsertedRowCount() {
        return this.lastInsertedRowCount;
    }
}

