/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.state.mouse;

import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.core.KDSpread;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.DefaultMouseController;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.DefaultMouseState;
import com.kingdee.bos.ctrl.kds.impl.state.mouse.IMouseState;
import com.kingdee.bos.ctrl.kds.impl.state.util.KDSpreadHelper;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.kds.model.util.SortedSpanArray;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class RowMouseController
extends DefaultMouseController {
    protected SpreadContext _context;
    private boolean resizable = true;
    private int[] hideRowsIndex;
    private static final float RESIZE_BUFFER_LENGTH = 2.0f;
    private static final int SELECT_ROW = 1;
    private static final int RESIZE_ROW = 2;
    private static final int RESIZE_HIDE_ROW = 3;
    private static final int STYLE_BRUSH = 4;
    private static final int STYLE_FETCH = 5;
    private int _stateFlag;
    private IMouseState ss = new SelectRowsState();
    private IMouseState rs = new ResizeRowsState();
    private int lastRow;
    private int lastPY;
    private int lastRowY;
    private int pressRow;
    private int pressRowY;
    private int pressPY;
    private boolean isResizing = false;

    public RowMouseController(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._stateFlag = 1;
        Point p = e.getPoint();
        int py = p.y;
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int row = SheetBaseMath.rowAtPoint(sheet, p);
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (pro != null && !pro.allowFormattingRows()) {
            this.pressRow = SheetBaseMath.dealInvalidCol(row);
            this._stateFlag = 1;
            return;
        }
        if (row == -1) {
            if ((float)SheetBaseMath.getSheetHeight(sheet) + 2.0f >= (float)py && py > 0) {
                this.pressRow = 1048575;
                int index = rowSpans.searchSpan(this.pressRow);
                this._stateFlag = index < 0 || rowSpans.getAttributeSpan(index).isVisible() ? 2 : 3;
            }
            return;
        }
        int rowY = SheetBaseMath.getRowY(sheet, row);
        if ((float)py <= (float)rowY + 2.0f && row > 0) {
            this.pressRow = row - 1;
            int index = rowSpans.searchSpan(this.pressRow);
            if (index < 0 || rowSpans.getAttributeSpan(index).isVisible()) {
                this._stateFlag = this.pressRow < view.getFirstRow() ? 1 : 2;
            } else if (this.resizable) {
                this._stateFlag = 3;
            } else {
                p.setLocation(p.x, p.y - 5);
                this.pressRow = row = SheetBaseMath.rowAtPoint(sheet, p);
                this._stateFlag = 2;
            }
        } else if ((float)py >= (float)(rowY + SheetBaseMath.getRowHeight(sheet, row) + 1) - 2.0f) {
            this.pressRow = row;
            this._stateFlag = 2;
        } else {
            this.pressRow = row;
            this._stateFlag = 1;
        }
        if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Brush)) {
            this._stateFlag = 4;
        } else if (this._context.getStateManager().isState(SpreadStateManager.Key_Style_Fetch)) {
            this._stateFlag = 5;
        }
        switch (this._stateFlag) {
            case 4: {
                view.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 5: {
                view.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 2: {
                view.setCursor(ResourceManager.getCustomCursor(view, "row_move.gif"));
                break;
            }
            case 3: {
                view.setCursor(ResourceManager.getCustomCursor(view, "row_split.gif"));
                break;
            }
            default: {
                view.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        SpreadStateManager sMgr = this._context.getStateManager();
        if (!sMgr.isState2(SpreadStateManager.Key_Range_Select) && !sMgr.stopEditing()) {
            return null;
        }
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        switch (this._stateFlag) {
            case 2: 
            case 3: {
                return this.rs;
            }
        }
        return this.ss;
    }

    public boolean isResizing() {
        return this.isResizing;
    }

    public int getOffset() {
        return this.lastPY - this.pressPY;
    }

    public int getCurRow() {
        return this.lastRow;
    }

    public int getPressRow() {
        return this.pressRow;
    }

    public int getCurRowVirtualH() {
        return this.lastPY - this.lastRowY;
    }

    private void showPopupMenu(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        this._context.getPopMenuManager().setRowBarOrColBar(true);
        JPopupMenu menu = this._context.getPopMenuManager().getPopMenu();
        menu.show(view, e.getX(), e.getY());
        menu.requestFocusInWindow();
    }

    private boolean needShowPopup(MouseEvent e) {
        return e.getButton() == 3 && e.getClickCount() == 1;
    }

    private boolean needReSelect(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int row = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
        return !sheet.getSheetOption().getSelection().isRowSelect(row);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    private void registerHideRow(Sheet sheet, Range r) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = r.size() - 1; i >= 0; --i) {
            CellBlock b = r.getBlock(i);
            if (b == null) continue;
            int k = Math.min(b.getRow(), b.getRow2());
            for (int j = Math.abs(b.getRow2() - b.getRow()) + 1; j >= 0; --j) {
                if (SheetBaseMath.getRowHeight(sheet, k + j) != 0) continue;
                list.add(new Integer(k + j));
            }
        }
        int size = list.size();
        this.hideRowsIndex = new int[size];
        for (int i = 0; i < size; ++i) {
            this.hideRowsIndex[i] = (Integer)list.get(i);
        }
    }

    private void reHeightHideRow() {
        if (this.hideRowsIndex == null || this.hideRowsIndex.length == 0) {
            return;
        }
        for (int i = this.hideRowsIndex.length - 1; i >= 0; --i) {
            this._context.getRangeManager().getRowRangeInBook(this.hideRowsIndex[i], this.hideRowsIndex[i]).setRowHidden(true);
        }
        this.hideRowsIndex = null;
    }

    class ResizeRowsState
    extends DefaultMouseState {
        ResizeRowsState() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.reFeatHeight(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            RowMouseController.this.pressPY = e.getY();
            RowMouseController.this.pressRowY = SheetBaseMath.getRowY(sheet, RowMouseController.this.pressRow);
            RowMouseController.this.lastRow = RowMouseController.this.pressRow;
            RowMouseController.this.lastPY = RowMouseController.this.pressPY;
            RowMouseController.this.lastRowY = RowMouseController.this.pressRowY;
            RowMouseController.this.isResizing = true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int curpy = e.getPoint().y;
            Rectangle r = view.getVisibleRect();
            if ((double)curpy < r.getY()) {
                curpy = r.y;
            }
            if (curpy != RowMouseController.this.lastPY) {
                if (curpy > RowMouseController.this.pressPY) {
                    RowMouseController.this.lastRow = RowMouseController.this.pressRow;
                    RowMouseController.this.lastRowY = RowMouseController.this.pressRowY;
                } else {
                    int curRow = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
                    if (curRow != RowMouseController.this.lastRow) {
                        RowMouseController.this.lastRow = curRow;
                        RowMouseController.this.lastRowY = SheetBaseMath.getRowY(sheet, RowMouseController.this.lastRow);
                    }
                }
                RowMouseController.this.lastPY = curpy;
                view.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.reheight(e);
            RowMouseController.this.isResizing = false;
        }

        private void reheight(MouseEvent e) {
            if (RowMouseController.this.lastPY == RowMouseController.this.pressPY) {
                return;
            }
            RowMouseController.this._context.getStateManager().stop();
            SpreadView view = (SpreadView)e.getSource();
            KDSpread spread = view.getSpread();
            Book book = spread.getBook();
            Sheet sheet = book.getActiveSheet();
            book.getUndoManager().startGroup();
            Selection sel = sheet.getSheetOption().getSelection();
            float scale = sheet.getSheetOption().getScaleNoPercent();
            if (!RowMouseController.this.resizable) {
                RowMouseController.this.registerHideRow(sheet, RowMouseController.this._context.getRangeManager().getSelectionRangeInBook());
            }
            if (RowMouseController.this.lastRow == RowMouseController.this.pressRow) {
                int newHeight = RowMouseController.this.lastPY - RowMouseController.this.lastRowY;
                newHeight = (int)((float)newHeight / scale);
                boolean isAutoCalculate = book.isAutoCalculate();
                boolean isExecuted = MiscUtil.isExecutedBook(book);
                if (sel.isRowSelect(RowMouseController.this.pressRow) && sel.isRowBlocks()) {
                    Integer oldHeight = RowMouseController.this._context.getRangeManager().getSelectionRangeInBook().getRowHeight();
                    if (oldHeight != null && isExecuted) {
                        if (oldHeight == 0 && newHeight != 0 || oldHeight != 0 && newHeight == 0) {
                            book.setAutoCalculate(true);
                        } else {
                            book.setAutoCalculate(false);
                        }
                    }
                    RowMouseController.this._context.getRangeManager().getSelectionRangeInBook().setRowHeight(newHeight);
                } else {
                    Integer oldHeight = RowMouseController.this._context.getRangeManager().getRowRangeInBook(RowMouseController.this.pressRow, RowMouseController.this.pressRow).getRowHeight();
                    if (oldHeight != null && isExecuted) {
                        if (oldHeight == 0 && newHeight != 0 || oldHeight != 0 && newHeight == 0) {
                            book.setAutoCalculate(true);
                        } else {
                            book.setAutoCalculate(false);
                        }
                    }
                    RowMouseController.this._context.getRangeManager().getRowRangeInBook(RowMouseController.this.pressRow, RowMouseController.this.pressRow).setRowHeight(newHeight);
                }
                book.setAutoCalculate(isAutoCalculate);
            } else {
                if (sel.isRowSelect(RowMouseController.this.pressRow) && sel.isRowBlocks()) {
                    Range rg = RowMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                    if (RowMouseController.this.lastRow < RowMouseController.this.pressRow - 1) {
                        rg.addAll(RowMouseController.this._context.getRangeManager().getRowRangeInBook(RowMouseController.this.lastRow + 1, RowMouseController.this.pressRow - 1));
                    }
                    rg.setRowHidden(true);
                } else {
                    RowMouseController.this._context.getRangeManager().getRowRangeInBook(RowMouseController.this.lastRow + 1, RowMouseController.this.pressRow).setRowHidden(true);
                }
                int newWidth = RowMouseController.this.lastPY - RowMouseController.this.lastRowY;
                newWidth = (int)((float)newWidth / scale);
                RowMouseController.this._context.getRangeManager().getRowRangeInBook(RowMouseController.this.lastRow, RowMouseController.this.lastRow).setRowHeight(newWidth);
            }
            if (!RowMouseController.this.resizable) {
                RowMouseController.this.reHeightHideRow();
            }
            book.getUndoManager().endGroup();
        }

        private void reFeatHeight(MouseEvent e) {
            SortedSpanArray spans;
            RowMouseController.this._context.getStateManager().stop();
            SpreadView view = (SpreadView)e.getSource();
            KDSpread spread = view.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            if (!RowMouseController.this.resizable) {
                RowMouseController.this.registerHideRow(sheet, RowMouseController.this._context.getRangeManager().getSelectionRangeInBook());
            }
            if (sel.isRowSelect(RowMouseController.this.pressRow) && sel.isRowBlocks()) {
                spans = sel.toRowSpans();
            } else {
                spans = new SortedSpanArray();
                spans.insert(new Span(RowMouseController.this.pressRow, RowMouseController.this.pressRow));
            }
            sheet.getBook().getUndoManager().startGroup();
            Graphics2D g2d = (Graphics2D)view.getGraphics();
            int size = spans.size();
            for (int spanIndex = 0; spanIndex < size; ++spanIndex) {
                Span span = (Span)spans.get(spanIndex);
                IntMarkEntry[] rows = sheet.getRows().subset(span.getStart(), span.getEnd());
                if (rows == null) {
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    int rowIndex = rows[i].getIntMark();
                    float height = SheetBaseMath.getMaxRowHeight(g2d, spread, (Row)rows[i]);
                    if (!(height > 0.0f)) continue;
                    RowMouseController.this._context.getRangeManager().getRowRangeInBook(rowIndex, rowIndex).setRowHeight((int)height + 4);
                }
            }
            if (!RowMouseController.this.resizable) {
                RowMouseController.this.reHeightHideRow();
            }
            sheet.getBook().getUndoManager().endGroup();
        }
    }

    class SelectRowsState
    extends DefaultMouseState {
        SelectRowsState() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Sheet sheet = RowMouseController.this._context.getBook().getActiveSheet();
            EmbedhLayer gl = sheet.getEmbedments(false);
            if (gl != null) {
                gl.cancelSelectedEmbeds();
            }
            boolean needShowPopup = RowMouseController.this.needShowPopup(e);
            boolean needReSelect = true;
            if (needShowPopup) {
                needReSelect = RowMouseController.this.needReSelect(e);
            }
            if (needReSelect) {
                SelectionAdapter sel = RowMouseController.this._context.getSelection();
                if (e.isShiftDown()) {
                    if (sel.changeSelection(CellBlock.getCellBlock(sheet.getActiveRow(), 0, RowMouseController.this.pressRow, 65535), 3)) {
                        SpreadView view = (SpreadView)e.getSource();
                        view.getSpread().setActiveView(view);
                        RowMouseController.this.lastRow = RowMouseController.this.pressRow;
                    }
                } else {
                    boolean selected = sel.changeSelection(CellBlock.getCellBlock(RowMouseController.this.pressRow, 0, RowMouseController.this.pressRow, 65535), e.isControlDown() ? 1 : 2, false);
                    if (selected) {
                        SpreadView view = (SpreadView)e.getSource();
                        view.getSpread().setActiveView(view);
                        RowMouseController.this.lastRow = RowMouseController.this.pressRow;
                    }
                }
            }
            if (needShowPopup) {
                RowMouseController.this.showPopupMenu(e);
            }
            SpreadView view = (SpreadView)e.getSource();
            String result = KDSpreadHelper.calSumAndAvg(view);
            RowMouseController.this._context.updateMesage(result);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            CellBlock updateB;
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = RowMouseController.this._context.getBook().getActiveSheet();
            SelectionAdapter sel = RowMouseController.this._context.getSelection();
            int curRow = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
            if ((curRow = SheetBaseMath.dealInvalidRow(curRow)) != RowMouseController.this.lastRow && sel.changeSelection(updateB = CellBlock.getCellBlock(e.isShiftDown() ? sheet.getActiveRow() : RowMouseController.this.pressRow, 0, curRow, 65535), 3, false)) {
                RowMouseController.this.lastRow = curRow;
                view.scrollCellVisible(curRow, 0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadStateManager sm = RowMouseController.this._context.getStateManager();
            if (RowMouseController.this._stateFlag == 5) {
                sm.stop();
                ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
            } else if (RowMouseController.this._stateFlag == 4) {
                Range r = RowMouseController.this._context.getRangeManager().getSelectionRangeInBook();
                if (r.paste(PasteMode.FORMATS, null)) {
                    RowMouseController.this._context.getStateManager().stop();
                    ((SpreadView)e.getSource()).setCursor(Cursor.getDefaultCursor());
                }
            } else if (sm.isState(SpreadStateManager.Key_Range_Select)) {
                // empty if block
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SpreadView view = RowMouseController.this._context.getSpread().getActiveView();
            int firstRow = view.calcFirstRowByEndRow(view.getEndRow());
            RowMouseController.this._context.getSpread().setViewRow(view, firstRow - 1);
            super.mouseWheelMoved(e);
        }
    }
}

