/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm.explorer;

import com.kingdee.bos.ctrl.kds.io.htm.HtmlExporter;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.ViewSplitInfo;

public class HtmlHeader {
    private boolean _headerSet;
    private int _row;
    private int _col;
    private HtmlExporter.HtmlBuffer _rowHtml;

    public HtmlHeader(Sheet sheet, String visitFilePrefixPath, String fileSavePath) {
        ViewSplitInfo splitInfo = sheet.getSheetOption().getViewSplitInfo();
        this._headerSet = splitInfo.isFreezed();
        if (this._headerSet) {
            this._row = splitInfo.getRowSplit();
            this._col = splitInfo.getColSplit();
        }
    }

    public String getLockCssClass(int row, int col) {
        if (this._headerSet) {
            if (row < this._row && col < this._col) {
                return "CLock";
            }
            if (row < this._row && col >= this._col) {
                return "VLock";
            }
            if (row >= this._row && col < this._col) {
                return "HLock";
            }
        }
        return "";
    }

    public static String getHorizontalCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("HLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 10;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" left: expression( this.parentElement.offsetParent.parentElement.scrollLeft );").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getVerticalCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("VLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 20;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" top: expression(this.parentElement.offsetParent.parentElement.scrollTop);").append("\r\n");
        cssBuf.append('}');
        return cssBuf.toString();
    }

    public static String getCornerCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("CLock").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" z-index: 30;").append("\r\n");
        cssBuf.append(" position: relative;").append("\r\n");
        cssBuf.append(" top: expression(this.parentElement.offsetParent.parentElement.scrollTop);").append("\r\n");
        cssBuf.append(" left: expression( this.parentElement.offsetParent.parentElement.scrollLeft ); ").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getHorizontalBoundaryLineCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("bdb").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" BORDER-BOTTOM: #000000 1px solid;").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public static String getVerticalBoundaryLineCss() {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append("td").append('.').append("bdr").append("\r\n");
        cssBuf.append('{');
        cssBuf.append(" BORDER-RIGHT: #000000 1px solid;").append("\r\n");
        cssBuf.append('}').append("\r\n");
        return cssBuf.toString();
    }

    public String getHorizontalBoundaryLine(int row) {
        if (this._headerSet && row == this._row - 1) {
            return "bdb";
        }
        return "";
    }

    public String getVerticalBoundaryLine(int col) {
        if (this._headerSet && this._col == col + 1) {
            return "bdr";
        }
        return "";
    }

    public boolean hasHeader() {
        return this._headerSet;
    }

    public boolean isHorizontalHeaderSet() {
        return this._headerSet && this._row > 0;
    }

    public int getRow() {
        return this._row;
    }

    public int getCol() {
        return this._col;
    }

    public void setHtml(HtmlExporter.HtmlBuffer buffer) {
        this._rowHtml = buffer;
    }

    public String getHeader() {
        if (this._rowHtml == null) {
            return "";
        }
        return this._rowHtml.toString();
    }
}

