/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm.explorer;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MeasureHelper {
    private SortedAttributeSpanArray.AttributeSpan _curSpan;
    private int _pureTextLength;
    private int _defaultLength;
    private boolean _isRow;
    private ArrayList _attentions;
    private IntArray _attenValues;
    private int _rowPointer;
    private boolean _started = false;
    private Iterator _attenIter;

    public MeasureHelper(boolean isRow, int defaultLength) {
        this._isRow = isRow;
        this._defaultLength = defaultLength;
        this._attentions = new ArrayList();
        this._attenValues = new IntArray();
    }

    public int getLength(int pos, SortedAttributeSpanArray array, Cell cell) {
        int length;
        if (!this._started) {
            Iterator iterator = this._attenIter = this._attentions.isEmpty() ? null : this._attentions.iterator();
            if (this._attenIter != null) {
                Integer temp = (Integer)this._attenIter.next();
                this._rowPointer = temp;
            } else {
                this._rowPointer = -1;
            }
            this._started = true;
        }
        if (this._curSpan != null && pos >= this._curSpan.getStart() && pos <= this._curSpan.getEnd()) {
            length = this._curSpan.getLength();
        } else {
            int spanIdx = array.searchSpan(pos);
            if (spanIdx < 0) {
                this._curSpan = null;
                length = this._defaultLength;
            } else {
                this._curSpan = (SortedAttributeSpanArray.AttributeSpan)array.getSpan(spanIdx);
                length = this._curSpan.getLength();
            }
        }
        if (this._rowPointer != -1 && pos >= this._rowPointer) {
            this._attenValues.add(this._pureTextLength);
            Integer temp = this._attenIter.hasNext() ? (Integer)this._attenIter.next() : new Integer(-1);
            this._rowPointer = temp;
        }
        this._pureTextLength += length;
        this._pureTextLength += this.calculateBorder(cell);
        return length;
    }

    public static int getItemLength(int pos, SortedAttributeSpanArray array, Cell cell, boolean isRow) {
        int length;
        int spanIdx = array.searchSpan(pos);
        if (spanIdx < 0) {
            length = cell.getSheet().getOriginalDefRowHeight();
            length += MeasureHelper.calculateBorder(cell, isRow);
        } else {
            SortedAttributeSpanArray.AttributeSpan span = (SortedAttributeSpanArray.AttributeSpan)array.getSpan(spanIdx);
            length = span.getLength();
        }
        return length;
    }

    public void addAttention(int position) {
        Integer num = new Integer(position);
        if (!this._attentions.contains(num)) {
            this._attentions.add(num);
            Collections.sort((List)this._attentions);
        }
    }

    public int getAttensionValue(int position) {
        int index = this._attentions.indexOf(new Integer(position));
        int result = -1;
        if (this._attenValues.size() > index) {
            result = index == -1 ? -1 : this._attenValues.get(index);
        } else if (index >= 0) {
            result = this.getTotalLength();
        }
        return result;
    }

    public int getTotalLength() {
        return this._pureTextLength;
    }

    public void clear() {
        this._curSpan = null;
        this._pureTextLength = 0;
        this._started = false;
    }

    public void refreshMaxLength(int length) {
        if (this._pureTextLength < length) {
            this._pureTextLength = length;
        }
    }

    private int calculateBorder(Cell cell) {
        return MeasureHelper.calculateBorder(cell, this._isRow);
    }

    private static int calculateBorder(Cell cell, boolean isRow) {
        if (null == cell) {
            return 0;
        }
        int a = 0;
        int b = 0;
        Styles.Position[] positions = new Styles.Position[2];
        if (!isRow) {
            positions[0] = Styles.Position.LEFT;
            positions[1] = Styles.Position.RIGHT;
        } else {
            positions[0] = Styles.Position.TOP;
            positions[1] = Styles.Position.BOTTOM;
        }
        Style style = cell.getStyle();
        if (style.hasBorderAttributes(positions[0]) && style.hasAttributes(ShareStyleAttributes.BORDER_LEFT_LINESTYLE)) {
            a = Math.max(style.getBorderLineStyle(Styles.Position.LEFT).getWidth(), a);
        }
        if (style.hasBorderAttributes(positions[1]) && style.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_LINESTYLE)) {
            b = Math.max(style.getBorderLineStyle(Styles.Position.RIGHT).getWidth(), b);
        }
        return a + b;
    }

    private boolean needAttention() {
        return !this._attentions.isEmpty();
    }
}

