/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm.extweb;

import com.kingdee.bos.ctrl.extcommon.util.ObjectCache;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.HtmlHeader;
import com.kingdee.bos.ctrl.kds.io.htm.extweb.ReportHeader;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Style2Css {
    private Map _styles;
    private Sheet _sheet;
    private Any2Css[] _2Css;
    private boolean _isTree;
    private static Map _textAlign = new HashMap();
    private static Map _verticalMap;
    private static Map _borderKeys;

    public Style2Css(Sheet sheet) {
        this._sheet = sheet;
        this._2Css = new Any2Css[]{new Align2Css(), new Border2Css(), new ColorFont2Css()};
        this._styles = new HashMap(10);
    }

    public String toCss() {
        Iterator iterator = this._styles.keySet().iterator();
        HashMap map = new HashMap(this._styles.size());
        while (iterator.hasNext()) {
            Integer key = (Integer)iterator.next();
            Style style = (Style)this._styles.get(key);
            String entryKey = String.valueOf(key);
            HashMap entryMap = new HashMap();
            for (int i = 0; i < this._2Css.length; ++i) {
                this._2Css[i].setStyle(style);
                entryMap.putAll(this._2Css[i].toCss());
            }
            map.put(entryKey, entryMap);
        }
        StringBuffer styleBuffer = new StringBuffer(1024);
        if (map.size() > 0) {
            for (String styleID : map.keySet()) {
                Map style = (Map)map.get(styleID);
                if (style == null) continue;
                styleBuffer.append('.');
                styleBuffer.append('x').append(styleID).append("\r\n");
                styleBuffer.append('{');
                for (String pkey : style.keySet()) {
                    String pValue = (String)style.get(pkey);
                    styleBuffer.append(pkey);
                    styleBuffer.append(':');
                    styleBuffer.append(pValue);
                    styleBuffer.append(';');
                    styleBuffer.append("\r\n");
                }
                styleBuffer.append('}');
                styleBuffer.append("\r\n");
            }
        }
        if (this._isTree) {
            styleBuffer.append(HtmlHeader.getCornerCss());
            styleBuffer.append(HtmlHeader.getHorizontalCss());
            styleBuffer.append(HtmlHeader.getVerticalCss());
            styleBuffer.append(HtmlHeader.getHorizontalBoundaryLineCss());
            styleBuffer.append(HtmlHeader.getVerticalBoundaryLineCss());
        } else {
            styleBuffer.append(ReportHeader.getCornerCss());
            styleBuffer.append(ReportHeader.getHorizontalCss());
            styleBuffer.append(ReportHeader.getVerticalCss());
            styleBuffer.append(ReportHeader.getHorizontalBoundaryLineCss());
            styleBuffer.append(ReportHeader.getVerticalBoundaryLineCss());
        }
        return styleBuffer.toString();
    }

    public void setTree(boolean isTree) {
        this._isTree = isTree;
    }

    public void addStyle(Style style) {
        if (style != null && !style.isEmpty()) {
            Integer key = new Integer(style.getUID());
            this._styles.put(key, style);
        }
    }

    public void mergeStyle(Map map) {
        if (map != null && !map.isEmpty()) {
            this._styles.putAll(map);
        }
    }

    public Map getStyle() {
        return this._styles;
    }

    static {
        _textAlign.put(ObjectCache.getInteger(0), "left");
        _textAlign.put(ObjectCache.getInteger(1), "left");
        _textAlign.put(ObjectCache.getInteger(2), "center");
        _textAlign.put(ObjectCache.getInteger(3), "right");
        _verticalMap = new HashMap();
        _verticalMap.put(ObjectCache.getInteger(1), "top");
        _verticalMap.put(ObjectCache.getInteger(2), "middle");
        _verticalMap.put(ObjectCache.getInteger(3), "bottom");
        _borderKeys = new HashMap();
        _borderKeys.put(Styles.Position.LEFT, "border-left");
        _borderKeys.put(Styles.Position.RIGHT, "border-right");
        _borderKeys.put(Styles.Position.TOP, "border-top");
        _borderKeys.put(Styles.Position.BOTTOM, "border-bottom");
        _borderKeys.put(PenStyle.PS_SOLID, "solid");
        _borderKeys.put(PenStyle.PS_DOT, "dashed");
        _borderKeys.put(PenStyle.PS_CONTINUOUS, "dotted");
    }

    private class ColorFont2Css
    implements Any2Css {
        private Style _style;

        public ColorFont2Css() {
        }

        public ColorFont2Css(Style style) {
            this._style = style;
        }

        @Override
        public Map toCss() {
            Color clr;
            HashMap<String, String> map = new HashMap<String, String>();
            if (this._style.hasFontAttributes()) {
                this.font2Css(map);
            }
            if ((clr = this._style.getBackground()) != null) {
                map.put("background", StyleParser.colorToHex((Color)clr));
            }
            return map;
        }

        private void font2Css(Map entryMap) {
            boolean bvalue;
            Object obvalue = this._style.get(ShareStyleAttributes.FONT_NAME);
            if (obvalue != null) {
                entryMap.put("font-family", obvalue);
            }
            if ((obvalue = this._style.get(ShareStyleAttributes.FONT_SIZE)) != null) {
                int intvalue = (Integer)obvalue;
                entryMap.put("font-size", intvalue + "pt");
            }
            if ((obvalue = this._style.get(ShareStyleAttributes.FONT_WEIGHT)) != null) {
                float fvalue = ((Float)obvalue).floatValue();
                Object bold = this._style.get(ShareStyleAttributes.FONT_BOLD);
                boolean isBold = (Boolean)bold;
                if (isBold) {
                    fvalue = 700.0f;
                }
                entryMap.put("font-weight", String.valueOf((int)fvalue));
                bold = null;
                isBold = false;
            }
            if ((obvalue = this._style.get(ShareStyleAttributes.FONT_ITALIC)) != null && (bvalue = ((Boolean)obvalue).booleanValue())) {
                entryMap.put("font-style", "italic");
            }
            obvalue = this._style.get(ShareStyleAttributes.FONT_UNDERLINE);
            boolean isUnderLine = false;
            if (obvalue != null) {
                boolean bvalue2;
                isUnderLine = bvalue2 = ((Boolean)obvalue).booleanValue();
                if (bvalue2) {
                    entryMap.put("text-decoration", "underline");
                }
            }
            if ((obvalue = this._style.get(ShareStyleAttributes.FONT_STRIKETHROUGH)) != null) {
                boolean bvalue3 = (Boolean)obvalue;
                if (bvalue3 && !isUnderLine) {
                    entryMap.put("text-decoration", "line-through");
                }
                if (bvalue3 && isUnderLine) {
                    entryMap.put("text-decoration", "underline line-through");
                }
            }
            if ((obvalue = this._style.get(ShareStyleAttributes.FONT_COLOR)) != null) {
                entryMap.put("color", StyleParser.colorToHex((Color)((Color)obvalue)));
            }
        }

        @Override
        public void setStyle(Style style) {
            this._style = style;
        }
    }

    private class Border2Css
    implements Any2Css {
        private Style _style;

        public Border2Css() {
        }

        public Border2Css(Style style) {
            this._style = style;
        }

        @Override
        public Map toCss() {
            if (this._style.hasBordersAttributes()) {
                Styles.Position[] ptss = new Styles.Position[]{Styles.Position.LEFT, Styles.Position.TOP, Styles.Position.RIGHT, Styles.Position.BOTTOM};
                HashMap<String, String> map = new HashMap<String, String>();
                StringBuffer sbtemp = null;
                for (int i = 0; i < ptss.length; ++i) {
                    LineStyle ls;
                    if (!this._style.hasBorderAttributes(ptss[i]) || LineStyle.isNull((LineStyle)(ls = this._style.getBorderLineStyle(ptss[i])))) continue;
                    String entryKey = (String)_borderKeys.get(ptss[i]);
                    String string = entryKey = entryKey == null ? "" : entryKey;
                    if (sbtemp == null) {
                        sbtemp = new StringBuffer();
                    } else {
                        sbtemp.setLength(0);
                    }
                    sbtemp.append(this._style.getBorderLineStyle(ptss[i]).getWidth()).append("px");
                    sbtemp.append(' ');
                    String borderStyle = (String)_borderKeys.get(this._style.getBorderPenStyle(ptss[i]));
                    if (borderStyle == null && this._style.getBorderLineStyle(ptss[i]).getName().equals("TrigramHollow")) {
                        borderStyle = "double";
                    }
                    sbtemp.append(borderStyle);
                    sbtemp.append(' ');
                    sbtemp.append(StyleParser.colorToHex((Color)this._style.getBorderColor(ptss[i])));
                    map.put(entryKey, sbtemp.toString());
                }
                return map;
            }
            return null;
        }

        @Override
        public void setStyle(Style style) {
            this._style = style;
        }
    }

    private class Align2Css
    implements Any2Css {
        private Style _style;

        public Align2Css() {
        }

        public Align2Css(Style style) {
            this._style = style;
        }

        @Override
        public Map toCss() {
            HashMap<String, String> map = new HashMap<String, String>();
            String csValue = null;
            Object value = this._style.get(ShareStyleAttributes.HORIZONTAL_ALIGN);
            if (value != null) {
                csValue = (String)_textAlign.get(new Integer(((Styles.HorizontalAlignment)value).getValue()));
                if (csValue == null) {
                    csValue = "left";
                }
                map.put("text-align", csValue);
            } else {
                map.put("text-align", csValue);
            }
            value = this._style.get(ShareStyleAttributes.VERTICAL_ALIGN);
            if (value != null) {
                csValue = (String)_verticalMap.get(new Integer(((Styles.VerticalAlignment)value).getValue()));
                csValue = csValue == null ? "" : csValue;
                map.put("vertical-align", csValue);
            }
            if ((value = this._style.get(ShareStyleAttributes.WRAP_TEXT)) != null && ((Boolean)value).booleanValue()) {
                map.put("word-break", "normal");
                map.put("word-wrap", "break-word");
            } else {
                map.put("word-break", "keep-all");
                map.put("word-wrap", "normal");
            }
            return map;
        }

        @Override
        public void setStyle(Style style) {
            this._style = style;
        }
    }

    private static interface Any2Css {
        public void setStyle(Style var1);

        public Map toCss();
    }
}

