/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.expr;

import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;

public class ExprArray
implements IExprNode {
    public static final int MAX_ARGS = 255;
    private static final ExprArray[] _arrays = new ExprArray[256];
    private int _args;

    private ExprArray(int args) {
        this._args = args;
    }

    public static ExprArray getInstance(int args) throws SyntaxErrorException {
        if (args > 255) {
            ExprErr.goError(8L, "too many params: " + args);
        }
        return _arrays[args];
    }

    public int getParameterCount() {
        return this._args;
    }

    @Override
    public int getExprType() {
        return 16384;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ObjectStack stack = ctx.getCurrentExprStack();
        Variant[] a = new Variant[this._args];
        Variant item = null;
        for (int i = this._args - 1; i >= 0; --i) {
            a[i] = item = (Variant)stack.pop();
        }
        Variant var = new Variant(a, 527);
        if (ctx.isTraceMode()) {
            int tracePos = item == null ? ctx.getTracePos() : ((TraceVariant)item).getTracePos();
            var = new TraceVariant(var, tracePos);
        }
        stack.push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return "";
    }

    public String toString() {
        return "Array:" + this._args;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ExprArray._arrays[i] = new ExprArray(i);
        }
    }
}

