/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParams;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;

public class ExprConst
implements IExprNode {
    public static final ExprConst TRUE = new ExprConst(Variant.trueVariant);
    public static final ExprConst FALSE = new ExprConst(Variant.falseVariant);
    public static final ExprConst NULL = new ExprConst(Variant.nullVariant);
    public static final ExprConst BADID = new ExprConst(new Variant(new SyntaxErrorException(131072L), 16));
    public static final ExprConst DEFAULT_PARAM = new ExprConst(Variant.nullVariant);
    private Variant _value;
    private int _hashCode;

    public static ExprConst getExprConst(WeakHashSet set, Variant value) {
        ExprConst out;
        ExprConst in = new ExprConst(value);
        Object obj = set.get(in);
        if (obj == null) {
            set.add(in);
            out = in;
        } else {
            out = (ExprConst)obj;
        }
        return out;
    }

    public ExprConst(Variant value) {
        this._value = value;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._value.isNull() || this._value.isEmpty() ? Integer.MAX_VALUE : this._value.hashCode();
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ExprConst) {
            Variant cmpValue = ((ExprConst)obj)._value;
            if (this._value.getVt() != cmpValue.getVt()) {
                return false;
            }
            return this._value.equals(cmpValue);
        }
        return false;
    }

    public Variant getValue() {
        return this._value;
    }

    public String toString() {
        return this._value.toString();
    }

    @Override
    public int getExprType() {
        return 2;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ctx.getCurrentExprStack().push(ctx.isTraceMode() ? new TraceVariant(this._value, ctx) : this._value);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        Object obj = this._value.getValue();
        if (obj instanceof Cell) {
            return "";
        }
        if (obj instanceof CellBlockNode) {
            return ((CellBlockNode)obj).decode(ctx, exprOwner);
        }
        int type = this._value.getVt();
        if (type == 11) {
            String orgStr = this._value.toString();
            StringBuilder sb = new StringBuilder(orgStr.length() + 2);
            sb.append('\"');
            int end = orgStr.length();
            for (int i = 0; i < end; ++i) {
                char ch = orgStr.charAt(i);
                if (ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            sb.append('\"');
            return sb.toString();
        }
        if (type == 16395) {
            String orgStr = (String)obj;
            return StringUtil.isEmptyString((String)orgStr) ? "\\\"\\\"" : orgStr;
        }
        if (type == 527) {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            Variant[] vars = (Variant[])this._value.getValue();
            int size = vars.length;
            for (int index = 0; index < size; ++index) {
                Variant var = vars[index];
                String orgStr = var.toString();
                if (var.getVt() == 11) {
                    sb.append('\"');
                    int end = orgStr.length();
                    for (int i = 0; i < end; ++i) {
                        char ch = orgStr.charAt(i);
                        if (ch == '\"') {
                            sb.append('\\');
                        }
                        sb.append(ch);
                    }
                    sb.append('\"');
                } else {
                    sb.append(orgStr);
                }
                if (index + 1 == size) continue;
                sb.append(',');
            }
            sb.append('}');
            return sb.toString();
        }
        return this._value.toString();
    }

    private boolean isValidParam(ICalculable exprOwner, String orgStr) {
        IExprNode[] nodes;
        ExprParams ep;
        boolean isValid = false;
        Sheet sheet = exprOwner.getSheet();
        Expr expr = sheet.getExpr(null, sheet.getSyntaxName() + '!' + orgStr);
        if (expr != null && !expr.isSyntaxError() && (ep = expr.getExprParams()) != null && (nodes = ep.getNodes()).length > 0 && nodes[0] instanceof CellBlockNode) {
            isValid = true;
        }
        return isValid;
    }
}

