/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import com.kingdee.bos.ctrl.kds.model.util.SortedIntArray;
import java.util.Calendar;
import java.util.Date;

public class SpecialDays
extends SortedIntArray {
    public void setSpecialDays(String yearDays) throws SyntaxErrorException {
        int yearStart;
        int yearEnd;
        String[] defines;
        if (yearDays == null || yearDays.length() == 0) {
            ExprErr.goError(16L, "Empty Defines");
        }
        if ((defines = StringUtil.replace((String)yearDays, (String)" ", (String)"").split(",")).length < 2) {
            ExprErr.goError(16L, "Empty Days");
        }
        Calendar cal = Calendar.getInstance();
        String yearSpan = defines[0];
        int pos = yearSpan.indexOf(126);
        if (pos < 0) {
            yearStart = yearEnd = Variant.stringToNumberVar(yearSpan).intValue();
        } else {
            String year = yearSpan.substring(0, pos);
            if (year.length() == 0) {
                yearStart = 1900;
            } else {
                yearStart = Variant.stringToNumberVar(year).intValue();
                if (yearStart < 1900) {
                    ExprErr.goError(16L, "Bad Start Year: " + yearStart);
                }
            }
            year = yearSpan.substring(pos + 1);
            if (year.length() == 0) {
                yearEnd = cal.get(1);
            } else {
                yearEnd = Variant.stringToNumberVar(year).intValue();
                if (yearEnd > 2200) {
                    ExprErr.goError(16L, "Bad End Year: " + yearEnd);
                }
            }
            if (yearStart > yearEnd) {
                int tmp = yearStart;
                yearStart = yearEnd;
                yearEnd = tmp;
            }
        }
        IntArray days = new IntArray(defines.length - 1);
        cal.set(14, 0);
        for (int i = 1; i < defines.length; ++i) {
            long dayStart;
            long dayEnd;
            Variant var;
            String daySpan = defines[i];
            int pos2 = daySpan.indexOf(126);
            if (pos2 < 0) {
                var = DataConvert.getDay(daySpan);
                if (var.isNull()) {
                    ExprErr.goError(16L, "Bad Day: " + daySpan);
                }
                dayStart = dayEnd = ((Date)var.getValue()).getTime();
            } else {
                String day = daySpan.substring(0, pos2);
                var = DataConvert.getDay(day);
                if (var.isNull()) {
                    ExprErr.goError(16L, "Bad Start Day: " + daySpan);
                }
                dayStart = ((Date)var.getValue()).getTime();
                day = daySpan.substring(pos2 + 1);
                var = DataConvert.getDay(day);
                if (var.isNull()) {
                    ExprErr.goError(16L, "Bad End Day: " + daySpan);
                }
                if (dayStart > (dayEnd = ((Date)var.getValue()).getTime())) {
                    long tmp = dayStart;
                    dayStart = dayEnd;
                    dayEnd = tmp;
                }
            }
            cal.setTimeInMillis(dayStart);
            int m = cal.get(2) + 1;
            if (m < 3) {
                cal.setTimeInMillis(dayEnd);
                int m2 = cal.get(2) + 1;
                if (m2 >= 3 || m2 == 2 && cal.get(5) == 29) {
                    days.add(229);
                }
            }
            while (dayStart <= dayEnd) {
                cal.setTimeInMillis(dayStart);
                days.add((cal.get(2) + 1) * 100 + cal.get(5));
                dayStart += 86400000L;
            }
        }
        int daysCount = days.size();
        this.ensureCapacity(this.size() + daysCount * (yearEnd - yearStart + 1));
        while (yearStart <= yearEnd) {
            int year = yearStart * 10000;
            for (int i = 0; i < daysCount; ++i) {
                this.insert(year + days.get(i));
            }
            ++yearStart;
        }
    }
}

