/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.Color;

public class SheetAction_Content
extends SheetAction {
    private Object _data;
    private Cell.ContentType _dataType;

    public SheetAction_Content(Range rg, Object data, Cell.ContentType dataType) {
        super(rg, SheetChangeEvent.Changed_Content);
        this._data = data;
        this._dataType = dataType;
    }

    public SheetAction_Content(Range rg, Object data, Cell.ContentType dataType, long changedStates) {
        super(rg, changedStates);
        this._data = data;
        this._dataType = dataType;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        boolean bCreateCell = this._dataType == Cell.FORMULA ? !StringUtil.isEmptyString((String)((String)this._data)) : this._data != null;
        Book book = sheet.getBook();
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        if (bCreateCell) {
            SortedCellBlockArray merges = sheet.getTouchedMergeBlocks(cb);
            for (int r = row; r <= row2; ++r) {
                Row rowObj = this.getStateRow(state, sheet, r);
                for (int c = col; c <= col2; ++c) {
                    CellBlock mergeBlock;
                    if (merges != null && (mergeBlock = merges.searchBlock(r, c)) != null && !mergeBlock.isFirstCell(r, c)) {
                        c = mergeBlock.getCol2() + 1;
                        continue;
                    }
                    Cell cll = this.getStateCell(state, sheet, rowObj, c);
                    if (this._dataType == Cell.FORMULA) {
                        String formula = (String)this._data;
                        if (formula.equals(cll.getFormula())) continue;
                        this.setCellState(state, cll, cll.getFormula(), null);
                        if (!cll.setFormula(formula) || !book.isCalcCurrentCell()) continue;
                        cll.calcFormulaProps(cll.getSheet().getDeps().getExprContext());
                        continue;
                    }
                    if (this._dataType == Cell.VALUE) {
                        Variant value = (Variant)this._data;
                        Variant var = cll.getValue();
                        this.setCellState(state, cll, var, new Integer(cll.getFlags()));
                        cll.setValue(value);
                        continue;
                    }
                    if (this._dataType == Cell.HYPERLINK) {
                        HyperLink link = (HyperLink)this._data;
                        if (StringUtil.isEmptyString((String)link.getText())) {
                            link.setText(cll.getText());
                        } else if (cll.isEmptyContent()) {
                            cll.setFormula(link.getText());
                        }
                        this.resetExtValue("inner_hyperlink", this._data, cll, state);
                        ShareStyleAttributes ssa = cll.getSSA();
                        this.setCellState(state, cll, ssa, null);
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                        if (sa.getFontColor() == null || sa.getFontColor() == Color.BLACK) {
                            sa.setFontColor(Color.blue);
                        }
                        sa.setUnderline(true);
                        cll.setSSA(book.getSSA(sa));
                        continue;
                    }
                    if (this._dataType == Cell.DIAGONAL) {
                        this.resetExtValue("inner_diagonal", this._data, cll, state);
                        continue;
                    }
                    if (this._dataType == Cell.COMMENT) {
                        this.resetExtValue("inner_comment", this._data, cll, state);
                        continue;
                    }
                    if (this._dataType == Cell.SUBRPT) {
                        this.resetExtValue("inner_report", this._data, cll, state);
                        cll.getExtProps(true).getFormulas(true).insert(this._data);
                        continue;
                    }
                    UserObject uo = (UserObject)this._data;
                    UserObject obj = cll.getUserObject(uo.getKey());
                    if (uo.equals(obj)) continue;
                    if (uo.getValue() == null) {
                        if (obj == null) continue;
                        cll.removeUserObject(uo.getKey());
                        this.setCellState(state, cll, obj, null);
                        continue;
                    }
                    cll.setUserObject(uo);
                    if (obj == null) {
                        this.setCellState(state, cll, uo.getKey(), null);
                        continue;
                    }
                    this.setCellState(state, cll, obj, null);
                }
            }
        } else {
            Sheet.RowsIterator ri = sheet.getRowsIterator(row, row2, false);
            while (ri.hasNext()) {
                int pos2;
                Row rowObj = ri.next();
                int pos = rowObj.getProperPos(col, false);
                for (int p = pos2 = rowObj.getProperPos(col2, true); p >= pos; --p) {
                    Cell cll = rowObj.getAt(p);
                    if (this._dataType == Cell.FORMULA) {
                        if (StringUtil.isEmptyString((String)cll.getFormula())) continue;
                        this.setCellState(state, cll, cll.getFormula(), null);
                        cll.setFormula("");
                        continue;
                    }
                    if (this._dataType == Cell.VALUE) {
                        Variant var = cll.getValue();
                        if (Variant.isNull(var)) continue;
                        this.setCellState(state, cll, var, new Integer(cll.getFlags()));
                        cll.setValue(Variant.nullVariant);
                        continue;
                    }
                    if (this._dataType == Cell.COMMENT) {
                        this.clearExtValue("inner_comment", this._data, cll, state);
                        continue;
                    }
                    if (this._dataType == Cell.DIAGONAL) {
                        this.clearExtValue("inner_diagonal", this._data, cll, state);
                        continue;
                    }
                    if (this._dataType == Cell.HYPERLINK) {
                        if (cll.getHyperLink() == null) continue;
                        this.clearExtValue("inner_hyperlink", this._data, cll, state);
                        ShareStyleAttributes ssa = cll.getSSA();
                        this.setCellState(state, cll, ssa, null);
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                        if (ssa.getFontColor() == Color.BLUE) {
                            sa.setFontColor(Styles.getDefaultSSA().getFontColor());
                        } else {
                            sa.setFontColor(ssa.getFontColor());
                        }
                        sa.setUnderline(Styles.getDefaultSSA().isUnderline());
                        cll.setSSA(book.getSSA(sa));
                        continue;
                    }
                    SortedUserObjectArray userobjs = cll.getUserObjects(false);
                    if (userobjs == null) continue;
                    cll.setUserObjects(null);
                    this.setCellState(state, cll, userobjs, null);
                }
            }
        }
        this.checkedAutoFilter(sheet, state);
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = new CellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            ObjectArray values2 = (ObjectArray)state.get("CELL_VALUE2");
            int size = clls.size();
            for (int i = 0; i < size; ++i) {
                Object value2;
                Cell cll = (Cell)clls.get(i);
                Object value = values.get(i);
                if (this._dataType == Cell.FORMULA) {
                    cll.setFormula((String)value);
                    continue;
                }
                if (this._dataType == Cell.VALUE) {
                    cll.setValue((Variant)value);
                    cll.setFlags((int)((Integer)values2.get(i) & 0xFFFFFFFD));
                    continue;
                }
                if (this._dataType == Cell.DIAGONAL) {
                    value2 = values2.get(i);
                    this.resumeExtValue("inner_diagonal", value2, cll);
                    continue;
                }
                if (this._dataType == Cell.COMMENT) {
                    value2 = values2.get(i);
                    this.resumeExtValue("inner_comment", value2, cll);
                    continue;
                }
                if (this._dataType == Cell.HYPERLINK) {
                    if (i == 0) {
                        value2 = values2.get(i);
                        this.resumeExtValue("inner_hyperlink", value2, cll);
                        continue;
                    }
                    if (i == 1) {
                        cll.setSSA((ShareStyleAttributes)value);
                        continue;
                    }
                    if (i != 2) continue;
                    cll.setFormula((String)value);
                    continue;
                }
                if (this._dataType == Cell.SUBRPT) {
                    value2 = values2.get(i);
                    SortedExtPropFormulasArray fArr = cll.getExtProps(false).getFormulas(false);
                    fArr.remove(cll.getSubReportInfo());
                    if (value2 instanceof SubReportInfo) {
                        fArr.insert(value2);
                    }
                    this.resumeExtValue("inner_report", value2, cll);
                    continue;
                }
                if (value instanceof String) {
                    cll.removeUserObject((String)value);
                    continue;
                }
                if (value instanceof UserObject) {
                    UserObject uo = (UserObject)value;
                    cll.setUserObject(uo);
                    continue;
                }
                SortedUserObjectArray uos = (SortedUserObjectArray)value;
                cll.setUserObjects(uos);
            }
        }
        this.resumeAutoFilter(sheet, state);
    }

    private void resetExtValue(String key, Object data, Cell cll, URState state) {
        Object oldValue = cll.getExtObject(key);
        if (!data.equals(oldValue)) {
            cll.setExtObject(key, data);
            if (oldValue == null) {
                this.setCellState(state, cll, key, key);
            } else {
                this.setCellState(state, cll, key, oldValue);
            }
        }
    }

    private void clearExtValue(String key, Object data, Cell cll, URState state) {
        Object o = cll.getExtObject(key);
        if (o != null) {
            cll.clearExtObject(key);
            this.setCellState(state, cll, key, o);
        }
    }

    private void resumeExtValue(String key, Object data, Cell cll) {
        if (data == key) {
            cll.clearExtObject(key);
        } else {
            cll.setExtObject(key, data);
        }
    }

    @Override
    public String getPresentationName() {
        return "\u8bbe\u7f6e" + (this._dataType == Cell.FORMULA ? "\u516c\u5f0f" : (this._dataType == Cell.VALUE ? "\u6570\u503c" : "\u5355\u5143\u9644\u52a0\u5c5e\u6027")) + super.getPresentationName();
    }
}

