/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.cformat;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;

public class ConditionalFormat {
    private SortedCellBlockArray _blocks;
    private ShareStyleAttributes[] _ssas;
    private Condition[] _conditions;

    public ConditionalFormat() {
    }

    public ConditionalFormat(Condition[] conditions, ShareStyleAttributes[] sas, SortedCellBlockArray blocks) {
        this._conditions = conditions;
        this._blocks = blocks;
        this._ssas = sas;
    }

    public ConditionalFormat getClippedCopy(int left, int top, int right, int bottom) {
        ObjectArray blocks = new ObjectArray();
        for (int i = 0; i < this._blocks.size(); ++i) {
            CellBlock cb = this._blocks.getBlock(i).intersection(top, left, bottom, right);
            if (cb == null) continue;
            blocks.append(cb);
        }
        if (blocks.size() == 0) {
            return null;
        }
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < blocks.size(); ++i) {
            scba.insert(blocks.get(i));
        }
        return new ConditionalFormat(this._conditions, this._ssas, scba);
    }

    public SortedCellBlockArray getBlocks() {
        return this._blocks;
    }

    public void setBlocks(SortedCellBlockArray blocks) {
        this._blocks = blocks;
    }

    public Condition[] getConditions() {
        return this._conditions;
    }

    public void setConditions(Condition[] conditions) {
        this._conditions = conditions;
    }

    public int isMatched(Sheet sheet, Variant var) {
        for (int i = 0; i < this._conditions.length; ++i) {
            if (!this._conditions[i].isMatched(sheet, var)) continue;
            return i;
        }
        return -1;
    }

    public ShareStyleAttributes getShareStyleAttributes(int index) {
        if (index < 0 || this._ssas.length - 1 < index) {
            return Styles.getEmptySSA();
        }
        ShareStyleAttributes sa = this._ssas[index];
        return sa;
    }

    public ShareStyleAttributes[] getSSAs() {
        return this._ssas;
    }

    public void setSSAs(ShareStyleAttributes[] sas) {
        this._ssas = sas;
    }
}

