/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.collection;

import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SBTree;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSingleCellBlockArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CellBlockMap
extends SortedSpanArray {
    private static final long serialVersionUID = -2612331957056810453L;
    private SortedSingleCellBlockArray _singles = new SortedSingleCellBlockArray();

    public CellBlockMap() {
        super(1048575);
    }

    public Iterator iterator() {
        return new MyIterator();
    }

    public CellBlock searchBlock(CellBlock cbReferTo) {
        Object ret = null;
        if (cbReferTo.isSingleCell()) {
            int pos = this._singles.search(cbReferTo.getRow(), cbReferTo.getCol());
            if (pos >= 0) {
                ret = this._singles.get(pos);
            }
        } else {
            int pos = this.searchSpan(cbReferTo.getRow());
            if (pos >= 0) {
                Object refs = ((CellBlockShadowSpan)this.get(pos)).getRefs();
                if (refs instanceof CellBlockNode) {
                    CellBlockNode cb = (CellBlockNode)refs;
                    if (cb.equalsCol(cbReferTo) && cb.equalsRow(cbReferTo) && cb.getFlags() == ((CellBlockNode)cbReferTo).getFlags()) {
                        ret = cb;
                    }
                } else {
                    SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                    pos = array.search(cbReferTo);
                    if (pos >= 0) {
                        ret = array.get(pos);
                    }
                }
            }
        }
        return (CellBlock)ret;
    }

    public CellBlock insertBlock(CellBlock cbReferTo) {
        if (cbReferTo.isSingleCell()) {
            int pos = this._singles.search(cbReferTo);
            if (pos >= 0) {
                cbReferTo = (CellBlock)this._singles.get(pos);
            } else {
                this._singles.insert(pos, cbReferTo);
            }
        } else {
            CellBlock old = this.searchBlock(cbReferTo);
            if (old == null) {
                this.cover(cbReferTo);
            } else {
                cbReferTo = old;
            }
        }
        return cbReferTo;
    }

    private void cover(CellBlock block) {
        Span list = this.makeContinuousSpanList(block.getRowSpan());
        int end = list.getEnd();
        for (int i = list.getStart(); i <= end; ++i) {
            CellBlockShadowSpan span = (CellBlockShadowSpan)this.get(i);
            Object refs = span.getRefs();
            if (refs == null) {
                span.setRefs(block);
                continue;
            }
            if (refs instanceof SortedCellBlockCRArray) {
                ((SortedCellBlockCRArray)refs).insert(block);
                continue;
            }
            SortedCellBlockCRArray a = new SortedCellBlockCRArray();
            a.insert(refs);
            a.insert(block);
            span.setRefs(a);
        }
    }

    private boolean unCover(CellBlock block) {
        boolean emptyRemoved = false;
        int pos = this.searchSpan(block.getRow());
        int pos2 = this.searchSpan(block.getRow2());
        pos = pos < 0 ? -(pos + 1) : pos;
        int n = pos2 = pos2 < 0 ? -pos2 - 2 : pos2;
        while (pos2 >= pos) {
            Object refs = ((CellBlockShadowSpan)this.get(pos2)).getRefs();
            if (refs instanceof SortedCellBlockCRArray) {
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                array.remove(block);
                if (array.isEmpty()) {
                    this.removeByPos(pos2);
                    emptyRemoved = true;
                }
            } else {
                this.removeByPos(pos2);
                emptyRemoved = true;
            }
            --pos2;
        }
        return emptyRemoved;
    }

    private boolean unCover1(CellBlock block, int row1, int row2) {
        boolean emptyRemoved = false;
        int pos = this.searchSpan(row1);
        int pos2 = this.searchSpan(row2);
        pos = pos < 0 ? -(pos + 1) : pos;
        int n = pos2 = pos2 < 0 ? -pos2 - 2 : pos2;
        while (pos2 >= pos) {
            Object refs = ((CellBlockShadowSpan)this.get(pos2)).getRefs();
            if (refs instanceof SortedCellBlockCRArray) {
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                for (int i = array.size() - 1; i >= 0; --i) {
                    if (array.get(i) != block) continue;
                    array.removeByPos(i);
                    break;
                }
                if (array.isEmpty()) {
                    this.removeByPos(pos2);
                    emptyRemoved = true;
                }
            } else {
                this.removeByPos(pos2);
                emptyRemoved = true;
            }
            --pos2;
        }
        return emptyRemoved;
    }

    public CellBlock moveBlock(CellBlock cbReferTo, int dstRow, int dstCol) {
        int row = cbReferTo.getRow();
        int col = cbReferTo.getCol();
        if (row != dstRow || col != dstCol) {
            if ((cbReferTo = this.searchBlock(cbReferTo)) != null) {
                if (cbReferTo.isSingleCell()) {
                    this._singles.remove(cbReferTo);
                } else {
                    this.unCover(cbReferTo);
                }
                cbReferTo.offset(dstRow - row, dstCol - col);
                cbReferTo = this.insertBlock(cbReferTo);
            }
        } else {
            cbReferTo = null;
        }
        return cbReferTo;
    }

    public void removeBlock(CellBlock cb) {
        if ((cb = this.searchBlock(cb)) != null) {
            if (cb.isSingleCell()) {
                this._singles.remove(cb);
            } else {
                this.unCover(cb);
            }
        }
    }

    public ObjectArray removeBlocks(int row, int col) {
        if (this._singles.size() == 0 && this.size() == 0) {
            return null;
        }
        ObjectArray al = null;
        int pos = this._singles.search(row, col);
        while (pos >= 0) {
            if (al == null) {
                al = new ObjectArray();
            }
            al.append(this._singles.removeByPos(pos));
            pos = this._singles.search(row, col);
        }
        pos = this.searchSpan(row);
        if (pos >= 0) {
            Object refs = ((CellBlockShadowSpan)this.get(pos)).getRefs();
            if (refs instanceof CellBlock) {
                CellBlock cb = (CellBlock)refs;
                if (cb.containsCol(col)) {
                    if (al == null) {
                        al = new ObjectArray();
                    }
                    al.append(cb);
                    this.removeByPos(pos);
                }
            } else {
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                for (int i = array.searchLeft(col); i >= 0; --i) {
                    CellBlock cb = (CellBlock)array.get(i);
                    if (cb.getCol2() < col || cb.getCol() > col) continue;
                    if (al == null) {
                        al = new ObjectArray();
                    }
                    al.append(cb);
                    this.unCover(cb);
                }
            }
        }
        return al;
    }

    private boolean offsetBlock(Param p) {
        int t;
        int newrc2;
        int rc;
        CellBlock cb = p.cb;
        boolean bRow = p.bRow;
        boolean bInsert = p.bInsert;
        boolean keepDestroy = p.aDestroy != null;
        int max = p.max;
        int offset = p.offset;
        int row = p.row;
        int col = p.col;
        int row1 = cb.getRow();
        int row2 = cb.getRow2();
        Object cbClone = null;
        int n = rc = bRow ? cb.getRow2() : cb.getCol2();
        if (bInsert) {
            newrc2 = rc + offset;
            if (newrc2 > max) {
                newrc2 = max;
                if (keepDestroy) {
                    cbClone = cb.clone();
                }
            }
        } else {
            int t2;
            newrc2 = rc - offset;
            int n2 = t2 = bRow ? row : col;
            if (newrc2 < t2) {
                newrc2 = t2;
                if (keepDestroy) {
                    cbClone = cb.clone();
                }
            }
        }
        rc = bRow ? cb.getRow() : cb.getCol();
        int n3 = t = bRow ? row : col;
        if (t <= rc) {
            int newrc;
            if (bInsert) {
                newrc = rc + offset;
                if (newrc > max + 1) {
                    newrc = max + 1;
                    if (keepDestroy && cbClone == null) {
                        cbClone = cb.clone();
                    }
                }
            } else {
                newrc = rc - offset;
                if (newrc < t) {
                    newrc = t;
                    if (keepDestroy && cbClone == null) {
                        cbClone = cb.clone();
                    }
                }
            }
            if (bRow) {
                cb.setRow(newrc);
            } else {
                cb.setCol(newrc);
            }
        }
        if (bRow) {
            cb.setRow2(newrc2);
        } else {
            cb.setCol2(newrc2);
        }
        if (keepDestroy) {
            p.aDestroy.append(cb);
            p.aDestroy.append(cbClone);
        }
        p.aChanged.append(cb);
        return p.unCover ? this.unCover1(cb, row1, row2) : false;
    }

    public ObjectArray insdel(CellBlock block, boolean bInsert, boolean bRow, boolean bState, ObjectArray aChanged) {
        int size;
        int pos2;
        CellBlock cb;
        int col;
        ObjectArray aDestroy;
        ObjectArray objectArray = aDestroy = bState ? new ObjectArray() : null;
        if (aChanged == null) {
            aChanged = new ObjectArray();
        }
        Param p = new Param();
        p.aChanged = aChanged;
        p.aDestroy = aDestroy;
        p.bInsert = bInsert;
        p.bRow = bRow;
        p.max = bRow ? 1048575 : 65535;
        p.offset = bRow ? block.getHeight() : block.getWidth();
        p.row = block.getRow();
        p.col = col = block.getCol();
        int singleCount = 0;
        if (!this._singles.isEmpty()) {
            SortedSingleCellBlockArray array = this._singles;
            p.aOwner = array;
            int pos = array.search(block.getRow(), 0);
            if (pos < 0) {
                pos = -(pos + 1);
            }
            for (int i = array.size() - 1; i >= pos; --i) {
                cb = (CellBlock)array.get(i);
                if (!block.isImpact(cb, bRow)) continue;
                p.cb = cb;
                p.pos = i;
                this.offsetBlock(p);
            }
            singleCount = aChanged.size();
        }
        p.bSingle = false;
        p.unCover = true;
        int pos = this.getProperPos(block.getRow(), false);
        if (!bRow) {
            for (pos2 = this.getProperPos(block.getRow2(), true); pos2 >= pos; --pos2) {
                Object refs = ((CellBlockShadowSpan)this.get(pos2)).getRefs();
                if (refs instanceof CellBlock) {
                    cb = (CellBlock)refs;
                    if (!block.isImpact(cb, false)) continue;
                    p.cb = cb;
                    p.pos = pos2;
                    p.aOwner = this;
                    if (!this.offsetBlock(p)) continue;
                    pos2 = this._count;
                    continue;
                }
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                p.aOwner = array;
                if (array.isEmpty()) continue;
                int iEnd = Math.max(0, array.searchLeft(col));
                for (int i = array.size() - 1; i >= iEnd; --i) {
                    CellBlock cb2 = (CellBlock)array.get(i);
                    if (!block.isImpact(cb2, false)) continue;
                    p.cb = cb2;
                    p.pos = i;
                    if (!this.offsetBlock(p)) continue;
                    pos2 = this._count;
                }
            }
        } else {
            int col2 = block.getCol2();
            for (pos2 = this._count - 1; pos2 >= pos; --pos2) {
                Object refs = ((CellBlockShadowSpan)this.get(pos2)).getRefs();
                if (refs instanceof CellBlock) {
                    CellBlock cb3 = (CellBlock)refs;
                    if (!block.isImpact(cb3, true)) continue;
                    p.cb = cb3;
                    p.pos = pos2;
                    p.aOwner = this;
                    if (!this.offsetBlock(p)) continue;
                    pos2 = this._count;
                    continue;
                }
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                int i = array.searchLeft(col2);
                if (i < 0) continue;
                p.aOwner = array;
                int iEnd = Math.max(0, array.searchLeft(col));
                while (i >= iEnd) {
                    CellBlock cb4 = (CellBlock)array.get(i);
                    if (block.isImpact(cb4, true)) {
                        p.cb = cb4;
                        p.pos = i;
                        if (this.offsetBlock(p)) {
                            pos2 = this._count;
                        }
                    }
                    --i;
                }
            }
        }
        if ((size = aChanged.size()) > 0) {
            int i;
            for (i = singleCount - 1; i >= 0; --i) {
                CellBlockNode cb5 = (CellBlockNode)aChanged.get(i);
                if (cb5.isRowColInvalid() || cb5.isRowColReversed()) continue;
                this._singles.insert(cb5);
            }
            i = size - 1;
            if (i >= singleCount) {
                while (i >= singleCount) {
                    CellBlockNode cb6 = (CellBlockNode)aChanged.get(i);
                    if (!cb6.isRowColInvalid() && !cb6.isRowColReversed()) {
                        this.cover(cb6);
                    }
                    --i;
                }
                this.merge(null, true);
            }
        }
        return aDestroy;
    }

    public void resumeBlocks(ObjectArray[] blocks) {
        CellBlock cb;
        int i;
        if (blocks == null) {
            return;
        }
        ObjectArray acb = blocks[0];
        ObjectArray acbOld = blocks[1];
        for (i = 0; i < acb.size(); ++i) {
            cb = (CellBlock)acb.get(i);
            if (cb.isSingleCell()) {
                this._singles.remove(cb);
                continue;
            }
            this.unCover(cb);
        }
        this.merge(null, true);
        for (i = 0; i < acbOld.size(); ++i) {
            cb = (CellBlock)acb.get(i);
            cb.copyFrom((CellBlock)acbOld.get(i));
            this.insertBlock(cb);
        }
    }

    @Override
    public Span createDefaultSpan(Span span) {
        return new CellBlockShadowSpan(span);
    }

    class CellBlockShadowSpan
    extends Span
    implements Cloneable {
        private Object _refs;

        public CellBlockShadowSpan(int start, int end) {
            super(start, end);
        }

        public CellBlockShadowSpan(Span span) {
            super(span);
        }

        public Object getRefs() {
            return this._refs;
        }

        public void setRefs(Object refs) {
            this._refs = refs;
        }

        @Override
        public boolean isSameAttrs(Span span) {
            CellBlockShadowSpan cmp = (CellBlockShadowSpan)span;
            boolean same = this._refs instanceof CellBlock ? this._refs == cmp._refs : this._refs.equals(cmp);
            return same;
        }

        @Override
        public String toString() {
            return super.toString() + this._refs.toString();
        }
    }

    static class SortedCellBlockCRArray
    extends SortedObjectArray
    implements Comparator {
        private static final long serialVersionUID = 6599406627164704669L;

        public SortedCellBlockCRArray() {
            this.setComparator(this);
        }

        public int compare(Object o1, Object o2) {
            int cmp;
            int v2;
            if (o1 == o2) {
                return 0;
            }
            CellBlockNode cb = (CellBlockNode)o1;
            CellBlockNode cb2 = (CellBlockNode)o2;
            int v = cb.getCol();
            if ((v < (v2 = cb2.getCol()) ? -1 : (cmp = v == v2 ? 0 : 1)) == 0 && ((v = cb.getCol2()) < (v2 = cb2.getCol2()) ? -1 : (cmp = v == v2 ? 0 : 1)) == 0 && ((v = cb.getRow()) < (v2 = cb2.getRow()) ? -1 : (cmp = v == v2 ? 0 : 1)) == 0 && ((v = cb.getRow2()) < (v2 = cb2.getRow2()) ? -1 : (cmp = v == v2 ? 0 : 1)) == 0) {
                cmp = cb.getFlags() - cb2.getFlags();
            }
            return cmp;
        }

        public int searchLeft(int col) {
            int pos;
            block9: {
                if (this.isEmpty()) {
                    return -1;
                }
                pos = -1;
                int low = 0;
                int high = this._count - 1;
                while (low <= high) {
                    int cmp;
                    int mid = low + high >> 1;
                    Object midVal = this._array[mid];
                    int c = ((CellBlock)midVal).getCol();
                    int n = c < col ? -1 : (cmp = c > col ? 1 : 0);
                    if (cmp == 0) {
                        cmp = ((CellBlockNode)midVal).getFlags();
                    }
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    pos = mid;
                    break block9;
                }
                pos = -(low + 1);
            }
            if (pos < 0) {
                if ((pos = -(pos + 1)) == 0) {
                    pos = -1;
                } else if (pos >= this._count) {
                    pos = this._count - 1;
                }
            }
            return pos;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SortedCellBlockCRArray) {
                SortedCellBlockCRArray cmp = (SortedCellBlockCRArray)obj;
                if (this._count == cmp._count) {
                    for (int i = 0; i < this._count; ++i) {
                        if (this.get(i).equals(cmp.get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    static class SingleCellQTree
    extends SBTree
    implements Comparator {
        private CellBlock _tmp = CellBlock.getCellBlock(0, 0);

        public int compare(Object o1, Object o2) {
            int cmp;
            int v2;
            if (o1 == o2) {
                return 0;
            }
            CellBlock cb = (CellBlock)o1;
            CellBlock cb2 = (CellBlock)o2;
            int v = cb.getRow();
            if ((v < (v2 = cb2.getRow()) ? -1 : (cmp = v == v2 ? 0 : 1)) == 0) {
                v = cb.getCol();
                cmp = v < (v2 = cb2.getCol()) ? -1 : (v == v2 ? 0 : 1);
            }
            return cmp;
        }

        public Object searchCell(int row, int col) {
            this._tmp.setRowCol(row, col, row, col);
            Comparator cmp = this._cmp;
            this._cmp = this;
            Object obj = this.search(this._tmp);
            this._cmp = cmp;
            return obj;
        }

        public Iterator getToEndIterator(int row, int col) {
            this._tmp.setRowCol(row, col, row, col);
            return this.iterator(this._tmp, null, false);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator i = this.getToEndIterator(-1, -1);
            while (i.hasNext()) {
                sb.append(i.next());
                sb.append(',');
            }
            return sb.toString();
        }
    }

    class MyIterator
    implements Iterator {
        private boolean _inSingles;
        private int _pos;
        private int _spanPos;
        private Iterator _bi;

        MyIterator() {
            boolean bl = this._inSingles = !CellBlockMap.this._singles.isEmpty();
            if (!this._inSingles) {
                this._pos = CellBlockMap.this.isEmpty() ? -1 : 0;
            }
        }

        @Override
        public boolean hasNext() {
            return this._pos >= 0;
        }

        public Object next() {
            Object obj = null;
            if (this._inSingles) {
                obj = CellBlockMap.this._singles.get(this._pos++);
                if (this._pos >= CellBlockMap.this._singles.size()) {
                    this._inSingles = false;
                    this._pos = CellBlockMap.this.isEmpty() ? -1 : 0;
                }
            } else {
                if (this._bi == null) {
                    HashMap map = new HashMap(CellBlockMap.this._count << 1);
                    while (this.hasNext()) {
                        map.put(this.nextBlock(), null);
                    }
                    this._bi = map.entrySet().iterator();
                    this._spanPos = map.size();
                    this._pos = 0;
                }
                obj = ((Map.Entry)this._bi.next()).getKey();
                if (++this._pos >= this._spanPos) {
                    this._pos = -1;
                }
            }
            return obj;
        }

        private Object nextBlock() {
            Object obj;
            Object refs = ((CellBlockShadowSpan)CellBlockMap.this.get(this._spanPos)).getRefs();
            if (refs instanceof CellBlock) {
                obj = refs;
                ++this._spanPos;
                this._pos = 0;
                if (this._spanPos >= CellBlockMap.this.size()) {
                    this._pos = -1;
                }
            } else {
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                obj = array.get(this._pos++);
                if (this._pos >= array.size()) {
                    ++this._spanPos;
                    this._pos = 0;
                    if (this._spanPos >= CellBlockMap.this.size()) {
                        this._pos = -1;
                    }
                }
            }
            return obj;
        }

        @Override
        public void remove() {
        }
    }

    class Param {
        ObjectArray aOwner;
        ObjectArray aChanged;
        ObjectArray aDestroy;
        CellBlock cb;
        boolean bInsert;
        boolean bRow;
        boolean unCover;
        boolean bSingle;
        int max;
        int offset;
        int row;
        int col;
        int pos;

        Param() {
        }
    }
}

