/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.manager;

import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.bos.util.backport.concurrent.CountDownLatch;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.List;

public class DefaultChartReadyManager
implements IChartReadyFunction {
    private List<IChartReadyFunction> functions = new ArrayList<IChartReadyFunction>();
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void onReady(IExecutePanel browser) {
        for (IChartReadyFunction f : this.functions) {
            f.onReady(browser);
        }
        this.latch.countDown();
    }

    public boolean isDocumentReady() {
        return this.latch.getCount() == 0L;
    }

    public boolean waitDocumentIsReady() {
        try {
            this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        return this.isDocumentReady();
    }

    public void registeFunction(IChartReadyFunction f) {
        if (null != f) {
            this.functions.add(f);
        }
    }

    public void registeFunctionFirst(IChartReadyFunction f) {
        if (null != f) {
            this.functions.add(0, f);
        }
    }

    public void removeFunction(IChartReadyFunction f) {
        this.functions.remove(f);
    }
}

