/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.SeriesType;
import com.github.abel533.echarts.data.Data;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractAxisTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.List;

public class AbstractStackedTransfer<B extends AbstractFusionBean>
extends AbstractAxisTransfer<B> {
    private Data last = null;
    private int lastSeriesIndex = -1;
    private int lastDataIndexIndex = -1;

    public AbstractStackedTransfer(EChartsType type, String desc) {
        super(type, desc);
        this.setyValueAxis(true);
    }

    @Override
    protected void setBlowZeroDataRoundEdges(Data d, boolean x, int seriesIndex, int dataIndex) {
        super.setBlowZeroDataRoundEdges(d, x, seriesIndex, dataIndex);
        if (this.lastDataIndexIndex == dataIndex && seriesIndex > this.lastSeriesIndex && null != this.last) {
            this.last.itemStyle().normal().barBorderRadius(null);
        }
        this.last = d;
        this.lastSeriesIndex = seriesIndex;
        this.lastDataIndexIndex = dataIndex;
    }

    private void resetDataRoundEdges(List<Series> series, boolean x) {
        Object d;
        int i;
        int[] index = new int[series.get(0).getData().size()];
        for (i = series.size() - 1; i >= 0; --i) {
            List data = series.get(i).getData();
            for (int j = 0; j < data.size(); ++j) {
                d = data.get(j);
                if (d instanceof Data || index[j] != 0) continue;
                index[j] = i;
            }
        }
        for (i = 0; i < index.length; ++i) {
            int serialIndex = index[i];
            if (serialIndex == series.size() - 1) continue;
            List data = series.get(serialIndex).getData();
            d = data.get(i);
            Data sData = new Data();
            sData.setValue(d);
            if (this.isxValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
            } else if (this.isyValueAxis()) {
                sData.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
            }
            data.set(i, sData);
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        String[] chartCaptions;
        String s = super.afterScript(b, data, p);
        if ("1".equals(((AbstractFusionBean)b).getChart().useRoundEdges)) {
            this.resetDataRoundEdges(p.getSeries(), this.isxValueAxis());
        }
        if (null != (chartCaptions = this.getChartCaptions(data)) && chartCaptions.length > 8 && "1".equals(chartCaptions[8])) {
            double[][] d = (double[][])data.getData();
            String[] labels = data.getGroupKeys();
            double[] total = new double[labels.length];
            for (int n = 0; n <= d[0].length - 1; ++n) {
                double[] statistic = TransferUtils.getStatistic(d, n);
                total[n] = statistic[2];
            }
            Series se = (Series)p.getSeries().get(p.getSeries().size() - 1);
            for (int i = 0; i <= total.length - 1; ++i) {
                if (se.getType() != SeriesType.bar) continue;
                Bar bar = (Bar)se;
                bar.markPoint().symbolSize((Object)1);
                bar.markPoint().label().color("#000");
                bar.markPoint().itemStyle().position((Object)Position.outside);
                bar.markPoint().label().textStyle().fontSize(Integer.valueOf(12));
                TransferUtils.setTrendLineValue((AbstractData)bar.markPoint(), "{value:'%s', coord:[%s,%s]}", String.valueOf(total[i]), i + "", String.valueOf(total[i]));
            }
        }
        return s;
    }

    @Override
    protected void configureSeriesFillet(Option p, Chart chart) {
        Series s = (Series)p.getSeries().get(p.getSeries().size() - 1);
        if (s.getType() == SeriesType.bar && "1".equals(chart.useRoundEdges)) {
            if (this.isxValueAxis()) {
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{0, 10, 10, 0});
            } else if (this.isyValueAxis()) {
                s.itemStyle().normal().barBorderRadius((Object)new Integer[]{10, 10, 0, 0});
            }
        }
    }
}

