/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.gauge;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.data.PieData;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Gauge;
import com.github.abel533.echarts.style.TextStyle;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.angulargauge.AngularGaugeFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class GaugeBeanTransferImpl
extends AbstractSmoothTransfer<AngularGaugeFusionBean> {
    private int min;
    private int max;
    private double[][] data;
    private int splitNumber;

    public GaugeBeanTransferImpl() {
        super(EChartsType.GAUGE, "\u91cf\u8868");
        this.setSetPosition(true);
    }

    @Override
    public Option transfer2Opiton(AngularGaugeFusionBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = dataNode.getGroupKeys();
        if (null == labels || null == this.data) {
            return null;
        }
        Arrays.sort(this.data[0]);
        this.max = (int)Math.ceil(this.data[0][this.data[0].length - 1]);
        p.tooltip().setFormatter((Object)"{b} {c}");
        p.tooltip().trigger(Trigger.item);
        Chart chart = bean.getChart();
        String[] chartCaptions = super.getChartCaptions(dataNode);
        Gauge gauge = new Gauge();
        gauge.min(Integer.valueOf(this.min));
        gauge.max(Integer.valueOf(this.max));
        TextStyle ts = new TextStyle();
        ts.fontSize(Integer.valueOf(20));
        gauge.radius((Object)"85%");
        gauge.setStartAngle(Integer.valueOf(Integer.parseInt(chart.gaugeStartAngle)));
        gauge.setEndAngle(Integer.valueOf(Integer.parseInt(chart.gaugeEndAngle)));
        gauge.axisLabel().show(bean.getShowSeparatorTick().getBooleanValue());
        gauge.axisLabel().formatter((Object)JSUtils.getNumberFormatFunctionVar(true));
        int innerRadius = Integer.parseInt(chartCaptions[2]);
        gauge.axisLine().lineStyle().width(Integer.valueOf(100 - innerRadius));
        gauge.pointer().width((Object)Integer.parseInt(chart.pivotRadius));
        gauge.detail().setTextStyle(ts);
        gauge.detail().setFormatter("function(value) {return formatNumber(value, true);}");
        gauge.detail().offsetCenter((Object)new String[]{"0", "50%"});
        gauge.axisLine().lineStyle().color((Object)new Var("lineColors"));
        Variant[][] needleValues = (Variant[][])Array.get(dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_FORMULA), 0);
        Variant[][] needleNames = (Variant[][])Array.get(dataNode.getData(FusionChartDataNode.DASHBOARD_CHART_NEEDLE_GROUP_FORMULA), 0);
        ArrayList<PieData> list = new ArrayList<PieData>();
        gauge.splitLine().show(Boolean.valueOf("1".equals(chartCaptions[24])));
        if ("1".equals(chartCaptions[25])) {
            gauge.axisTick().show(Boolean.valueOf(true));
            gauge.axisTick().length(Integer.valueOf(15));
        } else {
            gauge.axisTick().show(Boolean.valueOf(false));
        }
        gauge.splitNumber(Integer.valueOf(this.splitNumber));
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < needleValues[i].length; ++j) {
                int length = i * this.data.length + j;
                String name = "";
                if (length <= needleNames[i].length - 1 && "1".equals(chartCaptions[22])) {
                    name = needleNames[i][length].getValue().toString();
                }
                PieData pieData = new PieData(name, needleValues[i][j].getValue());
                list.add(pieData);
            }
        }
        gauge.setData(list);
        p.series().add(gauge);
        return p;
    }

    @Override
    public String initMockScript(AngularGaugeFusionBean bean) {
        return super.initMockScript(bean) + TransferUtils.getResourceAsString(this.getClass(), "GaugeBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public String initScript(AngularGaugeFusionBean bean, FusionChartDataNode d) {
        this.data = (double[][])d.getData();
        String colorJS = "var lineColors=[[0.1, colors[0]],[0.2, colors[1 % colors.length]],[0.4, colors[2 % colors.length]],[0.6, colors[3 % colors.length]],[0.8, colors[4 % colors.length]],[1, colors[5 % colors.length]]];";
        if (null != this.data) {
            Arrays.sort(this.data[0]);
            this.max = (int)Math.ceil(this.data[0][this.data[0].length - 1]);
            this.splitNumber = this.data[0].length;
            if (this.splitNumber > 10) {
                this.splitNumber = 10;
            }
            int total = this.max - this.min;
            while (total % this.splitNumber != 0 && this.splitNumber < 10) {
                ++this.splitNumber;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("var lineColors=[");
            double f = 1.0 / (double)this.splitNumber;
            for (int i = 0; i < this.splitNumber; ++i) {
                builder.append(String.format("[%d * %f, colors[%d %% colors.length]]", i + 1, f, i));
                if (i >= this.splitNumber - 1) continue;
                builder.append(',');
            }
            builder.append("];");
            colorJS = builder.toString();
        }
        return super.initScript(bean, d) + colorJS;
    }

    @Override
    public Option mockOption(AngularGaugeFusionBean bean) {
        return null;
    }
}

