/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.node;

import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;

public class CellBlock3DNode
extends CellBlockNode
implements Cloneable {
    private Sheet _sheet2;

    public static CellBlock3DNode getCellBlock3DNode(WeakHashSet set, Sheet sheet, Sheet sheet2, int row, int col, int row2, int col2, int flags) {
        CellBlockNode cbn = CellBlockNode.getCellBlockNode(set, sheet, row, col, row2, col2, flags);
        return new CellBlock3DNode(sheet2, cbn);
    }

    private CellBlock3DNode(Sheet sheet2, CellBlockNode cbn) {
        super(cbn.getSheet(), cbn, cbn.getFlags());
        this._sheet2 = sheet2;
    }

    public Sheet getSheet2() {
        return this._sheet2;
    }

    public void setSheet2(Sheet sheet2) {
        this._sheet2 = sheet2;
    }

    public int getSheetCount() {
        return this._sheet2.getIndex() - this._sheet.getIndex() + 1;
    }

    public boolean containsSheet(Sheet sheet) {
        if (sheet == this._sheet || sheet == this._sheet2) {
            return true;
        }
        Book book = this._sheet.getBook();
        int iEnd = this._sheet2.getIndex() + 1;
        for (int i = this._sheet.getIndex(); i < iEnd; ++i) {
            if (book.getSheet(i) != sheet) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellBlock3DNode) {
            CellBlock3DNode cmp = (CellBlock3DNode)obj;
            return this._sheet2 == cmp._sheet2 && super.equals(cmp);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = -1;
        if (obj instanceof CellBlock3DNode) {
            CellBlock3DNode cb = (CellBlock3DNode)obj;
            cmp = cb._sheet.compareTo(cb._sheet);
            if (cmp == 0 && (cmp = cb._sheet2.compareTo(cb._sheet2)) == 0) {
                cmp = super.compareTo(cb);
            }
        }
        return cmp;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant var;
        if (this.isRowColReversed() || this.isRowColInvalid()) {
            var = new Variant(new SyntaxErrorException(262144L), 16);
        } else {
            Book book = this._sheet.getBook();
            book.setDependent(exprOwner, this);
            Dependents deps = book.getDeps();
            int pos2 = book.getSheetIndexByName(this._sheet2.getSheetName());
            for (int pos = book.getSheetIndexByName(this._sheet.getSheetName()); pos <= pos2; ++pos) {
                Sheet sheet = book.getSheet(pos);
                Sheet.ICellsIterator ci = sheet.getCellsIterator(this, false, true);
                while (ci.hasNext()) {
                    Cell referTo = ci.next();
                    deps.calcReferTo(exprOwner, referTo);
                }
            }
            var = new Variant(this, 18);
            if (ctx.isTraceMode()) {
                var = new TraceVariant(var, ctx);
            }
        }
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        if (this.isRowColReversed() || this.isRowColInvalid()) {
            return ExprErr.getString(262144L);
        }
        if (this._sheet == this._sheet2) {
            return super.decode(ctx, exprOwner);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\'');
        sb.append(this._sheet.getSheetName());
        sb.append(':');
        sb.append(this._sheet2.getSheetName());
        sb.append("'!");
        if (this._flags == 15) {
            sb.append(this.getBlockName(this._sheet.getDeps().isA1Style(), (Cell)null));
        } else if (exprOwner instanceof Cell) {
            sb.append(this.getBlockName(this._sheet.getDeps().isA1Style(), (Cell)exprOwner));
        } else {
            sb.append("#REF!");
        }
        return sb.toString();
    }
}

