/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.node;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;

public class CellBlockNode
extends CellBlock
implements IExprNode,
Cloneable,
IVarReferences {
    public static final int ABS_Row = 1;
    public static final int ABS_Col = 2;
    public static final int ABS_Row2 = 4;
    public static final int ABS_Col2 = 8;
    public static final int ABS_All = 15;
    protected Sheet _sheet;
    protected int _flags;
    private Object _refs;
    protected Variant _varThis;

    public static CellBlockNode getCellBlockNode(Sheet sheet, CellBlock cb, int flags) {
        return CellBlockNode.getCellBlockNode(sheet, cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2(), flags);
    }

    public static CellBlockNode getCellBlockNode(Sheet sheet, int row, int col, int row2, int col2, int flags) {
        return new CellBlockNode(sheet, row, col, row2, col2, flags);
    }

    public static CellBlockNode getCellBlockNode(WeakHashSet buffer, Sheet sheet, int row, int col, int row2, int col2, int flags) {
        CellBlockNode cbn = CellBlockNode.getCellBlockNode(sheet, row, col, row2, col2, flags);
        return CellBlockNode.getCellBlockNode(buffer, cbn);
    }

    public static CellBlockNode getCellBlockNode(WeakHashSet buffer, CellBlockNode cbn) {
        return buffer == null ? cbn : (CellBlockNode)buffer.add(cbn);
    }

    public static int getAbsFlags(boolean absRow, boolean absCol, boolean absRow2, boolean absCol2) {
        int flags = 0;
        if (absRow) {
            flags |= 1;
        }
        if (absCol) {
            flags |= 2;
        }
        if (absRow2) {
            flags |= 4;
        }
        if (absCol2) {
            flags |= 8;
        }
        return flags;
    }

    protected CellBlockNode(Sheet sheet, int row, int col, int row2, int col2, int flags) {
        super(row, col, row2, col2);
        this._sheet = sheet;
        this._flags = flags;
    }

    protected CellBlockNode(Sheet sheet, CellBlock cb, int flags) {
        super(cb);
        this._sheet = sheet;
        this._flags = flags;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public boolean isAbsolute() {
        return (this._flags & 0xF) == 15;
    }

    public boolean isABS() {
        return (this._flags & 1) == 1 || (this._flags & 2) == 2;
    }

    @Override
    public void offset(int offsetY, int offsetX) {
        if (this._flags == 15) {
            return;
        }
        if (offsetY != 0) {
            if (!this.touchFlag(1)) {
                this.setRow(this._row + offsetY);
            }
            if (!this.touchFlag(4)) {
                this.setRow2(this._row2 + offsetY);
            }
        }
        if (offsetX != 0) {
            if (!this.touchFlag(2)) {
                this.setCol(this._col + offsetX);
            }
            if (!this.touchFlag(8)) {
                this.setCol2(this._col2 + offsetX);
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._flags;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellBlockNode) {
            CellBlockNode cmp = (CellBlockNode)obj;
            return this._sheet == cmp._sheet && this._flags == cmp._flags && super.equals(cmp);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        int cmp = super.compareTo(obj);
        if (cmp == 0) {
            if (obj instanceof CellBlockNode) {
                CellBlockNode node = (CellBlockNode)obj;
                cmp = this._flags > node._flags ? 1 : (this._flags == node._flags ? 0 : -1);
            } else {
                cmp = -1;
            }
        }
        return cmp;
    }

    @Override
    public int getExprType() {
        return 4;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        this._action(ctx, exprOwner, this);
    }

    protected void _action(ExprContext ctx, ICalculable exprOwner, CellBlockNode cb) throws SyntaxErrorException {
        cb = this._sheet.setDependent(exprOwner, cb);
        boolean queueLast = false;
        Dependents deps = this._sheet.getDeps();
        if (cb.isSingleCell()) {
            Cell referTo = this._sheet.getCell(this._row, this._col, false);
            if (referTo != null && !(queueLast = referTo.isQueueLast())) {
                deps.calcReferTo(exprOwner, referTo);
                queueLast = referTo.isQueueLast();
            }
        } else {
            Sheet.ICellsIterator ci = this._sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                Cell referTo = ci.next();
                if (!referTo.isQueueLast()) {
                    deps.calcReferTo(exprOwner, referTo);
                }
                queueLast |= referTo.isQueueLast();
            }
        }
        if (queueLast) {
            throw SyntaxErrorException.CALC_LAST;
        }
        Variant var = cb.getVarThis();
        if (ctx.isTraceMode()) {
            var = new TraceVariant(var, ctx);
        }
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        if (this.isRowColReversed()) {
            return ExprErr.getString(262144L);
        }
        return this.getFullBlockName(null, exprOwner);
    }

    public String getFullBlockName(StringBuffer sb, ICalculable exprOwner) {
        if (sb == null) {
            sb = new StringBuffer();
        } else {
            sb.setLength(0);
        }
        if (this._sheet.isDisposed()) {
            sb.append("'#REF'!");
        } else if (this._sheet != exprOwner.getSheet() || exprOwner instanceof NamedObjectNode) {
            sb.append(this._sheet.getSyntaxName());
            sb.append('!');
        }
        this.getBlockName(sb, exprOwner);
        return sb.toString();
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    @Override
    public String toString() {
        return this.getBlockName(true, (Cell)null);
    }

    public Sheet.ICellsIterator getCellsIterator(boolean bDescend, boolean forContentCell) {
        return this._sheet.getCellsIterator(this, bDescend, forContentCell);
    }

    public Cell getFirstCell(boolean bCreate) {
        return this._sheet.getCell(this._row, this._col, bCreate);
    }

    public Object getRefs() {
        return this._refs;
    }

    public void setRefs(Object refs) {
        this._refs = refs;
    }

    public void addRefs(Object refer) {
        if (this._refs == null) {
            this._refs = refer;
        } else if (this._refs instanceof SortedObjectArray) {
            ((SortedObjectArray)this._refs).insert(refer);
        } else if (refer != this._refs) {
            SortedObjectArray newList = new SortedObjectArray();
            newList.insert(this._refs);
            newList.insert(refer);
            this._refs = newList;
        }
    }

    public void addAllRefs(Object refs) {
        if (refs instanceof SortedObjectArray) {
            SortedObjectArray array = (SortedObjectArray)refs;
            int iEnd = array.size();
            for (int i = 0; i < iEnd; ++i) {
                this.addRefs(array.get(i));
            }
        } else {
            this.addRefs(refs);
        }
    }

    public void getBlockName(StringBuffer sb, ICalculable exprOwner) {
        boolean bA1Style = this._sheet.getDeps().isA1Style();
        if ((this._flags & 0xF) == 15) {
            sb.append(this.getBlockName(bA1Style, (Cell)null));
        } else if (exprOwner instanceof Cell) {
            sb.append(this.getBlockName(bA1Style, (Cell)exprOwner));
        } else if (exprOwner instanceof CellBlock) {
            sb.append(this.getBlockName(bA1Style, (CellBlock)((Object)exprOwner)));
        } else {
            sb.append(this.getBlockName(bA1Style, (Cell)null));
        }
    }

    public String getBlockName(boolean bA1Style, CellBlock block) {
        int baseRow = block == null ? 0 : block.getRow();
        int baseCol = block == null ? 0 : block.getCol();
        return this.getBlockName(bA1Style, baseRow, baseCol);
    }

    public String getBlockName(boolean bA1Style, Cell cll) {
        int baseRow = cll == null ? 0 : cll.getRow();
        int baseCol = cll == null ? 0 : cll.getCol();
        return this.getBlockName(bA1Style, baseRow, baseCol);
    }

    public static String getBlockName(StringBuffer sb, CellBlock cb) {
        boolean isAll;
        if (sb == null) {
            sb = new StringBuffer();
        }
        boolean isRow = cb.isRow();
        boolean isCol = cb.isCol();
        boolean bl = isAll = isRow && isCol;
        if (!isRow) {
            sb.append(SheetBaseMath.getColumnName(cb.getCol(), 0, true, false));
        }
        if (!isCol || isAll) {
            sb.append(SheetBaseMath.getRowName(cb.getRow(), 0, true, false));
        }
        if (!cb.isSingleCell()) {
            sb.append(':');
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(cb.getCol2(), 0, true, false));
            }
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(cb.getRow2(), 0, true, false));
            }
        }
        return sb.toString();
    }

    public String getBlockName(boolean bA1Style, int baseRow, int baseCol) {
        boolean isAll;
        StringBuffer sb = new StringBuffer();
        boolean isRow = this.isRow();
        boolean isCol = this.isCol();
        boolean bl = isAll = isRow && isCol;
        if (bA1Style) {
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(this._col, 0, true, this.touchFlag(2)));
            }
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(this._row, 0, true, this.touchFlag(1)));
            }
            if (!this.isSingleCell()) {
                sb.append(':');
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(this._col2, 0, true, this.touchFlag(8)));
                }
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(this._row2, 0, true, this.touchFlag(4)));
                }
            }
        } else {
            if (!isCol || isAll) {
                sb.append(SheetBaseMath.getRowName(this._row, baseRow, false, this.touchFlag(1)));
            }
            if (!isRow) {
                sb.append(SheetBaseMath.getColumnName(this._col, baseCol, false, this.touchFlag(2)));
            }
            if (!this.isSingleCell()) {
                sb.append(':');
                if (!isCol || isAll) {
                    sb.append(SheetBaseMath.getRowName(this._row2, baseRow, false, this.touchFlag(4)));
                }
                if (!isRow) {
                    sb.append(SheetBaseMath.getColumnName(this._col2, baseCol, false, this.touchFlag(8)));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        CellBlockNode cb = (CellBlockNode)super.clone();
        cb._varThis = null;
        return cb;
    }

    public Variant getVarThis() {
        if (this._varThis == null) {
            this._varThis = new Variant(this, 18);
        }
        return this._varThis;
    }

    @Override
    public Variant getActualValue() {
        Cell referTo;
        Variant var = this.isRowColReversed() || this.isRowColInvalid() || this._sheet.isDisposed() ? new Variant(new SyntaxErrorException(262144L), 16) : (this.isSingleCell() ? ((referTo = this._sheet.getCell(this._row, this._col, false)) == null ? Variant.nullVariant : referTo.getValue()) : this.getVarThis());
        return var;
    }

    public void queue() {
        if (this._refs == null) {
            return;
        }
        boolean queueRefer = this._sheet.getBook().isAutoCalculate();
        Dependents deps = this._sheet.getDeps();
        if (this._refs instanceof ICalculable) {
            ICalculable node = (ICalculable)this._refs;
            if (!node.isQueued()) {
                node.setNeedRecalc(true);
                deps.queue(node, queueRefer);
            }
        } else {
            SortedObjectArray sa = (SortedObjectArray)this._refs;
            int count = sa.size();
            for (int i = 0; i < count; ++i) {
                ICalculable node = (ICalculable)sa.get(i);
                if (node.isQueued()) continue;
                node.setNeedRecalc(true);
                deps.queue(node, queueRefer);
            }
        }
    }
}

