/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.general;

import com.kingdee.bos.ctrl.freechart.data.TreeDatasetNode;
import com.kingdee.bos.ctrl.freechart.data.general.AbstractDataset;
import com.kingdee.bos.ctrl.freechart.data.general.TreeDataset;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class DefaultTreeDataset
extends AbstractDataset
implements TreeDataset {
    protected TreeDatasetNode root;
    private int maxDataLength = 1;

    public DefaultTreeDataset(TreeDatasetNode root) {
        if (root == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        this.root = root;
    }

    public void setRoot(TreeDatasetNode root) {
        if (root == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        TreeDatasetNode oldRoot = this.root;
        this.root = root;
        if (this.root != oldRoot) {
            this.fireDatasetChanged();
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == null || !(parent instanceof TreeDatasetNode)) {
            return null;
        }
        return ((TreeDatasetNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null || !(parent instanceof TreeDatasetNode)) {
            return 0;
        }
        return ((TreeDatasetNode)parent).getChildCount();
    }

    public void insertNodeInto(TreeDatasetNode newChild, TreeDatasetNode parent, int index) {
        parent.insert(newChild, index);
        this.fireDatasetChanged();
    }

    public void removeNodeFromParent(TreeDatasetNode node) {
        TreeDatasetNode parent = (TreeDatasetNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[]{parent.getIndex(node)};
        parent.remove(childIndex[0]);
        this.fireDatasetChanged();
    }

    public int getMaxDataLength() {
        if (this.maxDataLength != 1) {
            return this.maxDataLength;
        }
        Enumeration<TreeNode> children = this.root.children();
        while (children.hasMoreElements()) {
            TreeDatasetNode node = (TreeDatasetNode)children.nextElement();
            this.maxDataLength = Math.max(this.maxDataLength, node.getData().length);
        }
        return this.maxDataLength;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.root != null && this.root instanceof Serializable) {
            values.addElement("root");
            values.addElement(this.root);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("root")) {
            this.root = (TreeDatasetNode)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }
}

