/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.xy;

import com.kingdee.bos.ctrl.freechart.data.xy.AbstractIntervalXYDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.IntervalXYDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.YIntervalSeries;
import com.kingdee.bos.ctrl.freechart.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class YIntervalSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Serializable {
    private List data = new ArrayList();

    public void addSeries(YIntervalSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public YIntervalSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (YIntervalSeries)this.data.get(series);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    @Override
    public Number getX(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return s.getX(item);
    }

    @Override
    public double getYValue(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return s.getYValue(item);
    }

    @Override
    public double getStartYValue(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return s.getYLowValue(item);
    }

    @Override
    public double getEndYValue(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return s.getYHighValue(item);
    }

    @Override
    public Number getY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return new Double(s.getYValue(item));
    }

    @Override
    public Number getStartX(int series, int item) {
        return this.getX(series, item);
    }

    @Override
    public Number getEndX(int series, int item) {
        return this.getX(series, item);
    }

    @Override
    public Number getStartY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return new Double(s.getYLowValue(item));
    }

    @Override
    public Number getEndY(int series, int item) {
        YIntervalSeries s = (YIntervalSeries)this.data.get(series);
        return new Double(s.getYHighValue(item));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof YIntervalSeriesCollection)) {
            return false;
        }
        YIntervalSeriesCollection that = (YIntervalSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        YIntervalSeriesCollection clone = (YIntervalSeriesCollection)super.clone();
        clone.data = (List)ObjectUtilities.deepClone(this.data);
        return clone;
    }
}

