/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.TokenFilter;
import com.kingdee.bos.ctrl.lucene.analysis.TokenStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class CachingTokenFilter
extends TokenFilter {
    private List cache;
    private int index;

    public CachingTokenFilter(TokenStream input) {
        super(input);
    }

    @Override
    public Token next() throws IOException {
        if (this.cache == null) {
            this.cache = new LinkedList();
            this.fillCache();
        }
        if (this.index == this.cache.size()) {
            return null;
        }
        return (Token)this.cache.get(this.index++);
    }

    @Override
    public void reset() throws IOException {
        this.index = 0;
    }

    private void fillCache() throws IOException {
        Token token;
        while ((token = this.input.next()) != null) {
            this.cache.add(token);
        }
    }
}

