/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;

public class CachingWrapperFilter
extends Filter {
    protected Filter filter;
    protected transient Map cache;

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Map map = this.cache;
        synchronized (map) {
            BitSet cached = (BitSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        BitSet bits = this.filter.bits(reader);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

