/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Hits;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Searchable;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocs;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;

public abstract class Searcher
implements Searchable {
    private Similarity similarity = Similarity.getDefault();

    public final Hits search(Query query) throws IOException {
        return this.search(query, (Filter)null);
    }

    public Hits search(Query query, Filter filter) throws IOException {
        return new Hits(this, query, filter);
    }

    public Hits search(Query query, Sort sort) throws IOException {
        return new Hits(this, query, null, sort);
    }

    public Hits search(Query query, Filter filter, Sort sort) throws IOException {
        return new Hits(this, query, filter, sort);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.search(this.createWeight(query), filter, n, sort);
    }

    public void search(Query query, HitCollector results) throws IOException {
        this.search(query, (Filter)null, results);
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        this.search(this.createWeight(query), filter, results);
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.search(this.createWeight(query), filter, n);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.explain(this.createWeight(query), doc);
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    protected Weight createWeight(Query query) throws IOException {
        return query.weight(this);
    }

    @Override
    public int[] docFreqs(Term[] terms) throws IOException {
        int[] result = new int[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            result[i] = this.docFreq(terms[i]);
        }
        return result;
    }

    @Override
    public abstract void search(Weight var1, Filter var2, HitCollector var3) throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract int docFreq(Term var1) throws IOException;

    @Override
    public abstract int maxDoc() throws IOException;

    @Override
    public abstract TopDocs search(Weight var1, Filter var2, int var3) throws IOException;

    @Override
    public abstract Document doc(int var1) throws CorruptIndexException, IOException;

    @Override
    public abstract Query rewrite(Query var1) throws IOException;

    @Override
    public abstract Explanation explain(Weight var1, int var2) throws IOException;

    @Override
    public abstract TopFieldDocs search(Weight var1, Filter var2, int var3, Sort var4) throws IOException;
}

