/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DatabaseRecordIterator;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;

public class DatabaseJournal
extends AbstractJournal {
    private static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    private static final String DEFAULT_DDL_NAME = "default.ddl";
    private static final String DEFAULT_JOURNAL_TABLE = "JOURNAL";
    private static final long DEFAULT_RECONNECT_DELAY_MS = 10000L;
    private static Logger log = CommonSLF4JLogger.getLogger(DatabaseJournal.class);
    private String driver;
    private String url;
    private String schema;
    private String user;
    private String password;
    private long reconnectDelayMs;
    private Connection connection;
    private PreparedStatement selectRevisionsStmt;
    private PreparedStatement updateGlobalStmt;
    private PreparedStatement selectGlobalStmt;
    private PreparedStatement insertRevisionStmt;
    private int lockLevel;
    private long lockedRevision;
    private long reconnectTimeMs;
    protected String selectRevisionsStmtSQL;
    protected String updateGlobalStmtSQL;
    protected String selectGlobalStmtSQL;
    protected String insertRevisionStmtSQL;
    protected String schemaObjectPrefix;

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        if (this.schemaObjectPrefix == null) {
            this.schemaObjectPrefix = "";
        }
        if (this.reconnectDelayMs == 0L) {
            this.reconnectDelayMs = 10000L;
        }
        this.init();
        try {
            this.connection = this.getConnection();
            DatabaseJournal.setAutoCommit(this.connection, true);
            this.checkSchema();
            this.buildSQLStatements();
            this.prepareStatements();
        }
        catch (Exception e) {
            String msg = "Unable to create connection.";
            throw new JournalException(msg, e);
        }
        log.info("DatabaseJournal initialized.");
    }

    protected void init() throws JournalException {
        if (this.driver == null) {
            String msg = "Driver not specified.";
            throw new JournalException(msg);
        }
        if (this.url == null) {
            String msg = "Connection URL not specified.";
            throw new JournalException(msg);
        }
        if (this.schema == null) {
            try {
                this.schema = DatabaseJournal.getSchemaFromURL(this.url);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to derive schema from URL: " + e.getMessage();
                throw new JournalException(msg);
            }
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to load JDBC driver class.";
            throw new JournalException(msg, e);
        }
    }

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    private static String getSchemaFromURL(String url) throws IllegalArgumentException {
        int end;
        int start = url.indexOf(58);
        if (start != -1 && (end = url.indexOf(58, start + 1)) != -1) {
            return url.substring(start + 1, end);
        }
        throw new IllegalArgumentException(url);
    }

    @Override
    protected RecordIterator getRecords(long startRevision) throws JournalException {
        try {
            this.checkConnection();
            this.selectRevisionsStmt.clearParameters();
            this.selectRevisionsStmt.clearWarnings();
            this.selectRevisionsStmt.setLong(1, startRevision);
            this.selectRevisionsStmt.execute();
            return new DatabaseRecordIterator(this.selectRevisionsStmt.getResultSet(), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to return record iterater.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    protected void doLock() throws JournalException {
        ResultSet rs = null;
        boolean succeeded = false;
        try {
            this.checkConnection();
            if (this.lockLevel++ == 0) {
                DatabaseJournal.setAutoCommit(this.connection, false);
            }
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to set autocommit to false.";
            throw new JournalException(msg, e);
        }
        try {
            this.updateGlobalStmt.clearParameters();
            this.updateGlobalStmt.clearWarnings();
            this.updateGlobalStmt.execute();
            this.selectGlobalStmt.clearParameters();
            this.selectGlobalStmt.clearWarnings();
            this.selectGlobalStmt.execute();
            rs = this.selectGlobalStmt.getResultSet();
            if (!rs.next()) {
                throw new JournalException("No revision available.");
            }
            this.lockedRevision = rs.getLong(1);
            succeeded = true;
        }
        catch (SQLException e) {
            try {
                this.close(true);
                String msg = "Unable to lock global revision table.";
                throw new JournalException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseJournal.close(rs);
                if (!succeeded) {
                    this.doUnlock(false);
                }
                throw throwable;
            }
        }
        DatabaseJournal.close(rs);
        if (!succeeded) {
            this.doUnlock(false);
        }
    }

    @Override
    protected void doUnlock(boolean successful) {
        if (--this.lockLevel == 0) {
            if (successful) {
                DatabaseJournal.commit(this.connection);
            } else {
                DatabaseJournal.rollback(this.connection);
            }
            DatabaseJournal.setAutoCommit(this.connection, true);
        }
    }

    @Override
    protected void appending(AppendRecord record) {
        record.setRevision(this.lockedRevision);
    }

    @Override
    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            this.checkConnection();
            this.insertRevisionStmt.clearParameters();
            this.insertRevisionStmt.clearWarnings();
            this.insertRevisionStmt.setLong(1, record.getRevision());
            this.insertRevisionStmt.setString(2, this.getId());
            this.insertRevisionStmt.setString(3, record.getProducerId());
            this.insertRevisionStmt.setBinaryStream(4, in, length);
            this.insertRevisionStmt.execute();
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to append revision " + this.lockedRevision + ".";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    private void close(boolean failure) {
        if (failure) {
            this.reconnectTimeMs = System.currentTimeMillis() + this.reconnectDelayMs;
        }
        DatabaseJournal.close(this.selectRevisionsStmt);
        this.selectRevisionsStmt = null;
        DatabaseJournal.close(this.updateGlobalStmt);
        this.updateGlobalStmt = null;
        DatabaseJournal.close(this.selectGlobalStmt);
        this.selectGlobalStmt = null;
        DatabaseJournal.close(this.insertRevisionStmt);
        this.insertRevisionStmt = null;
        DatabaseJournal.close(this.connection);
        this.connection = null;
    }

    private static void setAutoCommit(Connection connection, boolean autoCommit) {
        if (connection != null) {
            try {
                if (connection.getAutoCommit() != autoCommit) {
                    connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                String msg = "Unable to set autocommit flag to " + autoCommit;
                log.warn(msg, (Throwable)e);
            }
        }
    }

    private static void commit(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                String msg = "Error while committing connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void rollback(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                String msg = "Error while rolling back connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                String msg = "Error while closing input stream: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing statement: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing result set: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private void checkConnection() throws SQLException {
        if (this.connection == null) {
            long delayMs = this.reconnectTimeMs - System.currentTimeMillis();
            if (delayMs > 0L) {
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.connection = this.getConnection();
            this.prepareStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchema() throws Exception {
        if (!this.schemaExists(this.connection.getMetaData())) {
            InputStream in = DatabaseJournal.class.getResourceAsStream(this.schema + ".ddl");
            if (in == null) {
                String msg = "No schema-specific DDL found: '" + this.schema + ".ddl', falling back to '" + DEFAULT_DDL_NAME + "'.";
                log.info(msg);
                in = DatabaseJournal.class.getResourceAsStream(DEFAULT_DDL_NAME);
                if (in == null) {
                    msg = "Unable to load 'default.ddl'.";
                    throw new JournalException(msg);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.connection.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = this.createSchemaSQL(sql);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                DatabaseJournal.close(in);
                DatabaseJournal.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean schemaExists(DatabaseMetaData metaData) throws SQLException {
        String tableName = this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE;
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        try (ResultSet rs = metaData.getTables(null, null, tableName, null);){
            boolean bl = rs.next();
            return bl;
        }
    }

    protected String createSchemaSQL(String sql) {
        return Text.replace(sql, SCHEMA_OBJECT_PREFIX_VARIABLE, this.schemaObjectPrefix);
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID > ?";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION set revision_id = revision_id + 1";
        this.selectGlobalStmtSQL = "select revision_id from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "JOURNAL(REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) values (?,?,?,?)";
    }

    private void prepareStatements() throws SQLException {
        this.selectRevisionsStmt = this.connection.prepareStatement(this.selectRevisionsStmtSQL);
        this.updateGlobalStmt = this.connection.prepareStatement(this.updateGlobalStmtSQL);
        this.selectGlobalStmt = this.connection.prepareStatement(this.selectGlobalStmtSQL);
        this.insertRevisionStmt = this.connection.prepareStatement(this.insertRevisionStmtSQL);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public long getReconnectDelayMs() {
        return this.reconnectDelayMs;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReconnectDelayMs(long reconnectDelayMs) {
        this.reconnectDelayMs = reconnectDelayMs;
    }
}

