/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.collections.list.TypedList;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionTemplateImpl;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionTemplateImpl;
import org.apache.jackrabbit.core.nodetype.jsr283.NodeDefinitionTemplate;
import org.apache.jackrabbit.core.nodetype.jsr283.NodeTypeDefinition;
import org.apache.jackrabbit.core.nodetype.jsr283.NodeTypeTemplate;
import org.apache.jackrabbit.core.nodetype.jsr283.PropertyDefinitionTemplate;

public class NodeTypeTemplateImpl
implements NodeTypeTemplate {
    private String name;
    private String[] superTypeNames;
    private String primaryItemName;
    private boolean abstractStatus;
    private boolean mixin;
    private boolean orderableChildNodes;
    private List nodeDefinitionTemplates;
    private List propertyDefinitionTemplates;

    NodeTypeTemplateImpl() {
        this.nodeDefinitionTemplates = TypedList.decorate(new ArrayList(), NodeDefinitionTemplate.class);
        this.propertyDefinitionTemplates = TypedList.decorate(new ArrayList(), PropertyDefinitionTemplate.class);
    }

    NodeTypeTemplateImpl(NodeTypeDefinition def) {
        this.name = def.getName();
        this.superTypeNames = def.getDeclaredSupertypeNames();
        this.primaryItemName = def.getPrimaryItemName();
        this.abstractStatus = def.isAbstract();
        this.mixin = def.isMixin();
        this.orderableChildNodes = def.hasOrderableChildNodes();
        NodeDefinition[] nodeDefs = def.getDeclaredChildNodeDefinitions();
        for (int i = 0; i < nodeDefs.length; ++i) {
            this.nodeDefinitionTemplates.add(new NodeDefinitionTemplateImpl(nodeDefs[i]));
        }
        PropertyDefinition[] propDefs = def.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            this.propertyDefinitionTemplates.add(new PropertyDefinitionTemplateImpl(propDefs[i]));
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDeclaredSuperTypeNames(String[] names) {
        this.superTypeNames = names;
    }

    @Override
    public void setAbstract(boolean abstractStatus) {
        this.abstractStatus = abstractStatus;
    }

    @Override
    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    @Override
    public void setOrderableChildNodes(boolean orderable) {
        this.orderableChildNodes = orderable;
    }

    @Override
    public void setPrimaryItemName(String name) {
        this.primaryItemName = name;
    }

    @Override
    public List getPropertyDefinitionTemplates() {
        return this.propertyDefinitionTemplates;
    }

    @Override
    public List getNodeDefinitionTemplates() {
        return this.nodeDefinitionTemplates;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getDeclaredSupertypeNames() {
        return this.superTypeNames;
    }

    @Override
    public boolean isAbstract() {
        return this.abstractStatus;
    }

    @Override
    public boolean isMixin() {
        return this.mixin;
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    @Override
    public String getPrimaryItemName() {
        return this.primaryItemName;
    }

    @Override
    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.propertyDefinitionTemplates.toArray(new PropertyDefinition[this.propertyDefinitionTemplates.size()]);
    }

    @Override
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.nodeDefinitionTemplates.toArray(new NodeDefinition[this.nodeDefinitionTemplates.size()]);
    }
}

