/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.IOException;
import java.io.InputStream;

public class TrackingInputStream
extends InputStream {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/TrackingInputStream.java $ $Rev: 604861 $ $Date: 2007-12-17 15:04:19 +0200 (Mon, 17 Dec 2007) $";
    private final InputStream in;
    private long position;
    private long markPos;

    public TrackingInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.position = this.markPos;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markPos = this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        long read = this.in.skip(n);
        if (read > 0L) {
            this.position += read;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read >= 0) {
            ++this.position;
        }
        return read;
    }

    public long getPosition() {
        return this.position;
    }
}

