/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.db;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.AbstractPersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;

public abstract class DatabasePersistenceManager
extends AbstractPersistenceManager {
    private static Logger log = CommonSLF4JLogger.getLogger(DatabasePersistenceManager.class);
    protected static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    protected boolean initialized = false;
    protected String schema = "default";
    protected String schemaObjectPrefix = "";
    protected boolean externalBLOBs = true;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected Connection con;
    protected boolean autoReconnect = true;
    protected static final int SLEEP_BEFORE_RECONNECT = 10000;
    protected String nodeStateInsertSQL;
    protected String nodeStateUpdateSQL;
    protected String nodeStateSelectSQL;
    protected String nodeStateSelectExistSQL;
    protected String nodeStateDeleteSQL;
    protected String propertyStateInsertSQL;
    protected String propertyStateUpdateSQL;
    protected String propertyStateSelectSQL;
    protected String propertyStateSelectExistSQL;
    protected String propertyStateDeleteSQL;
    protected String nodeReferenceInsertSQL;
    protected String nodeReferenceUpdateSQL;
    protected String nodeReferenceSelectSQL;
    protected String nodeReferenceSelectExistSQL;
    protected String nodeReferenceDeleteSQL;
    protected String blobInsertSQL;
    protected String blobUpdateSQL;
    protected String blobSelectSQL;
    protected String blobSelectExistSQL;
    protected String blobDeleteSQL;
    protected FileSystem blobFS;
    protected BLOBStore blobStore;

    protected Connection getMyConnection() throws ItemStateException {
        throw new ItemStateException("Unimplement method getMyConnection!");
    }

    protected void closeMyConnection(Connection connection) {
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        this.externalBLOBs = externalBLOBs;
    }

    public void setExternalBLOBs(String externalBLOBs) {
        this.externalBLOBs = Boolean.valueOf(externalBLOBs);
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        Connection connection = this.getMyConnection();
        DatabaseMetaData meta = connection.getMetaData();
        try {
            log.info("Database: " + meta.getDatabaseProductName() + " / " + meta.getDatabaseProductVersion());
            log.info("Driver: " + meta.getDriverName() + " / " + meta.getDriverVersion());
        }
        catch (SQLException e) {
            log.warn("Can not retrieve database and driver name / version", (Throwable)e);
        }
        this.prepareSchemaObjectPrefix(connection);
        this.checkSchema(connection);
        this.buildSQLStatements();
        this.closeMyConnection(connection);
        if (this.externalBLOBs) {
            LocalFileSystem blobFS = new LocalFileSystem();
            blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
            blobFS.init();
            this.blobFS = blobFS;
            this.blobStore = new FileSystemBLOBStore(blobFS);
        } else {
            this.blobStore = new DbBLOBStore();
        }
        this.initialized = true;
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.externalBLOBs) {
                this.blobFS.close();
                this.blobFS = null;
            }
            this.blobStore = null;
        }
        finally {
            this.initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        block11: {
            this.autoReconnect = false;
            Connection connection = null;
            try {
                connection = this.getMyConnection();
                ItemStateException ise = null;
                int trials = 2;
                while (trials > 0) {
                    try {
                        this.store2(connection, changeLog);
                        break;
                    }
                    catch (ItemStateException e) {
                        ise = e;
                        if (ise == null || !(ise.getCause() instanceof SQLException)) break;
                        if (--trials <= 0) continue;
                        log.warn("storing changes failed, about to reconnect...", ise.getCause());
                    }
                }
                if (ise == null) {
                    try {
                        connection.commit();
                        break block11;
                    }
                    catch (SQLException e) {
                        String msg = "committing change log failed";
                        log.error(msg, (Throwable)e);
                        throw new ItemStateException(msg, e);
                    }
                }
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    String msg = "rollback of change log failed";
                    log.error(msg, (Throwable)e);
                }
                throw ise;
            }
            finally {
                this.autoReconnect = true;
                this.closeMyConnection(connection);
            }
        }
    }

    public synchronized void store2(Connection connection, ChangeLog changeLog) throws ItemStateException {
        ItemState state;
        Iterator iter = changeLog.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.destroy2(connection, (NodeState)state);
                continue;
            }
            this.destroy2(connection, (PropertyState)state);
        }
        iter = changeLog.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.store2(connection, (NodeState)state);
                continue;
            }
            this.store2(connection, (PropertyState)state);
        }
        iter = changeLog.modifiedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode()) {
                this.store2(connection, (NodeState)state);
                continue;
            }
            this.store2(connection, (PropertyState)state);
        }
        iter = changeLog.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            if (refs.hasReferences()) {
                this.store2(connection, refs);
                continue;
            }
            if (!this.exists2(connection, refs.getId())) continue;
            this.destroy2(connection, refs);
        }
    }

    @Override
    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeStateSelectSQL;
        synchronized (string) {
            NodeState nodeState;
            Connection connection = this.getMyConnection();
            ResultSet rs = null;
            InputStream in = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeStateSelectSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(id.toString());
                }
                in = rs.getBinaryStream(1);
                NodeState state = this.createNew(id);
                Serializer.deserialize(state, in);
                nodeState = state;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read node state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return nodeState;
        }
    }

    @Override
    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.propertyStateSelectSQL;
        synchronized (string) {
            PropertyState propertyState;
            Connection connection = this.getMyConnection();
            ResultSet rs = null;
            InputStream in = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.propertyStateSelectSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(id.toString());
                }
                in = rs.getBinaryStream(1);
                PropertyState state = this.createNew(id);
                Serializer.deserialize2(connection, state, in, this.blobStore);
                propertyState = state;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read property state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return propertyState;
        }
    }

    @Override
    public synchronized void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.nodeStateUpdateSQL : this.nodeStateInsertSQL;
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), state.getNodeId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node state: " + state.getNodeId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.propertyStateUpdateSQL : this.propertyStateInsertSQL;
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize2(connection, state, out, this.blobStore);
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), state.getPropertyId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write property state: " + state.getPropertyId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.nodeStateDeleteSQL, new Object[]{state.getNodeId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete node state: " + state.getNodeId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null || val.getType() != 2) continue;
                BLOBFileValue blobVal = val.getBLOBFileValue();
                blobVal.delete(true);
                String blobId = this.blobStore.createId(state.getPropertyId(), i);
                try {
                    this.blobStore.remove(blobId);
                    continue;
                }
                catch (Exception e) {
                    log.warn("failed to remove from BLOBStore: " + blobId, (Throwable)e);
                }
            }
        }
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.propertyStateDeleteSQL, new Object[]{state.getPropertyId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete property state: " + state.getPropertyId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    public synchronized void store2(Connection connection, NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.nodeStateUpdateSQL : this.nodeStateInsertSQL;
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), state.getNodeId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node state: " + state.getNodeId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    public synchronized void store2(Connection connection, PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        String sql = update ? this.propertyStateUpdateSQL : this.propertyStateInsertSQL;
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            if (this.blobStore instanceof DbBLOBStore) {
                Serializer.serialize2(connection, state, out, this.blobStore);
            } else {
                Serializer.serialize(state, out, this.blobStore);
            }
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), state.getPropertyId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write property state: " + state.getPropertyId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    public synchronized void destroy2(Connection connection, NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.nodeStateDeleteSQL, new Object[]{state.getNodeId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete node state: " + state.getNodeId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    public synchronized void destroy2(Connection connection, PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                if (val == null || val.getType() != 2) continue;
                BLOBFileValue blobVal = val.getBLOBFileValue();
                blobVal.delete(true);
                String blobId = this.blobStore.createId(state.getPropertyId(), i);
                try {
                    if (this.blobStore instanceof DbBLOBStore) {
                        DbBLOBStore dbStore = (DbBLOBStore)this.blobStore;
                        dbStore.remove2(connection, blobId);
                        continue;
                    }
                    this.blobStore.remove(blobId);
                    continue;
                }
                catch (Exception e) {
                    log.warn("failed to remove from BLOBStore: " + blobId, (Throwable)e);
                }
            }
        }
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.propertyStateDeleteSQL, new Object[]{state.getPropertyId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete property state: " + state.getPropertyId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    @Override
    public NodeReferences load(NodeReferencesId targetId) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeReferenceSelectSQL;
        synchronized (string) {
            NodeReferences nodeReferences;
            ResultSet rs = null;
            InputStream in = null;
            Connection connection = this.getMyConnection();
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeReferenceSelectSQL, new Object[]{targetId.toString()});
                rs = stmt.getResultSet();
                if (!rs.next()) {
                    throw new NoSuchItemStateException(targetId.toString());
                }
                in = rs.getBinaryStream(1);
                NodeReferences refs = new NodeReferences(targetId);
                Serializer.deserialize(refs, in);
                nodeReferences = refs;
                this.closeStream(in);
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    if (e instanceof NoSuchItemStateException) {
                        throw (NoSuchItemStateException)e;
                    }
                    String msg = "failed to read node references: " + targetId;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeStream(in);
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return nodeReferences;
        }
    }

    @Override
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists(refs.getId());
        String sql = update ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), refs.getId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Connection connection = this.getMyConnection();
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.nodeReferenceDeleteSQL, new Object[]{refs.getId().toString()});
            this.closeStatement(stmt);
            this.closeMyConnection(connection);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
                throw throwable;
            }
        }
    }

    public synchronized void store2(Connection connection, NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists2(connection, refs.getId());
        String sql = update ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        Statement stmt = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            stmt = this.executeStmt(connection, sql, new Object[]{out.toByteArray(), refs.getId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    public synchronized void destroy2(Connection connection, NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Statement stmt = null;
        try {
            stmt = this.executeStmt(connection, this.nodeReferenceDeleteSQL, new Object[]{refs.getId().toString()});
            this.closeStatement(stmt);
        }
        catch (Exception e) {
            try {
                String msg = "failed to delete node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    @Override
    public boolean exists(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeStateSelectExistSQL;
        synchronized (string) {
            boolean bl;
            Connection connection = this.getMyConnection();
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeStateSelectExistSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean exists2(Connection connection, NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeStateSelectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeStateSelectExistSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    @Override
    public boolean exists(PropertyId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.propertyStateSelectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            Statement stmt = null;
            Connection connection = this.getMyConnection();
            try {
                stmt = this.executeStmt(connection, this.propertyStateSelectExistSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of property state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean exists2(Connection connection, PropertyId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.propertyStateSelectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.propertyStateSelectExistSQL, new Object[]{id.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of property state: " + id;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    @Override
    public boolean exists(NodeReferencesId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeReferenceSelectExistSQL;
        synchronized (string) {
            boolean bl;
            Connection connection = this.getMyConnection();
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeReferenceSelectExistSQL, new Object[]{targetId.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
                this.closeMyConnection(connection);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node references: " + targetId;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    this.closeMyConnection(connection);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    public boolean exists2(Connection connection, NodeReferencesId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        String string = this.nodeReferenceSelectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            Statement stmt = null;
            try {
                stmt = this.executeStmt(connection, this.nodeReferenceSelectExistSQL, new Object[]{targetId.toString()});
                rs = stmt.getResultSet();
                bl = rs.next();
                this.closeResultSet(rs);
                this.closeStatement(stmt);
            }
            catch (Exception e) {
                try {
                    String msg = "failed to check existence of node references: " + targetId;
                    log.error(msg, (Throwable)e);
                    throw new ItemStateException(msg, e);
                }
                catch (Throwable throwable) {
                    this.closeResultSet(rs);
                    this.closeStatement(stmt);
                    throw throwable;
                }
            }
            return bl;
        }
    }

    protected Connection getConnection() throws Exception {
        throw new UnsupportedOperationException("Override in a subclass!");
    }

    protected void closeConnection(Connection connection) throws Exception {
        throw new UnsupportedOperationException("Override in a subclass!");
    }

    protected Statement executeStmt(Connection connection, String sql, Object[] params) throws SQLException {
        int trials = this.autoReconnect ? 2 : 1;
        block2: while (true) {
            PreparedStatement stmt = connection.prepareStatement(sql);
            try {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] instanceof SizedInputStream) {
                        SizedInputStream in = (SizedInputStream)params[i];
                        stmt.setBinaryStream(i + 1, (InputStream)in, (int)in.getSize());
                        continue;
                    }
                    stmt.setObject(i + 1, params[i]);
                }
                stmt.execute();
                this.resetStatement(stmt);
                return stmt;
            }
            catch (SQLException se) {
                if (--trials == 0) {
                    throw se;
                }
                log.warn("execute failed, about to reconnect...", (Object)se.getMessage());
                int i = 0;
                while (true) {
                    SizedInputStream in;
                    if (i >= params.length) continue block2;
                    if (params[i] instanceof SizedInputStream && (in = (SizedInputStream)params[i]).isConsumed()) {
                        throw se;
                    }
                    ++i;
                }
            }
            break;
        }
    }

    protected void resetStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearParameters();
                stmt.clearWarnings();
            }
            catch (SQLException se) {
                this.logException("failed resetting PreparedStatement", se);
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                this.logException("failed closing ResultSet", se);
            }
        }
    }

    protected void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                this.logException("failed closing Statement", se);
            }
        }
    }

    protected void logException(String message, SQLException se) {
        if (message != null) {
            log.error(message);
        }
        log.error("    reason: " + se.getMessage());
        log.error("state/code: " + se.getSQLState() + "/" + se.getErrorCode());
        log.debug("      dump:", (Throwable)se);
    }

    protected void prepareSchemaObjectPrefix(Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append("_x");
                String hex = Integer.toHexString(c);
                escaped.append("0000".toCharArray(), 0, 4 - hex.length());
                escaped.append(hex);
                escaped.append("_");
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema(Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        String tableName = this.schemaObjectPrefix + "NODE";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        String sql_TableExist = "SELECT count(1) FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + tableName + "'";
        boolean schemaExists = false;
        try (ResultSet rs = DBUtil.executeSql((Connection)connection, (String)sql_TableExist);){
            if (rs.next() && rs.getInt(1) > 0) {
                schemaExists = true;
            }
        }
        if (!schemaExists) {
            InputStream in = this.getSchemaDDL();
            if (in == null) {
                String msg = "Configuration error: unknown schema '" + this.schema + "'";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = connection.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = Text.replace(sql, SCHEMA_OBJECT_PREFIX_VARIABLE, this.schemaObjectPrefix);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
                connection.commit();
            }
            finally {
                this.closeStream(in);
                this.closeStatement(stmt);
            }
        }
    }

    protected InputStream getSchemaDDL() {
        return DatabasePersistenceManager.class.getResourceAsStream(this.schema + ".ddl");
    }

    protected void buildSQLStatements() {
        this.nodeStateInsertSQL = "insert into " + this.schemaObjectPrefix + "NODE (NODE_DATA, NODE_ID) values (?, ?)";
        this.nodeStateUpdateSQL = "update " + this.schemaObjectPrefix + "NODE set NODE_DATA = ? where NODE_ID = ?";
        this.nodeStateSelectSQL = "select NODE_DATA from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?";
        this.nodeStateSelectExistSQL = "select 1 from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?";
        this.nodeStateDeleteSQL = "delete from " + this.schemaObjectPrefix + "NODE where NODE_ID = ?";
        this.propertyStateInsertSQL = "insert into " + this.schemaObjectPrefix + "PROP (PROP_DATA, PROP_ID) values (?, ?)";
        this.propertyStateUpdateSQL = "update " + this.schemaObjectPrefix + "PROP set PROP_DATA = ? where PROP_ID = ?";
        this.propertyStateSelectSQL = "select PROP_DATA from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?";
        this.propertyStateSelectExistSQL = "select 1 from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?";
        this.propertyStateDeleteSQL = "delete from " + this.schemaObjectPrefix + "PROP where PROP_ID = ?";
        this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID) values (?, ?)";
        this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ?";
        this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
        this.nodeReferenceSelectExistSQL = "select 1 from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
        this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
        if (!this.externalBLOBs) {
            this.blobInsertSQL = "insert into " + this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID) values (?, ?)";
            this.blobUpdateSQL = "update " + this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ?";
            this.blobSelectSQL = "select BINVAL_DATA from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobSelectExistSQL = "select 1 from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobDeleteSQL = "delete from " + this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
        }
    }

    class DbBLOBStore
    implements BLOBStore {
        DbBLOBStore() {
        }

        @Override
        public String createId(PropertyId id, int index) {
            StringBuffer sb = new StringBuffer();
            sb.append(id.toString());
            sb.append('[');
            sb.append(index);
            sb.append(']');
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public InputStream get(String blobId) throws Exception {
            FilterInputStream filterInputStream;
            InputStream in;
            ResultSet rs;
            Connection connection = DatabasePersistenceManager.this.getMyConnection();
            Statement stmt = null;
            try {
                String string = DatabasePersistenceManager.this.blobSelectSQL;
                synchronized (string) {
                    stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobSelectSQL, new Object[]{blobId});
                    rs = stmt.getResultSet();
                    if (!rs.next()) {
                        DatabasePersistenceManager.this.closeResultSet(rs);
                        throw new Exception("no such BLOB: " + blobId);
                    }
                    in = rs.getBinaryStream(1);
                    if (in == null) {
                        DatabasePersistenceManager.this.closeResultSet(rs);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                        DatabasePersistenceManager.this.closeStatement(stmt);
                        DatabasePersistenceManager.this.closeMyConnection(connection);
                        return byteArrayInputStream;
                    }
                }
            }
            catch (Throwable throwable) {
                DatabasePersistenceManager.this.closeStatement(stmt);
                DatabasePersistenceManager.this.closeMyConnection(connection);
                throw throwable;
            }
            {
                filterInputStream = new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                        this.in.close();
                        DatabasePersistenceManager.this.closeResultSet(rs);
                    }
                };
            }
            DatabasePersistenceManager.this.closeStatement(stmt);
            DatabasePersistenceManager.this.closeMyConnection(connection);
            return filterInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            Connection connection = DatabasePersistenceManager.this.getMyConnection();
            Statement stmt = null;
            try {
                stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobSelectExistSQL, new Object[]{blobId});
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                DatabasePersistenceManager.this.closeResultSet(rs);
                String sql = exists ? DatabasePersistenceManager.this.blobUpdateSQL : DatabasePersistenceManager.this.blobInsertSQL;
                stmt = DatabasePersistenceManager.this.executeStmt(connection, sql, new Object[]{new SizedInputStream(in, size), blobId});
                DatabasePersistenceManager.this.closeStatement(stmt);
                DatabasePersistenceManager.this.closeMyConnection(connection);
            }
            catch (Throwable throwable) {
                DatabasePersistenceManager.this.closeStatement(stmt);
                DatabasePersistenceManager.this.closeMyConnection(connection);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean remove(String blobId) throws Exception {
            Connection connection = DatabasePersistenceManager.this.getMyConnection();
            Statement stmt = null;
            try {
                stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobDeleteSQL, new Object[]{blobId});
                boolean bl = stmt.getUpdateCount() == 1;
                DatabasePersistenceManager.this.closeStatement(stmt);
                DatabasePersistenceManager.this.closeMyConnection(connection);
                return bl;
            }
            catch (Throwable throwable) {
                DatabasePersistenceManager.this.closeStatement(stmt);
                DatabasePersistenceManager.this.closeMyConnection(connection);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean remove2(Connection connection, String blobId) throws Exception {
            Statement stmt = null;
            try {
                stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobDeleteSQL, new Object[]{blobId});
                boolean bl = stmt.getUpdateCount() == 1;
                return bl;
            }
            finally {
                if (null != stmt) {
                    stmt.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public InputStream get2(Connection connection, String blobId) throws Exception {
            String string = DatabasePersistenceManager.this.blobSelectSQL;
            synchronized (string) {
                InputStream in;
                ResultSet rs;
                Statement stmt;
                block6: {
                    ByteArrayInputStream byteArrayInputStream;
                    stmt = null;
                    try {
                        stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobSelectSQL, new Object[]{blobId});
                        rs = stmt.getResultSet();
                        if (!rs.next()) {
                            DatabasePersistenceManager.this.closeResultSet(rs);
                            throw new Exception("no such BLOB: " + blobId);
                        }
                        in = rs.getBinaryStream(1);
                        if (in != null) break block6;
                        DatabasePersistenceManager.this.closeResultSet(rs);
                        byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                        DatabasePersistenceManager.this.closeStatement(stmt);
                    }
                    catch (Throwable throwable) {
                        DatabasePersistenceManager.this.closeStatement(stmt);
                        throw throwable;
                    }
                    return byteArrayInputStream;
                }
                FilterInputStream filterInputStream = new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                        this.in.close();
                        DatabasePersistenceManager.this.closeResultSet(rs);
                    }
                };
                DatabasePersistenceManager.this.closeStatement(stmt);
                return filterInputStream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put2(Connection connection, String blobId, InputStream in, long size) throws Exception {
            Statement stmt = null;
            try {
                stmt = DatabasePersistenceManager.this.executeStmt(connection, DatabasePersistenceManager.this.blobSelectExistSQL, new Object[]{blobId});
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                DatabasePersistenceManager.this.closeResultSet(rs);
                String sql = exists ? DatabasePersistenceManager.this.blobUpdateSQL : DatabasePersistenceManager.this.blobInsertSQL;
                stmt = DatabasePersistenceManager.this.executeStmt(connection, sql, new Object[]{new SizedInputStream(in, size), blobId});
                DatabasePersistenceManager.this.closeStatement(stmt);
            }
            catch (Throwable throwable) {
                DatabasePersistenceManager.this.closeStatement(stmt);
                throw throwable;
            }
        }
    }

    class SizedInputStream
    extends FilterInputStream {
        private final long size;
        private boolean consumed;

        SizedInputStream(InputStream in, long size) {
            super(in);
            this.consumed = false;
            this.size = size;
        }

        long getSize() {
            return this.size;
        }

        boolean isConsumed() {
            return this.consumed;
        }

        @Override
        public int read() throws IOException {
            this.consumed = true;
            return super.read();
        }

        @Override
        public long skip(long n) throws IOException {
            this.consumed = true;
            return super.skip(n);
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.consumed = true;
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.consumed = true;
            return super.read(b, off, len);
        }
    }
}

