/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;

public class FileSystemBLOBStore
implements ResourceBasedBLOBStore {
    private final FileSystem fs;

    public FileSystemBLOBStore(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public String createId(PropertyId id, int index) {
        StringBuffer sb = new StringBuffer();
        sb.append('/');
        char[] chars = id.getParentId().getUUID().toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                sb.append('/');
            }
            sb.append(chars[i]);
            ++cnt;
        }
        sb.append('/');
        sb.append(FileSystemPathUtil.escapeName(id.getName().toString()));
        sb.append('.');
        sb.append(index);
        sb.append(".bin");
        return sb.toString();
    }

    @Override
    public InputStream get(String blobId) throws Exception {
        return this.getResource(blobId).getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String blobId, InputStream in, long size) throws Exception {
        BufferedOutputStream out = null;
        FileSystemResource internalBlobFile = new FileSystemResource(this.fs, blobId);
        internalBlobFile.makeParentDirs();
        try {
            int read;
            out = new BufferedOutputStream(internalBlobFile.getOutputStream());
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    public boolean remove(String blobId) throws Exception {
        FileSystemResource res = new FileSystemResource(this.fs, blobId);
        if (!res.exists()) {
            return false;
        }
        res.delete(true);
        return true;
    }

    @Override
    public FileSystemResource getResource(String blobId) throws Exception {
        return new FileSystemResource(this.fs, blobId);
    }

    @Override
    public InputStream get2(Connection con, String blobId) throws Exception {
        return null;
    }

    @Override
    public void put2(Connection con, String blobId, InputStream in, long size) throws Exception {
    }

    @Override
    public boolean remove2(Connection con, String blobId) throws Exception {
        return false;
    }
}

