/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.ExecutablePreparedQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.query.jsr283.PreparedQuery;
import org.apache.jackrabbit.core.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class PreparedQueryImpl
extends QueryImpl
implements PreparedQuery {
    protected ExecutablePreparedQuery prepQuery;
    protected QueryObjectModelTree qomTree;

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.language = language;
        this.handler = handler;
        this.statement = statement;
        this.setExecutableQuery(handler.createExecutablePreparedQuery(session, itemMgr, this.createQOMTree(statement, language)));
        this.setInitialized();
    }

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        if (!node.isNodeType(session.getJCRName(NameConstants.NT_QUERY))) {
            throw new InvalidQueryException("node is not of type nt:query");
        }
        this.statement = node.getProperty(session.getJCRName(NameConstants.JCR_STATEMENT)).getString();
        this.language = node.getProperty(session.getJCRName(NameConstants.JCR_LANGUAGE)).getString();
        this.setExecutableQuery(handler.createExecutablePreparedQuery(session, itemMgr, this.createQOMTree(this.statement, this.language)));
        this.setInitialized();
    }

    @Override
    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, QueryObjectModelTree qomTree, String language) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.language = language;
        this.handler = handler;
        this.qomTree = qomTree;
        this.statement = null;
        this.setExecutableQuery(handler.createExecutablePreparedQuery(session, itemMgr, qomTree));
        this.setInitialized();
    }

    @Override
    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        try {
            this.prepQuery.bindValue(this.session.getQName(varName), value);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    private void setExecutableQuery(ExecutablePreparedQuery query) {
        this.query = query;
        this.prepQuery = query;
    }

    private QueryObjectModelTree createQOMTree(String statement, String language) throws InvalidQueryException {
        return null;
    }
}

