/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.MultiScorer;

abstract class AbstractWeight
implements Weight {
    protected final Searcher searcher;

    public AbstractWeight(Searcher searcher) {
        this.searcher = searcher;
    }

    protected abstract Scorer createScorer(IndexReader var1) throws IOException;

    @Override
    public Scorer scorer(IndexReader reader) throws IOException {
        if (reader instanceof MultiIndexReader) {
            MultiIndexReader mir = (MultiIndexReader)((Object)reader);
            IndexReader[] readers = mir.getIndexReaders();
            int[] starts = new int[readers.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < readers.length; ++i) {
                starts[i] = maxDoc;
                maxDoc += readers[i].maxDoc();
            }
            starts[readers.length] = maxDoc;
            Scorer[] scorers = new Scorer[readers.length];
            for (int i = 0; i < readers.length; ++i) {
                scorers[i] = this.scorer(readers[i]);
            }
            return new MultiScorer(this.searcher.getSimilarity(), scorers, starts);
        }
        return this.createScorer(reader);
    }
}

