/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.BooleanQuery;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.AbstractWeight;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.OffsetCharSequence;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.slf4j.Logger;

public class RangeQuery
extends Query
implements Transformable {
    private static final Logger log = CommonSLF4JLogger.getLogger(RangeQuery.class);
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;
    private int transform = 0;
    private Query stdRangeQuery;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        this(lowerTerm, upperTerm, inclusive, 0);
    }

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive, int transform) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field(), "");
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
        this.transform = transform;
    }

    @Override
    public void setTransformation(int transformation) {
        this.transform = transformation;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.transform == 0) {
            com.kingdee.bos.ctrl.lucene.search.RangeQuery stdRangeQueryImpl = new com.kingdee.bos.ctrl.lucene.search.RangeQuery(this.lowerTerm, this.upperTerm, this.inclusive);
            try {
                this.stdRangeQuery = ((Query)stdRangeQueryImpl).rewrite(reader);
                return this.stdRangeQuery;
            }
            catch (BooleanQuery.TooManyClauses e) {
                log.debug("Too many terms to enumerate, using custom RangeQuery");
                return this;
            }
        }
        return this;
    }

    @Override
    protected Weight createWeight(Searcher searcher) {
        return new RangeQueryWeight(searcher);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    @Override
    public void extractTerms(Set terms) {
        if (this.stdRangeQuery != null) {
            this.stdRangeQuery.extractTerms(terms);
        }
    }

    private String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    private final class RangeQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map resultMap;

        RangeQueryScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            StringBuffer key = new StringBuffer();
            key.append(RangeQuery.this.lowerTerm != null ? RangeQuery.this.lowerTerm.field() : RangeQuery.this.upperTerm.field());
            key.append('\uffff');
            key.append(RangeQuery.this.lowerTerm != null ? RangeQuery.this.lowerTerm.text() : "");
            key.append('\uffff');
            key.append(RangeQuery.this.upperTerm != null ? RangeQuery.this.upperTerm.text() : "");
            key.append('\uffff');
            key.append(RangeQuery.this.inclusive);
            key.append('\uffff');
            key.append(RangeQuery.this.transform);
            this.cacheKey = key.toString();
            PerQueryCache cache = PerQueryCache.getInstance();
            HashMap m = (HashMap)cache.get(RangeQueryScorer.class, reader);
            if (m == null) {
                m = new HashMap();
                cache.put(RangeQueryScorer.class, reader, m);
            }
            this.resultMap = m;
            BitSet result = (BitSet)this.resultMap.get(this.cacheKey);
            if (result == null) {
                result = new BitSet(reader.maxDoc());
            } else {
                this.hitsCalculated = true;
            }
            this.hits = result;
        }

        @Override
        public boolean next() throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        @Override
        public int doc() {
            return this.nextDoc;
        }

        @Override
        public float score() {
            return 1.0f;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        @Override
        public Explanation explain(int doc) {
            return new Explanation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            String testField = RangeQuery.this.getField();
            boolean checkLower = false;
            if (!RangeQuery.this.inclusive || RangeQuery.this.transform != 0) {
                checkLower = true;
            }
            int propNameLength = FieldNames.getNameLength(RangeQuery.this.lowerTerm.text());
            String namePrefix = "";
            if (propNameLength > 0) {
                namePrefix = RangeQuery.this.lowerTerm.text().substring(0, propNameLength);
            }
            ArrayList<Term> startTerms = new ArrayList<Term>(2);
            if (RangeQuery.this.transform == 0 || RangeQuery.this.lowerTerm.text().length() <= propNameLength) {
                startTerms.add(RangeQuery.this.lowerTerm);
            } else {
                StringBuffer termText = new StringBuffer(propNameLength + 1);
                termText.append(RangeQuery.this.lowerTerm.text().subSequence(0, propNameLength));
                char startCharacter = RangeQuery.this.lowerTerm.text().charAt(propNameLength);
                termText.append(Character.toLowerCase(startCharacter));
                startTerms.add(new Term(RangeQuery.this.lowerTerm.field(), termText.toString()));
                termText.setCharAt(termText.length() - 1, Character.toUpperCase(startCharacter));
                startTerms.add(new Term(RangeQuery.this.lowerTerm.field(), termText.toString()));
            }
            block6: for (Term startTerm : startTerms) {
                try (TermEnum terms = this.reader.terms(startTerm);
                     TermDocs docs = this.reader.termDocs();){
                    Term term;
                    while ((term = terms.term()) != null && term.field() == testField && term.text().startsWith(namePrefix)) {
                        block20: {
                            int compare;
                            block19: {
                                if (!checkLower) break block19;
                                compare = this.termCompare(term.text(), RangeQuery.this.lowerTerm.text(), propNameLength);
                                if (compare <= 0 && (compare != 0 || !RangeQuery.this.inclusive)) break block20;
                                boolean bl = checkLower = RangeQuery.this.transform != 0;
                            }
                            if (RangeQuery.this.upperTerm != null && ((compare = this.termCompare(term.text(), RangeQuery.this.upperTerm.text(), propNameLength)) > 0 || !RangeQuery.this.inclusive && compare == 0)) {
                                if (RangeQuery.this.transform == 0 || !term.text().startsWith(namePrefix)) continue block6;
                            } else {
                                docs.seek(terms);
                                while (docs.next()) {
                                    this.hits.set(docs.doc());
                                }
                            }
                        }
                        if (terms.next()) continue;
                        continue block6;
                    }
                }
            }
            this.hitsCalculated = true;
            this.resultMap.put(this.cacheKey, this.hits);
        }

        private int termCompare(String text, String other, int offset) {
            OffsetCharSequence seq1 = new OffsetCharSequence(offset, text, RangeQuery.this.transform);
            OffsetCharSequence seq2 = new OffsetCharSequence(offset, other);
            return seq1.compareTo(seq2);
        }
    }

    private class RangeQueryWeight
    extends AbstractWeight {
        RangeQueryWeight(Searcher searcher) {
            super(searcher);
        }

        @Override
        protected Scorer createScorer(IndexReader reader) {
            return new RangeQueryScorer(this.searcher.getSimilarity(), reader);
        }

        @Override
        public Query getQuery() {
            return RangeQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

