/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.IOException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.jackrabbit.core.security.CredentialsCallback;

public class CredentialsCallbackHandler
implements CallbackHandler {
    protected final Credentials credentials;

    public CredentialsCallbackHandler(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            SimpleCredentials sc;
            if (callbacks[i] instanceof CredentialsCallback) {
                CredentialsCallback ccb = (CredentialsCallback)callbacks[i];
                ccb.setCredentials(this.credentials);
                continue;
            }
            if (callbacks[i] instanceof NameCallback && this.credentials instanceof SimpleCredentials) {
                NameCallback ncb = (NameCallback)callbacks[i];
                sc = (SimpleCredentials)this.credentials;
                ncb.setName(sc.getUserID());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback && this.credentials instanceof SimpleCredentials) {
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                sc = (SimpleCredentials)this.credentials;
                pcb.setPassword(sc.getPassword());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

