/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.slf4j.Logger;

public abstract class ItemState
implements Serializable {
    static final long serialVersionUID = -1473610775880779769L;
    private static Logger log = CommonSLF4JLogger.getLogger(ItemState.class);
    public static final int STATUS_UNDEFINED = 0;
    public static final int STATUS_EXISTING = 1;
    public static final int STATUS_EXISTING_MODIFIED = 2;
    public static final int STATUS_EXISTING_REMOVED = 3;
    public static final int STATUS_NEW = 4;
    public static final int STATUS_STALE_MODIFIED = 5;
    public static final int STATUS_STALE_DESTROYED = 6;
    protected int status = 0;
    private short modCount;
    private final boolean isTransient;
    private transient ItemStateListener container;
    protected transient ItemState overlayedState;

    protected ItemState(int initialStatus, boolean isTransient) {
        switch (initialStatus) {
            case 1: 
            case 4: {
                this.status = initialStatus;
                break;
            }
            default: {
                String msg = "illegal status: " + initialStatus;
                log.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.modCount = 0;
        this.overlayedState = null;
        this.isTransient = isTransient;
    }

    protected ItemState(ItemState overlayedState, int initialStatus, boolean isTransient) {
        switch (initialStatus) {
            case 1: 
            case 2: 
            case 3: {
                this.status = initialStatus;
                break;
            }
            case 0: {
                log.debug("creating ItemState instance with initialStatus=0, id=" + overlayedState.getId());
                this.status = initialStatus;
                break;
            }
            default: {
                String msg = "illegal status: " + initialStatus;
                log.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.isTransient = isTransient;
        this.connect(overlayedState);
    }

    protected abstract void copy(ItemState var1, boolean var2);

    void pull() {
        ItemState state = this.overlayedState;
        if (state != null) {
            this.copy(state, true);
        }
    }

    void push() {
        ItemState state = this.overlayedState;
        if (state != null) {
            state.copy(this, false);
        }
    }

    void onDisposed() {
        this.disconnect();
        this.overlayedState = null;
        this.status = 0;
    }

    protected void connect(ItemState overlayedState) {
        if (this.overlayedState != null && this.overlayedState != overlayedState) {
            throw new IllegalStateException("Item state already connected to another underlying state: " + this);
        }
        this.overlayedState = overlayedState;
    }

    protected void reconnect() {
        if (this.overlayedState == null) {
            throw new IllegalStateException("Item state cannot be reconnected because there's no underlying state to reconnect to: " + this);
        }
    }

    protected void disconnect() {
        if (this.overlayedState != null) {
            this.overlayedState = null;
        }
    }

    protected boolean isConnected() {
        return this.overlayedState != null;
    }

    protected void notifyStateDiscarded() {
        if (this.container != null) {
            this.container.stateDiscarded(this);
        }
    }

    protected void notifyStateCreated() {
        if (this.container != null) {
            this.container.stateCreated(this);
        }
    }

    public void notifyStateUpdated() {
        if (this.container != null) {
            this.container.stateModified(this);
        }
    }

    protected void notifyStateDestroyed() {
        if (this.container != null) {
            this.container.stateDestroyed(this);
        }
    }

    public abstract boolean isNode();

    public abstract ItemId getId();

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isStale() {
        if (this.isTransient) {
            return this.status == 5 || this.status == 6;
        }
        return this.overlayedState != null && this.modCount != this.overlayedState.getModCount();
    }

    public abstract NodeId getParentId();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int newStatus) {
        switch (newStatus) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.status = newStatus;
                return;
            }
        }
        String msg = "illegal status: " + newStatus;
        log.debug(msg);
        throw new IllegalArgumentException(msg);
    }

    public short getModCount() {
        return this.modCount;
    }

    public void setModCount(short modCount) {
        this.modCount = modCount;
    }

    synchronized void touch() {
        this.modCount = (short)(this.modCount + 1);
    }

    public void discard() {
        if (this.status != 0) {
            this.notifyStateDiscarded();
            this.status = 0;
        }
    }

    public boolean hasOverlayedState() {
        return this.overlayedState != null;
    }

    public ItemState getOverlayedState() {
        return this.overlayedState;
    }

    public void setContainer(ItemStateListener container) {
        if (this.container != null) {
            throw new IllegalStateException("State already connected to a container: " + this.container);
        }
        this.container = container;
    }

    public ItemStateListener getContainer() {
        return this.container;
    }

    public abstract long calculateMemoryFootprint();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

