/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.datasource;

import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import org.jdom2.Content;
import org.jdom2.Element;

public final class EntityDataSource
extends DataSource {
    private String source;
    private String encoding = "UNICODE";
    private boolean linked = false;
    private int type = -1;
    public static final int TYPE_CUSTOM = -1;
    public static final int TYPE_XML = 0;
    public static final int TYPE_CSV = 1;

    public EntityDataSource() {
    }

    public EntityDataSource(String id, boolean isLinked, String source) {
        super(id);
        this.linked = isLinked;
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    @Override
    public Object readFromNode(Element ele) {
        Element eleEntity;
        String src;
        Element eleSource;
        String type;
        this.setID(ele.getAttributeValue("id").trim());
        Element dsn = ele.getChild("DesignedDataSource", ele.getNamespace());
        if (dsn != null) {
            this.setUserObject(dsn.clone());
        }
        if ((type = (eleSource = ele.getChild("EntityDataSource", ele.getNamespace())).getAttributeValue("type")) != null) {
            if (type.equalsIgnoreCase("xml")) {
                this.type = 0;
            } else if (type.equalsIgnoreCase("csv")) {
                this.type = 1;
            }
        }
        if ((src = (eleEntity = eleSource.getChild("Entity", ele.getNamespace())).getAttributeValue("src")) != null && src.trim().length() > 0) {
            this.linked = true;
            this.setSource(src);
        } else {
            this.setSource(eleEntity.getTextTrim());
        }
        this.setParams(this.resolveParamsNode(eleSource));
        return this;
    }

    @Override
    public Element writeToNode() {
        Element eleDS = this.createDSNode();
        eleDS.setAttribute("id", this.getID());
        Element eleSource = new Element("EntityDataSource", eleDS.getNamespace());
        switch (this.type) {
            case 0: {
                eleSource.setAttribute("type", "xml");
                break;
            }
            case 1: {
                eleSource.setAttribute("type", "csv");
                break;
            }
            default: {
                eleSource.setAttribute("type", "custom");
            }
        }
        eleDS.addContent((Content)eleSource);
        if (this.getUserObject() instanceof Element) {
            eleDS.addContent((Content)((Element)this.getUserObject()));
        }
        Element eleEntity = new Element("Entity", eleSource.getNamespace());
        if (this.isLinked()) {
            eleEntity.setAttribute("src", this.source);
        } else {
            eleEntity.setText(this.source);
        }
        eleSource.addContent((Content)eleEntity);
        eleSource.addContent((Content)this.buildParamsNode(eleSource.getNamespace()));
        return eleDS;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getType() {
        return this.type;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public void setType(int type) {
        this.type = type;
    }
}

